/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.li64.tide.data.rods.ModifierType;
import com.li64.tide.data.rods.TideAccessoryData;
import com.li64.tide.registries.TideItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CustomRodManager {
    private static final ItemStack DEFAULT_BOBBER = TideItems.RED_FISHING_BOBBER.m_7968_();
    private static final ItemStack DEFAULT_HOOK = TideItems.FISHING_HOOK.m_7968_();
    private static final ItemStack DEFAULT_LINE = TideItems.FISHING_LINE.m_7968_();

    private static void createModifierTag(ItemStack stack) {
        CompoundTag modifierTag = new CompoundTag();
        modifierTag.m_128359_("bobber", BuiltInRegistries.f_257033_.m_7981_((Object)DEFAULT_BOBBER.m_41720_()).toString());
        modifierTag.m_128359_("hook", BuiltInRegistries.f_257033_.m_7981_((Object)DEFAULT_HOOK.m_41720_()).toString());
        modifierTag.m_128359_("line", BuiltInRegistries.f_257033_.m_7981_((Object)DEFAULT_LINE.m_41720_()).toString());
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128365_("modifier", (Tag)modifierTag);
    }

    private static void updateModifiers(ItemStack stack) {
        if (!CustomRodManager.hasModifierTag(stack)) {
            CustomRodManager.createModifierTag(stack);
        }
    }

    public static void setBobber(ItemStack stack, ItemStack bobber) {
        CustomRodManager.setModifier(stack, ModifierType.BOBBER, bobber.m_41720_());
    }

    public static void setHook(ItemStack stack, ItemStack hook) {
        CustomRodManager.setModifier(stack, ModifierType.HOOK, hook.m_41720_());
    }

    public static void setLine(ItemStack stack, ItemStack line) {
        CustomRodManager.setModifier(stack, ModifierType.LINE, line.m_41720_());
    }

    public static void setModifier(ItemStack stack, ModifierType modifier, Item value) {
        CustomRodManager.updateModifiers(stack);
        CustomRodManager.getModifierTag(stack).m_128359_(modifier.getID(), BuiltInRegistries.f_257033_.m_7981_((Object)value).toString());
    }

    public static boolean hasModifierTag(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("modifier");
    }

    public static CompoundTag getModifierTag(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        return (CompoundTag)stack.m_41783_().m_128423_("modifier");
    }

    public static ItemStack getBobber(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        String bobberKey = CustomRodManager.getModifierTag(stack).m_128461_("bobber");
        if (bobberKey.isEmpty() || !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(bobberKey))) {
            return DEFAULT_BOBBER;
        }
        return ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(bobberKey))).m_7968_();
    }

    public static ItemStack getHook(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        String hookKey = CustomRodManager.getModifierTag(stack).m_128461_("hook");
        if (hookKey.isEmpty() || !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(hookKey))) {
            return DEFAULT_HOOK;
        }
        return ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(hookKey))).m_7968_();
    }

    public static ItemStack getLine(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        String lineKey = CustomRodManager.getModifierTag(stack).m_128461_("line");
        if (lineKey.isEmpty() || !BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(lineKey))) {
            return DEFAULT_LINE;
        }
        return ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(lineKey))).m_7968_();
    }

    public static String getLineColor(ItemStack line) {
        TideAccessoryData data = TideAccessoryData.get(line);
        return data.entityModifier();
    }

    public static ResourceLocation getTextureLocation(ItemStack hook) {
        TideAccessoryData data = TideAccessoryData.get(hook);
        return data.getTextureLocation();
    }
}

