/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ImposePatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return new ResourceLocation("chiselsandbits", "textures/icons/pattern_impose.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public VoxelShape buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, Player player, Vec3 targetedPoint, Direction hitFace) {
        return ((IPatternPlacementType)ModPatternPlacementTypes.PLACEMENT.get()).buildVoxelShapeForWireframe(sourceSnapshot, player, targetedPoint, hitFace);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, BlockPlaceContext context, boolean simulate) {
        boolean hasRequiredBits;
        boolean hasRequiredSpace;
        Vec3 targetedPosition = context.m_43723_().m_6144_() ? context.m_43720_() : Vec3.m_82528_((Vec3i)context.m_8083_().m_121955_(context.m_43719_().m_122424_().m_122436_()));
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((LevelAccessor)context.m_43725_(), targetedPosition, targetedPosition.m_82520_(0.9999, 0.9999, 0.9999));
        boolean isChiseledBlock = BlockPosStreamProvider.getForAccessor(areaMutator).map(pos -> context.m_43725_().m_8055_(pos)).allMatch(state -> state.m_60734_() instanceof IMultiStateBlock);
        if (isChiseledBlock) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (Component)LocalStrings.PatternPlacementNotASolidBlock.getText());
        }
        boolean isSupported = BlockPosStreamProvider.getForAccessor(areaMutator).map(pos -> {
            BlockState state = context.m_43725_().m_8055_(pos);
            BlockEntity blockEntity = context.m_43725_().m_7702_(pos);
            return new BlockInformation(state, IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(blockEntity)));
        }).allMatch(state -> IEligibilityManager.getInstance().canBeChiseled((IBlockInformation)state) || state.isAir());
        if (!isSupported) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (Component)LocalStrings.PatternPlacementNotASupportedBlock.getText());
        }
        Map<IBlockInformation, Integer> extractedBitsCount = source.stream().filter(s -> !s.getBlockInformation().isAir()).map(IStateEntryInfo::getStartPoint).map(pos -> pos.m_82549_(areaMutator.getInWorldStartPoint())).map(areaMutator::getInAreaTarget).filter(Optional::isPresent).map(Optional::get).filter(s -> !s.getBlockInformation().isAir()).collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.m_43723_());
        boolean bl = hasRequiredSpace = context.m_43723_().m_7500_() || extractedBitsCount.entrySet().stream().allMatch(e -> playerBitInventory.canInsert((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredSpace) {
            return PlacementResult.failure(IClientConfiguration::getMissingBitsOrSpacePatternPlacementColor, (Component)LocalStrings.PatternPlacementNoBitSpace.getText());
        }
        boolean bl2 = hasRequiredBits = context.m_43723_().m_7500_() || source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((IBlockInformation)e.getKey()).isAir()).allMatch(e -> playerBitInventory.canExtract((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredBits) {
            return PlacementResult.failure(IClientConfiguration::getMissingBitsOrSpacePatternPlacementColor, (Component)LocalStrings.PatternPlacementNotEnoughBits.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.m_43723_()));){
            source.stream().filter(s -> !s.getBlockInformation().isAir()).forEach(stateEntryInfo -> areaMutator.overrideInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint()));
        }
        if (!context.m_43723_().m_7500_()) {
            extractedBitsCount.forEach(playerBitInventory::insertOrDiscard);
            source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((IBlockInformation)e.getKey()).isAir()).forEach(e -> playerBitInventory.extract((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        }
        return PlacementResult.success();
    }

    @Override
    public Vec3 getTargetedPosition(ItemStack heldStack, Player playerEntity, BlockHitResult blockRayTraceResult) {
        if (playerEntity.m_6144_()) {
            return blockRayTraceResult.m_82450_();
        }
        return Vec3.m_82528_((Vec3i)blockRayTraceResult.m_82425_());
    }

    @Override
    public Component getDisplayName() {
        return LocalStrings.PatternPlacementModeImposement.getText();
    }
}

