/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.animation;

import com.github.L_Ender.cataclysm.client.animation.SineWaveMotionTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public class SineWaveAnimationUtils {
    public static void addSineWaveMotionToModelPart(ModelPart modelPart, float amount, float speed, float tick, float min, float max, float offset, float speedMultiplier, float amountMultiplier, SineWaveMotionTypes motionType) {
        float rotationMotion = Mth.m_14036_((float)(Mth.m_14089_((float)(tick * (speedMultiplier * speed) + SineWaveAnimationUtils.degToRad(offset))) * ((float)Math.PI / 180) * SineWaveAnimationUtils.degToRad(amount)), (float)SineWaveAnimationUtils.degToRad(min), (float)SineWaveAnimationUtils.degToRad(max));
        float motion = Mth.m_14036_((float)(Mth.m_14089_((float)(tick * (speedMultiplier * speed) + offset)) * amount), (float)min, (float)max);
        if (motionType == SineWaveMotionTypes.POSITION_Y) {
            motion = -motion;
        }
        SineWaveAnimationUtils.affectModelPartBasedOnMotionType(modelPart, rotationMotion * amountMultiplier, motion * amountMultiplier, motionType);
    }

    public static void adjustPositionOfModelPart(ModelPart modelPart, float amount, float amountMultiplier, SineWaveMotionTypes motionType) {
        float newAmount = amount;
        float newPositionAmount = amount;
        if (motionType == SineWaveMotionTypes.POSITION_Y) {
            newPositionAmount = -newPositionAmount;
        }
        SineWaveAnimationUtils.affectModelPartBasedOnMotionType(modelPart, SineWaveAnimationUtils.degToRad(newAmount) * amountMultiplier, newPositionAmount * amountMultiplier, motionType);
    }

    public static float getSineWaveKeyframe(float amount, float speed, float tick, float min, float max, float offset) {
        return Mth.m_14036_((float)(Mth.m_14089_((float)(tick * (1.0f * speed) + offset)) * amount), (float)min, (float)max);
    }

    public static float getConstantMotionKeyframe(float speed, float tick) {
        return tick * speed;
    }

    public static void affectModelPartBasedOnMotionType(ModelPart modelPart, float rotationMotion, float motion, SineWaveMotionTypes motionType) {
        switch (motionType) {
            case ROTATION_X: {
                modelPart.f_104203_ += rotationMotion;
                break;
            }
            case ROTATION_Y: {
                modelPart.f_104204_ += rotationMotion;
                break;
            }
            case ROTATION_Z: {
                modelPart.f_104205_ += rotationMotion;
                break;
            }
            case POSITION_X: {
                modelPart.f_104200_ += motion;
                break;
            }
            case POSITION_Y: {
                modelPart.f_104201_ += motion;
                break;
            }
            case POSITION_Z: {
                modelPart.f_104202_ += motion;
                break;
            }
            case SCALE_X: {
                modelPart.f_233553_ += motion;
                break;
            }
            case SCALE_Y: {
                modelPart.f_233554_ += motion;
                break;
            }
            case SCALE_Z: {
                modelPart.f_233555_ += motion;
            }
        }
    }

    public static float tickAmountMultiplierChange(float value, boolean shouldPlay, float transitionSpeed) {
        float newValue = value;
        if (shouldPlay) {
            if (newValue < 1.0f) {
                newValue = newValue + transitionSpeed > 1.0f ? 1.0f : (newValue += transitionSpeed);
            }
        } else if (newValue > 0.0f) {
            newValue = newValue - transitionSpeed < 0.0f ? 0.0f : (newValue -= transitionSpeed);
        }
        return newValue;
    }

    public static float getTick(int tick, boolean convertToRadians) {
        return convertToRadians ? SineWaveAnimationUtils.degToRad((float)tick + Minecraft.m_91087_().m_91296_()) / 20.0f : ((float)tick + Minecraft.m_91087_().m_91296_()) / 20.0f;
    }

    private static float degToRad(float deg) {
        return deg * ((float)Math.PI / 180);
    }
}

