/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.pehkui;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import dev.hyperlynx.reactive.integration.pehkui.ReactivePehkuiPlugin;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

public class ResizeReactionEffects {
    public static CrucibleBlockEntity shrink(CrucibleBlockEntity crucible) {
        ResizeReactionEffects.resizeNearby(crucible, (float)((Double)ConfigMan.SERVER.pehkuiSmallSize.get()).doubleValue(), Mode.REDUCE, (ParticleOptions)Registration.ACID_BUBBLE_PARTICLE);
        return crucible;
    }

    public static CrucibleBlockEntity grow(CrucibleBlockEntity crucible) {
        ResizeReactionEffects.resizeNearby(crucible, (float)((Double)ConfigMan.SERVER.pehkuiLargeSize.get()).doubleValue(), Mode.ENLARGE, (ParticleOptions)ParticleTypes.f_123748_);
        return crucible;
    }

    public static CrucibleBlockEntity revert_from_large(CrucibleBlockEntity crucible) {
        ResizeReactionEffects.resizeNearby(crucible, 1.0f, Mode.REDUCE, (ParticleOptions)ParticleTypes.f_175830_);
        return crucible;
    }

    public static CrucibleBlockEntity revert_from_small(CrucibleBlockEntity crucible) {
        ResizeReactionEffects.resizeNearby(crucible, 1.0f, Mode.ENLARGE, (ParticleOptions)ParticleTypes.f_175830_);
        return crucible;
    }

    private static void resizeNearby(CrucibleBlockEntity crucible, float new_scale, Mode mode, ParticleOptions particle) {
        if ((double)Objects.requireNonNull(crucible.m_58904_()).f_46441_.m_188501_() < 0.4) {
            AABB aoe = new AABB(crucible.m_58899_());
            aoe = aoe.m_82400_(3.0);
            List victims = crucible.m_58904_().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity victim : victims) {
                if (!CrystalIronItem.effectNotBlocked(victim, 2)) continue;
                ScaleData victim_scale_data = ScaleTypes.BASE.getScaleData((Entity)victim);
                if (!(mode == Mode.ENLARGE && victim_scale_data.getScale() < new_scale) && (mode != Mode.REDUCE || !(victim_scale_data.getScale() > new_scale))) continue;
                victim_scale_data.setTargetScale(new_scale);
                ParticleScribe.drawParticleZigZag(crucible.m_58904_(), particle, (double)crucible.m_58899_().m_123341_() + 0.5, (double)crucible.m_58899_().m_123342_() + 0.6, (double)crucible.m_58899_().m_123343_() + 0.5, victim.m_146892_().f_82479_, victim.m_146892_().f_82480_, victim.m_146892_().f_82481_, 20, 5, 0.9);
                crucible.m_58904_().m_247517_(null, crucible.m_58899_(), (SoundEvent)Registration.ZAP_SOUND.get(), SoundSource.BLOCKS);
                crucible.m_58904_().m_5594_(null, crucible.m_58899_(), SoundEvents.f_12376_, SoundSource.BLOCKS, 0.5f, 1.3f + crucible.m_58904_().f_46441_.m_188501_() * 0.2f);
                victim.m_6469_(crucible.m_58904_().m_269111_().m_269425_(), 1.0f);
                if (!(victim instanceof ServerPlayer)) continue;
                ServerPlayer splayer = (ServerPlayer)victim;
                if ((double)new_scale == 1.0) {
                    ReactivePehkuiPlugin.SIZE_REVERTED.trigger(splayer);
                    continue;
                }
                ReactivePehkuiPlugin.SIZE_CHANGED.trigger(splayer);
            }
        }
    }

    static enum Mode {
        ENLARGE,
        REDUCE;

    }
}

