/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.CatalystEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CurseAssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ReactionComponentProcessor
implements IComponentProcessor {
    String reaction_alias = "error";

    public void setup(Level level, IVariableProvider variables) {
        this.reaction_alias = variables.get("reaction").asString();
    }

    public IVariable process(Level level, String key) {
        if (key.equals("formula")) {
            for (Reaction reaction : ReactiveMod.REACTION_MAN.getReactions()) {
                if (!reaction.getAlias().equals(this.reaction_alias)) continue;
                StringBuilder formula = new StringBuilder();
                formula.append(Component.m_237115_((String)"docs.reactive.powers_label").getString());
                for (Power power : reaction.getReagents().keySet()) {
                    formula.append(power.getName()).append("$(br)");
                }
                if (reaction instanceof CurseAssimilationReaction) {
                    formula.append(Component.m_237115_((String)"docs.reactive.curse_label").getString());
                }
                if (reaction.getReagents().keySet().isEmpty()) {
                    formula.append(Component.m_237115_((String)"docs.reactive.any_label").getString());
                }
                formula.append(Component.m_237115_((String)"docs.reactive.stimulus_label").getString());
                switch (reaction.getStimulus()) {
                    case NONE: {
                        formula.append(Component.m_237115_((String)"text.reactive.none").getString());
                        break;
                    }
                    case GOLD_SYMBOL: {
                        formula.append(Component.m_237115_((String)"block.reactive.gold_symbol").getString());
                        break;
                    }
                    case ELECTRIC: {
                        formula.append(Component.m_237115_((String)"text.reactive.electric_charge").getString());
                        break;
                    }
                    case SACRIFICE: {
                        formula.append(Component.m_237115_((String)"text.reactive.sacrificial").getString());
                        break;
                    }
                    case END_CRYSTAL: {
                        formula.append(Component.m_237115_((String)"item.minecraft.end_crystal").getString());
                        break;
                    }
                    case NO_ELECTRIC: {
                        formula.append(Component.m_237115_((String)"text.reactive.lack_of").getString()).append(Component.m_237115_((String)"text.reactive.electric_charge").getString());
                        break;
                    }
                    case NO_END_CRYSTAL: {
                        formula.append(Component.m_237115_((String)"text.reactive.lack_of").getString()).append(Component.m_237115_((String)"item.minecraft.end_crystal").getString());
                    }
                }
                if (reaction instanceof CatalystEffectReaction) {
                    CatalystEffectReaction catre = (CatalystEffectReaction)reaction;
                    formula.append(Component.m_237115_((String)"docs.reactive.catalyst_label").getString());
                    formula.append(catre.getCatalyst().m_41466_().getString());
                }
                return IVariable.wrap((String)formula.toString());
            }
            return IVariable.empty();
        }
        if (key.equals("lock")) {
            for (Reaction reaction : ReactiveMod.REACTION_MAN.getReactions()) {
                if (!reaction.getAlias().equals(this.reaction_alias)) continue;
                return IVariable.wrap((String)("reactive:reactions/" + this.reaction_alias + "_perfect"));
            }
            return IVariable.empty();
        }
        return IVariable.empty();
    }
}

