/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs.events;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.integration.kubejs.KubeScriptException;
import dev.hyperlynx.reactive.integration.kubejs.ReactionFactory;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ReactionConstructEventJS
extends EventJS {
    ReactionMan.ReactionConstructEvent event;

    public ReactionConstructEventJS(ReactionMan.ReactionConstructEvent event) {
        this.event = event;
    }

    public ReactionFactory builder(String alias, MutableComponent custom_name, String ... reagent_locations) {
        Stream<Power> reagents = Arrays.stream(reagent_locations).map(location -> this.getPower(new ResourceLocation(location)));
        return new ReactionFactory(alias, custom_name, reagents.toList());
    }

    private Power getPower(ResourceLocation location) {
        Power power = (Power)Powers.POWER_SUPPLIER.get().getValue(location);
        if (power == null) {
            throw new KubeScriptException("Power " + location + " does not exist!");
        }
        return power;
    }

    public void afterPosted(EventResult result) {
        ReactiveKubeJSPlugin.REACTIONS.ingestReactionHandlers();
    }
}

