/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class TransmuteRecipeCategory
implements IRecipeCategory<TransmuteRecipe> {
    @Nullable
    public ResourceLocation getRegistryName(TransmuteRecipe recipe) {
        return recipe.m_6423_();
    }

    public RecipeType<TransmuteRecipe> getRecipeType() {
        return RecipeType.create((String)"reactive", (String)"transmute", TransmuteRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"title.reactive.transmute");
    }

    public IDrawable getBackground() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/tf_jei.png"), 2, 2, 76, 38);
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransmuteRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input_slot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 1);
        input_slot.setSlotName("reactant");
        input_slot.addItemStacks(List.of(recipe.getReactant().m_43908_()));
        IRecipeSlotBuilder output_slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 1);
        output_slot.setSlotName("product");
        output_slot.addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        switch (recipe.getReagents().size()) {
            case 1: {
                IRecipeSlotBuilder power_slot = builder.addSlot(RecipeIngredientRole.CATALYST, 28, 24);
                power_slot.setSlotName("reagent_middle");
                power_slot.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(0));
                break;
            }
            case 2: {
                IRecipeSlotBuilder power_slotl = builder.addSlot(RecipeIngredientRole.CATALYST, 20, 24);
                power_slotl.setSlotName("reagent_left");
                power_slotl.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(0));
                IRecipeSlotBuilder power_slotr = builder.addSlot(RecipeIngredientRole.CATALYST, 36, 24);
                power_slotr.setSlotName("reagent_right");
                power_slotr.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(1));
                break;
            }
            case 3: {
                IRecipeSlotBuilder power_slotl = builder.addSlot(RecipeIngredientRole.CATALYST, 12, 24);
                power_slotl.setSlotName("reagent_left");
                power_slotl.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(0));
                IRecipeSlotBuilder power_slot = builder.addSlot(RecipeIngredientRole.CATALYST, 28, 24);
                power_slot.setSlotName("reagent_middle");
                power_slot.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(1));
                IRecipeSlotBuilder power_slotr = builder.addSlot(RecipeIngredientRole.CATALYST, 44, 24);
                power_slotr.setSlotName("reagent_right");
                power_slotr.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(2));
                break;
            }
            default: {
                IRecipeSlotBuilder power_slot = builder.addSlot(RecipeIngredientRole.CATALYST, 28, 24);
                power_slot.setSlotName("reagents");
                power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, recipe.getReagents());
            }
        }
    }

    public void draw(TransmuteRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        if (recipe.needs_electricity) {
            this.drawElectricLabel(gui);
        }
    }

    private void drawElectricLabel(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.m_91087_();
        int width = minecraft.f_91062_.m_92895_("Charge");
        int center = this.getBackground().getWidth() / 2;
        int x = center - width / 2;
        int y = 11;
        gui.m_280488_(minecraft.f_91062_, "Charge", x, y, 895144);
    }
}

