/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DissolveRecipeCategory
implements IRecipeCategory<DissolveRecipe> {
    @Nullable
    public ResourceLocation getRegistryName(DissolveRecipe recipe) {
        return recipe.m_6423_();
    }

    public RecipeType<DissolveRecipe> getRecipeType() {
        return RecipeType.create((String)"reactive", (String)"dissolve", DissolveRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"title.reactive.dissolve");
    }

    public IDrawable getBackground() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/tf_jei.png"), 2, 2, 76, 38);
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DissolveRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input_slot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 1);
        IRecipeSlotBuilder output_slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 1);
        input_slot.setSlotName("reactant");
        input_slot.addItemStacks(List.of(recipe.getReactant().m_43908_()));
        output_slot.setSlotName("product");
        output_slot.addItemStack(recipe.getResultItem());
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            IRecipeSlotBuilder power_slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 20);
            power_slot.setSlotName("power_result");
            for (ItemStack input : recipe.getReactant().m_43908_()) {
                power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, Power.getSourcePower(input));
            }
        }
    }

    public void draw(DissolveRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        if (recipe.needs_electricity) {
            this.drawElectricLabel(gui);
        }
    }

    private void drawElectricLabel(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.m_91087_();
        int width = minecraft.f_91062_.m_92895_("Charge");
        int center = this.getBackground().getWidth() / 2;
        int x = center - width / 2;
        int y = 11;
        gui.m_280488_(minecraft.f_91062_, "Charge", x, y, 895144);
    }
}

