/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.create;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.ValueListDisplaySource;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.IntAttached;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.items.LitmusPaperItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CrucibleDisplaySource
extends ValueListDisplaySource {
    protected Stream<IntAttached<MutableComponent>> provideEntries(DisplayLinkContext context, int maxRows) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof CrucibleBlockEntity)) {
            return Stream.empty();
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
        Stream.Builder<IntAttached> builder = Stream.builder();
        for (Power p : crucible.getPowerMap().keySet()) {
            if (crucible.getPowerLevel(p) <= 0) continue;
            builder.add(IntAttached.with((int)crucible.getPowerLevel(p), (Object)Component.m_237113_((String)p.getName())));
        }
        return builder.build();
    }

    protected boolean valueFirst() {
        return false;
    }

    protected List<MutableComponent> createComponentsFromEntry(DisplayLinkContext context, IntAttached<MutableComponent> entry) {
        int number = (Integer)entry.getFirst();
        MutableComponent name = ((MutableComponent)entry.getSecond()).m_7220_((Component)WHITESPACE);
        if (this.shortenNumbers(context)) {
            String percent = LitmusPaperItem.getPercent(number);
            MutableComponent shortened = Components.literal((String)(percent.equals("TRACE") ? "<1%" : percent));
            return Arrays.asList(name, shortened);
        }
        MutableComponent formattedNumber = Components.literal((String)String.valueOf(number)).m_7220_((Component)WHITESPACE);
        return this.valueFirst() ? Arrays.asList(formattedNumber, name) : Arrays.asList(name, formattedNumber);
    }
}

