/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ActiveFoamBlockEntity
extends BlockEntity {
    int spreads_left = 16;
    int tick_counter = 0;

    public ActiveFoamBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.ACTIVE_GOLD_FOAM_BE.get(), pos, state);
    }

    private static void trySpread(Level level, BlockPos target, BlockPos spreader, int spreads_left) {
        if (level.m_8055_(target).m_60795_() || level.m_8055_(target).m_60713_((Block)Registration.GOLD_FOAM.get())) {
            level.m_7731_(target, ((Block)Registration.ACTIVE_GOLD_FOAM.get()).m_49966_(), 2);
            ((ActiveFoamBlockEntity)Objects.requireNonNull(level.m_7702_((BlockPos)target))).spreads_left = spreads_left - 1;
            level.m_7731_(spreader, ((Block)Registration.GOLD_FOAM.get()).m_49966_(), 2);
            level.m_5594_(null, target, SoundEvents.f_12641_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void trySpreadInert(Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_60795_()) {
            level.m_7731_(pos, ((Block)Registration.GOLD_FOAM.get()).m_49966_(), 2);
            level.m_5594_(null, pos, SoundEvents.f_12641_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void trySpreadSideways(Level level, BlockPos pos, RandomSource random, int spreads_left) {
        int forbidden_direction;
        int active_direction = random.m_216332_(1, 4);
        if (active_direction == (forbidden_direction = WorldSpecificValue.get("gold_foam_spread_direction", 1, 4))) {
            return;
        }
        if (active_direction == 1) {
            ActiveFoamBlockEntity.trySpread(level, pos.m_122029_(), pos, spreads_left);
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122024_());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122012_());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122019_());
        } else if (active_direction == 2) {
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122029_());
            ActiveFoamBlockEntity.trySpread(level, pos.m_122024_(), pos, spreads_left);
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122012_());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122019_());
        } else if (active_direction == 3) {
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122029_());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122024_());
            ActiveFoamBlockEntity.trySpread(level, pos.m_122012_(), pos, spreads_left);
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122019_());
        } else if (active_direction == 4) {
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122029_());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122024_());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.m_122012_());
            ActiveFoamBlockEntity.trySpread(level, pos.m_122019_(), pos, spreads_left);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ActiveFoamBlockEntity foam) {
        if (level.f_46443_) {
            return;
        }
        ++foam.tick_counter;
        if (foam.tick_counter > 5) {
            foam.tick_counter = 0;
            if (foam.spreads_left == 0) {
                level.m_7731_(pos, ((Block)Registration.GOLD_FOAM.get()).m_49966_(), 2);
                return;
            }
            ActiveFoamBlockEntity.spreadAround(level, pos, level.f_46441_, foam.spreads_left);
        }
    }

    public static void spreadAround(Level level, BlockPos pos, RandomSource random, int spreads_left) {
        float up_chance = WorldSpecificValue.get("gold_foam_up_chance", 0.2f, 0.5f);
        float down_chance = WorldSpecificValue.get("gold_foam_down_chance", 0.2f, 0.5f);
        if (WorldSpecificValue.getBool("gold_foam_up_priority", 0.5f)) {
            if (random.m_188501_() < up_chance) {
                ActiveFoamBlockEntity.trySpread(level, pos.m_7494_(), pos, spreads_left);
            } else if (random.m_188501_() < down_chance) {
                ActiveFoamBlockEntity.trySpread(level, pos.m_7495_(), pos, spreads_left);
            } else {
                ActiveFoamBlockEntity.trySpreadSideways(level, pos, random, spreads_left);
            }
        } else if (random.m_188501_() < down_chance) {
            ActiveFoamBlockEntity.trySpread(level, pos.m_7495_(), pos, spreads_left);
        } else if (random.m_188501_() < up_chance) {
            ActiveFoamBlockEntity.trySpread(level, pos.m_7494_(), pos, spreads_left);
        } else {
            ActiveFoamBlockEntity.trySpreadSideways(level, pos, random, spreads_left);
        }
    }
}

