/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.function.Function;

public class EffectReaction
extends FreeEffectReaction {
    int cost;

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> effect, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, int numReagents) {
        super(alias, effect, render, numReagents);
        this.cost = WorldSpecificValue.get(alias + "cost", 10, 20);
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power required_power) {
        super(alias, function, render, required_power);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power ... required_powers) {
        super(alias, function, render, required_powers);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power required_power, int num_additionals) {
        super(alias, function, render, required_power, num_additionals);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        super.run(crucible);
        for (Power p : this.reagents.keySet()) {
            crucible.expendPower(p, (int)((double)this.cost / (double)this.reagents.size()) + 1);
            crucible.setDirty();
        }
    }
}

