/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;

public class AstralReaction
extends Reaction {
    public AstralReaction(String alias) {
        super(alias, 0);
    }

    @Override
    public boolean isPerfect(CrucibleBlockEntity crucible) {
        return true;
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        super.run(crucible);
        crucible.addPower((Power)Powers.ASTRAL_POWER.get(), 1600);
        crucible.expendPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValues.CURSE_RATE.get());
    }

    @Override
    public void render(Level level, CrucibleBlockEntity crucible) {
        if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) < crucible.getTotalPowerLevel()) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)Registration.STARDUST_PARTICLE.m_6012_(), crucible.m_58899_(), 0.3f);
        }
    }

    @Override
    public Reaction.Status conditionsMet(CrucibleBlockEntity crucible) {
        if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 0) {
            return Reaction.Status.REACTING;
        }
        return Reaction.Status.STABLE;
    }
}

