/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.util.Color;
import dev.hyperlynx.reactive.util.PrimedWSV;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class Power {
    private final Color color;
    private final ResourceLocation location;
    private final String name;
    protected Item bottle;
    protected Item render_item;
    private final Supplier<Block> render_water_block;
    private final PrimedWSV percent_reactivity;
    public boolean invisible = false;

    public Power(String id, Supplier<Block> render_water_block, int color, Item bottle) {
        this.location = ReactiveMod.location(id);
        this.render_water_block = render_water_block;
        this.color = new Color(color);
        this.bottle = bottle;
        this.name = Util.m_137492_((String)"power", (ResourceLocation)ReactiveMod.location(id));
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 50, 200);
        this.render_item = null;
    }

    public Power(String id, Supplier<Block> render_water_block, Color color, Item bottle) {
        this.location = ReactiveMod.location(id);
        this.render_water_block = render_water_block;
        this.color = color;
        this.bottle = bottle;
        this.name = Util.m_137492_((String)"power", (ResourceLocation)ReactiveMod.location(id));
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 50, 200);
        this.render_item = null;
    }

    public Power(String id, Supplier<Block> render_water_block, int color, Item bottle, Item renderItem) {
        this.location = ReactiveMod.location(id);
        this.render_water_block = render_water_block;
        this.color = new Color(color);
        this.bottle = bottle;
        this.name = Util.m_137492_((String)"power", (ResourceLocation)ReactiveMod.location(id));
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 50, 200);
        this.render_item = renderItem;
    }

    public Power(String id, Supplier<Block> render_water_block, Color color, Item bottle, Item renderItem) {
        this.location = ReactiveMod.location(id);
        this.render_water_block = render_water_block;
        this.color = color;
        this.bottle = bottle;
        this.name = Util.m_137492_((String)"power", (ResourceLocation)ReactiveMod.location(id));
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 50, 200);
        this.render_item = renderItem;
    }

    public Power(ResourceLocation location, int color, Supplier<Block> render_water_block, Item bottle, Item renderItem) {
        this.location = location;
        this.color = new Color(color);
        this.render_water_block = render_water_block;
        this.bottle = bottle;
        this.name = Util.m_137492_((String)"power", (ResourceLocation)this.location);
        this.percent_reactivity = new PrimedWSV(location + "_reactivity", 50, 200);
        this.render_item = renderItem;
    }

    public static TagKey<Item> getSourceTag(ResourceLocation location) {
        return ItemTags.create((ResourceLocation)new ResourceLocation(location.m_135827_(), location.m_135815_() + "_sources"));
    }

    public static Power readPower(CompoundTag tag) {
        return Power.readPower(tag, "name");
    }

    public static Power readPower(CompoundTag tag, String power_key) {
        String key = tag.m_128461_(power_key);
        ResourceLocation location = key.contains(":") ? new ResourceLocation(key) : ReactiveMod.location(key);
        Power ret = (Power)Powers.POWER_SUPPLIER.get().getValue(location);
        if (ret == null) {
            System.err.println("Failed to read power. This will break things.");
        }
        return ret;
    }

    public Block getRenderBlock() {
        return this.render_water_block.get();
    }

    public Color getColor() {
        return this.color;
    }

    public TextColor getTextColor() {
        return TextColor.m_131266_((int)this.color.hex);
    }

    public String getId() {
        return this.location.m_135815_();
    }

    public String getName() {
        return Component.m_237115_((String)this.name).getString();
    }

    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public boolean checkReactivity(int power_level, int threshold) {
        float strength = (float)this.percent_reactivity.get() / 100.0f;
        int adjusted_power_level = (int)((float)power_level * strength);
        return adjusted_power_level >= threshold;
    }

    public static List<Power> getSourcePower(ItemStack i) {
        ArrayList<Power> stack_powers = new ArrayList<Power>();
        for (Power power : Powers.POWER_SUPPLIER.get().getValues()) {
            if (!i.m_204117_(Power.getSourceTag(power.getResourceLocation()))) continue;
            stack_powers.add(power);
            break;
        }
        return stack_powers;
    }

    public static int getSourceLevel(ItemStack i) {
        return WorldSpecificValue.get("power_" + i.m_41720_().m_5524_(), i.m_204117_(AlchemyTags.highPower) ? 250 : 40, i.m_204117_(AlchemyTags.highPower) ? 500 : 90);
    }

    public boolean hasBottle() {
        return this.bottle != null;
    }

    public boolean matchesBottle(ItemStack i) {
        if (this.hasBottle()) {
            return i.m_150930_(this.getBottle().m_41720_());
        }
        return false;
    }

    public ItemStack getBottle() {
        if (this.hasBottle()) {
            return this.bottle.m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public String toString() {
        return this.name;
    }

    public ItemStack getRenderStack() {
        if (this.bottle != null && this.bottle.m_7968_().m_41613_() > 0) {
            return this.bottle.m_7968_();
        }
        if (this.render_item != null && this.render_item.m_7968_().m_41613_() > 0) {
            return this.render_item.m_7968_();
        }
        return Items.f_42127_.m_7968_();
    }
}

