/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.advancements;

import dev.hyperlynx.reactive.advancements.FlagCriterion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ReactionCriteriaBuilder {
    private final List<String> aliases = new ArrayList<String>();
    private final Map<String, FlagCriterion> criteria = new HashMap<String, FlagCriterion>();

    public void add(String alias) {
        this.aliases.add(alias);
        FlagCriterion criterion = new FlagCriterion(new ResourceLocation("reactive:reaction/" + alias + "_criterion"));
        FlagCriterion existing = this.criteria.putIfAbsent(alias, criterion);
        if (existing != null) {
            throw new RedundantAliasException("The reaction alias '" + alias + "' was added more then once!");
        }
        FlagCriterion perfect_criterion = new FlagCriterion(new ResourceLocation("reactive:reaction/" + alias + "_perfect_criterion"));
        this.criteria.putIfAbsent(alias + "_perfect", perfect_criterion);
    }

    public void lateAdd(String alias) {
        this.add(alias);
        FlagCriterion added = this.get(alias);
        FlagCriterion perfect_added = this.get(alias);
        CriteriaTriggers.m_10595_((CriterionTrigger)added);
        CriteriaTriggers.m_10595_((CriterionTrigger)perfect_added);
    }

    public void register(FMLCommonSetupEvent evt) {
        for (String key : this.criteria.keySet()) {
            evt.enqueueWork(() -> (FlagCriterion)CriteriaTriggers.m_10595_((CriterionTrigger)this.criteria.get(key)));
        }
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public FlagCriterion get(String alias) {
        return this.criteria.get(alias);
    }

    public static class RedundantAliasException
    extends RuntimeException {
        public RedundantAliasException(String msg) {
            super(msg);
        }
    }
}

