/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.vivecraft.client.utils.UpdateChecker;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.ServerConfig;

public class ServerUtil {
    public static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void scheduleWelcomeMessageOrKick(ServerPlayer serverPlayer) {
        if (((Boolean)ServerConfig.messagesEnabled.get()).booleanValue() || ((Boolean)ServerConfig.vive_only.get()).booleanValue() || ((Boolean)ServerConfig.vr_only.get()).booleanValue()) {
            scheduler.schedule(() -> {
                if (!serverPlayer.m_9232_()) {
                    boolean isOpAndAllowed;
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    String message = "";
                    boolean bl = isOpAndAllowed = (Boolean)ServerConfig.allow_op.get() != false && serverPlayer.f_8924_.m_6846_().m_11303_(serverPlayer.m_36316_());
                    if (!(isOpAndAllowed || !((Boolean)ServerConfig.vr_only.get()).booleanValue() || vivePlayer != null && vivePlayer.isVR())) {
                        String kickMessage = (String)ServerConfig.messagesKickVROnly.get();
                        try {
                            kickMessage = kickMessage.formatted(serverPlayer.m_7755_().getString());
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("KickVROnly message '{}' has errors: {}", (Object)kickMessage, (Object)e.toString());
                        }
                        serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)kickMessage));
                        return;
                    }
                    if (!isOpAndAllowed && ((Boolean)ServerConfig.vive_only.get()).booleanValue() && vivePlayer == null) {
                        String kickMessage = (String)ServerConfig.messagesKickViveOnly.get();
                        try {
                            kickMessage = kickMessage.formatted(serverPlayer.m_7755_().getString());
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("KickViveOnly message '{}' has errors: {}", (Object)kickMessage, (Object)e.toString());
                        }
                        serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)kickMessage));
                        return;
                    }
                    if (((Boolean)ServerConfig.messagesEnabled.get()).booleanValue() && !(message = vivePlayer == null ? (String)ServerConfig.messagesWelcomeVanilla.get() : (!vivePlayer.isVR() ? (String)ServerConfig.messagesWelcomeNonVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.messagesWelcomeSeated.get() : (String)ServerConfig.messagesWelcomeVR.get()))).isEmpty()) {
                        try {
                            serverPlayer.f_8924_.m_6846_().m_240416_((Component)Component.m_237113_((String)message.formatted(serverPlayer.m_7755_().getString())), false);
                        }
                        catch (IllegalFormatException e) {
                            ServerNetworking.LOGGER.error("Welcome message '{}' has errors: {}", (Object)message, (Object)e.toString());
                        }
                    }
                }
            }, (long)((Double)ServerConfig.messageKickDelay.get() * 1000.0), TimeUnit.MILLISECONDS);
        }
    }

    public static void sendUpdateNotificationIfOP(ServerPlayer serverPlayer) {
        if (((Boolean)ServerConfig.checkForUpdate.get()).booleanValue() && serverPlayer.f_8924_.m_6982_() && serverPlayer.f_8924_.m_6846_().m_11303_(serverPlayer.m_36316_())) {
            scheduler.schedule(() -> {
                if (UpdateChecker.checkForUpdates()) {
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)("Vivecraft update available: \u00a7a" + UpdateChecker.newestVersion)));
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)"reload").executes(context -> {
            ServerConfig.init((action, path, incorrectValue, correctedValue) -> ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Corrected \u00a7a[" + String.join((CharSequence)"\u00a7r.\u00a7a", path) + "]\u00a7r: was '(" + incorrectValue.getClass().getSimpleName() + ")" + incorrectValue + "', is now '(" + correctedValue.getClass().getSimpleName() + ")" + correctedValue + "'"))));
            return 1;
        })));
        for (ConfigBuilder.ConfigValue setting : ServerConfig.getConfigValues()) {
            IntegerArgumentType argument;
            String argumentName;
            Class<?> clazz = setting.get().getClass();
            if (clazz == Integer.class) {
                argumentName = "int";
                argument = IntegerArgumentType.integer();
            } else if (clazz == Double.class) {
                argumentName = "double";
                argument = DoubleArgumentType.doubleArg();
            } else if (clazz == Boolean.class) {
                argumentName = "bool";
                argument = BoolArgumentType.bool();
            } else {
                argumentName = "string";
                argument = StringArgumentType.string();
            }
            if (setting instanceof ConfigBuilder.InListValue) {
                ConfigBuilder.InListValue inListValue = (ConfigBuilder.InListValue)setting;
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)inListValue.getPath()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)argumentName, (ArgumentType)argument).suggests((context, builder) -> {
                    for (Object value : inListValue.getValidValues()) {
                        builder.suggest(value.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    try {
                        Object newValue = context.getArgument(argumentName, clazz);
                        setting.set(newValue);
                        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("set \u00a7a[" + setting.getPath() + "]\u00a7r to '" + newValue + "'")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return 1;
                })))));
            } else if (!(setting.get() instanceof List)) {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)setting.getPath()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)argumentName, (ArgumentType)argument).executes(context -> {
                    try {
                        Object newValue = context.getArgument(argumentName, clazz);
                        setting.set(newValue);
                        ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("set \u00a7a[" + setting.getPath() + "]\u00a7r to '" + newValue + "'")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return 1;
                })))));
            } else {
                ConfigBuilder.ConfigValue listConfig = setting;
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)setting.getPath()).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (ResourceLocation block : BuiltInRegistries.f_256975_.m_6566_()) {
                        builder.suggest(block.toString());
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.add(newValue);
                    listConfig.set(list);
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("added '" + newValue + "' to \u00a7a[" + setting.getPath() + "]\u00a7r")));
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("is now '" + setting.get())));
                    return 1;
                })))));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)setting.getPath()).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
                    for (String block : (List)listConfig.get()) {
                        builder.suggest(block);
                    }
                    return builder.buildFuture();
                }).executes(context -> {
                    String newValue = (String)context.getArgument("block", String.class);
                    List list = (List)listConfig.get();
                    list.remove(newValue);
                    listConfig.set(list);
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("removed '" + newValue + "' from \u00a7a[" + setting.getPath() + "]\u00a7r")));
                    ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("is now '" + setting.get())));
                    return 1;
                })))));
            }
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)setting.getPath()).then(Commands.m_82127_((String)"reset").executes(context -> {
                Object newValue = setting.reset();
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("reset \u00a7a[" + setting.getPath() + "]\u00a7r to '" + newValue + "'")));
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vivecraft-server-config").requires(source -> source.m_6761_(4))).then(Commands.m_82127_((String)setting.getPath()).executes(context -> {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a7a[" + setting.getPath() + "]\u00a7r is set to '" + setting.get() + "'")));
                return 1;
            })));
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }
}

