/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity.projectile;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends Entity {
    @Unique
    private ServerVivePlayer vivecraft$serverviveplayer = null;
    @Unique
    private Vec3 vivecraft$controllerDir = null;
    @Unique
    private Vec3 vivecraft$controllerPos = null;

    protected FishingHookMixin(EntityType<? extends Projectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    @ModifyVariable(at=@At(value="STORE"), method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"}, ordinal=0)
    private float vivecraft$modifyXrot(float xRot, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.vivecraft$serverviveplayer = ServerVRPlayers.getVivePlayer(serverPlayer);
            if (this.vivecraft$serverviveplayer != null && this.vivecraft$serverviveplayer.isVR()) {
                this.vivecraft$controllerDir = this.vivecraft$serverviveplayer.getControllerDir(this.vivecraft$serverviveplayer.activeHand);
                this.vivecraft$controllerPos = this.vivecraft$serverviveplayer.getControllerPos(this.vivecraft$serverviveplayer.activeHand, (Player)serverPlayer);
            }
        }
        if (this.vivecraft$serverviveplayer != null && this.vivecraft$serverviveplayer.isVR()) {
            return -((float)Math.toDegrees(Math.asin(this.vivecraft$controllerDir.f_82480_ / this.vivecraft$controllerDir.m_82553_())));
        }
        return xRot;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"}, ordinal=1)
    private float vivecraft$modifyYrot(float yRot) {
        if (this.vivecraft$serverviveplayer != null && this.vivecraft$serverviveplayer.isVR()) {
            return (float)Math.toDegrees(Math.atan2(-this.vivecraft$controllerDir.f_82479_, this.vivecraft$controllerDir.f_82481_));
        }
        return yRot;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;moveTo(DDDFF)V"), method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"})
    private void vivecraft$modifyMoveTo(FishingHook instance, double x, double y, double z, float yRot, float xRot) {
        if (this.vivecraft$serverviveplayer != null && this.vivecraft$serverviveplayer.isVR()) {
            instance.m_7678_(this.vivecraft$controllerPos.f_82479_ + this.vivecraft$controllerDir.f_82479_ * (double)0.6f, this.vivecraft$controllerPos.f_82480_ + this.vivecraft$controllerDir.f_82480_ * (double)0.6f, this.vivecraft$controllerPos.f_82481_ + this.vivecraft$controllerDir.f_82481_ * (double)0.6f, yRot, xRot);
            this.vivecraft$controllerDir = null;
            this.vivecraft$controllerPos = null;
        } else {
            this.m_7678_(x, y, z, yRot, xRot);
        }
        this.vivecraft$serverviveplayer = null;
    }
}

