/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity.monster;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;

@Mixin(value={EnderMan.class})
public abstract class EndermanMixin
extends Monster {
    protected EndermanMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/monster/EnderMan;isLookingAtMe(Lnet/minecraft/world/entity/player/Player;)Z"}, cancellable=true)
    public void vivecraft$lookAtVR(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (ServerVRPlayers.isVRPlayer((ServerPlayer)player)) {
            cir.setReturnValue((Object)EndermanMixin.vivecraft$shouldEndermanAttackVRPlayer((EnderMan)this, (ServerPlayer)player));
        }
    }

    @Unique
    private static boolean vivecraft$shouldEndermanAttackVRPlayer(EnderMan enderman, ServerPlayer player) {
        ItemStack itemstack = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (!itemstack.m_150930_(Items.f_42047_)) {
            ServerVivePlayer data = ServerVRPlayers.getVivePlayer(player);
            Vec3 vector3d = data.getHMDDir();
            Vec3 vector3d1 = new Vec3(enderman.m_20185_() - data.getHMDPos((Player)player).f_82479_, enderman.m_20188_() - data.getHMDPos((Player)player).f_82480_, enderman.m_20189_() - data.getHMDPos((Player)player).f_82481_);
            double d0 = vector3d1.m_82553_();
            double d1 = vector3d.m_82526_(vector3d1 = vector3d1.m_82541_());
            return d1 > 1.0 - 0.025 / d0 && d0 < 128.0 && EndermanMixin.vivecraft$canEntityBeSeen((Entity)enderman, data.getHMDPos((Player)player));
        }
        return false;
    }

    @Unique
    private static boolean vivecraft$canEntityBeSeen(Entity entity, Vec3 playerEyePos) {
        Vec3 entityEyePos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        return entity.m_9236_().m_45547_(new ClipContext(playerEyePos, entityEyePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS;
    }
}

