/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.blaze3d;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.mixin.client.blaze3d.RenderSystemAccessor;

@Mixin(value={RenderTarget.class})
public abstract class RenderTargetMixin
implements RenderTargetExtension {
    @Unique
    private int vivecraft$texid = -1;
    @Unique
    private boolean vivecraft$linearFilter;
    @Unique
    private boolean vivecraft$useStencil = false;
    @Unique
    private boolean vivecraft$loggedSizeError = false;
    @Shadow
    public int f_83920_;
    @Shadow
    public int f_83915_;
    @Shadow
    public int f_83916_;
    @Shadow
    public int f_83918_;
    @Shadow
    public int f_83917_;
    @Shadow
    protected int f_83923_;

    @Shadow
    public abstract void m_83954_(boolean var1);

    @Override
    public void vivecraft$setUseStencil(boolean useStencil) {
        this.vivecraft$useStencil = useStencil;
    }

    @Override
    public boolean vivecraft$getUseStencil() {
        return this.vivecraft$useStencil;
    }

    @Override
    public void vivecraft$setTextid(int texid) {
        this.vivecraft$texid = texid;
    }

    @Override
    public void vivecraft$isLinearFilter(boolean linearFilter) {
        this.vivecraft$linearFilter = linearFilter;
    }

    public String toString() {
        String stringbuilder = "\nSize:   " + this.f_83917_ + " x " + this.f_83918_ + "\nFB ID:  " + this.f_83920_ + "\nTex ID: " + this.f_83923_ + "\n";
        return stringbuilder;
    }

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;generateTextureId()I", remap=false, ordinal=0), method={"createBuffers"})
    public int vivecraft$genTextureId() {
        if (this.vivecraft$texid == -1) {
            return TextureUtil.generateTextureId();
        }
        return this.vivecraft$texid;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_texImage2D(IIIIIIIILjava/nio/IntBuffer;)V", remap=false, ordinal=0), method={"createBuffers"}, index=2)
    public int vivecraft$modifyTexImage2DInternalformat(int internalformat) {
        return this.vivecraft$useStencil ? 36013 : internalformat;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_texImage2D(IIIIIIIILjava/nio/IntBuffer;)V", remap=false, ordinal=0), method={"createBuffers"}, index=6)
    public int vivecraft$modifyTexImage2DFormat(int format) {
        return this.vivecraft$useStencil ? 34041 : format;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_texImage2D(IIIIIIIILjava/nio/IntBuffer;)V", remap=false, ordinal=0), method={"createBuffers"}, index=7)
    public int vivecraft$modifyTexImage2DType(int type) {
        return this.vivecraft$useStencil ? 36269 : type;
    }

    @ModifyConstant(method={"createBuffers"}, constant={@Constant(intValue=9728)})
    public int vivecraft$changeTextPar(int i) {
        return this.vivecraft$linearFilter ? 9729 : i;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_glFramebufferTexture2D(IIIII)V", remap=false, ordinal=1), method={"createBuffers"}, index=1)
    public int vivecraft$modifyGlFramebufferTexture2DAttachment(int attachment) {
        return this.vivecraft$useStencil ? 33306 : attachment;
    }

    @ModifyArg(method={"clear"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/pipeline/RenderTarget;bindWrite(Z)V"))
    private boolean vivecraft$noViewportChangeOnClear(boolean changeViewport) {
        if (RenderPassType.isWorldOnly()) {
            if (!(this.vivecraft$loggedSizeError || this.f_83915_ == Minecraft.m_91087_().m_91385_().f_83915_ && this.f_83916_ == Minecraft.m_91087_().m_91385_().f_83916_)) {
                VRSettings.logger.error("Vivecraft: Mismatched RenderTarget size detected, viewport size change was blocked. MainTarget size: {}x{}, RenderTarget size: {}x{}. RenderPass: {}, Stacktrace:", new Object[]{Minecraft.m_91087_().m_91385_().f_83915_, Minecraft.m_91087_().m_91385_().f_83916_, this.f_83915_, this.f_83916_, ClientDataHolderVR.getInstance().currentPass, new RuntimeException()});
                this.vivecraft$loggedSizeError = true;
            }
            return false;
        }
        return changeViewport;
    }

    @Override
    public void vivecraft$blitToScreen(ShaderInstance instance, int left, int width, int height, int top, boolean disableBlend, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnGameThreadOrInit();
        if (!RenderSystem.isInInitPhase()) {
            RenderSystem.recordRenderCall(() -> this.vivecraft$_blitToScreen(instance, left, width, height, top, disableBlend, xCropFactor, yCropFactor, keepAspect));
        } else {
            this.vivecraft$_blitToScreen(instance, left, width, height, top, disableBlend, xCropFactor, yCropFactor, keepAspect);
        }
    }

    @Override
    public void vivecraft$blitFovReduction(ShaderInstance instance, int width, int height) {
        RenderSystem.assertOnRenderThread();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
        RenderSystem.disableBlend();
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.setShaderTexture((int)0, (int)this.f_83923_);
        if (instance == null) {
            instance = minecraft.f_91063_.f_172635_;
            instance.m_173350_("DiffuseSampler", (Object)this.f_83923_);
        } else {
            for (int k = 0; k < RenderSystemAccessor.getShaderTextures().length; ++k) {
                int l = RenderSystem.getShaderTexture((int)k);
                instance.m_173350_("Sampler" + k, (Object)l);
            }
        }
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        if (instance.f_173308_ != null) {
            instance.f_173308_.m_5679_(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        }
        if (instance.f_173309_ != null) {
            instance.f_173309_.m_5679_(matrix4f);
        }
        instance.m_173363_();
        float f = width;
        float g = height;
        float h = (float)this.f_83917_ / (float)this.f_83915_;
        float k = (float)this.f_83918_ / (float)this.f_83916_;
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, instance.m_173364_());
        if (instance.m_173364_() == DefaultVertexFormat.f_85817_) {
            bufferBuilder.m_5483_(0.0, (double)g, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)f, (double)g, 0.0).m_7421_(h, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)f, 0.0, 0.0).m_7421_(h, k).m_5752_();
            bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, k).m_5752_();
        } else if (instance.m_173364_() == DefaultVertexFormat.f_85819_) {
            bufferBuilder.m_5483_(0.0, (double)g, 0.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferBuilder.m_5483_((double)f, (double)g, 0.0).m_7421_(h, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            bufferBuilder.m_5483_((double)f, 0.0, 0.0).m_7421_(h, k).m_6122_(255, 255, 255, 255).m_5752_();
            bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, k).m_6122_(255, 255, 255, 255).m_5752_();
        } else {
            throw new IllegalStateException("Unexpected vertex format " + instance.m_173364_());
        }
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        instance.m_173362_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    @Unique
    private void vivecraft$_blitToScreen(ShaderInstance instance, int left, int width, int height, int top, boolean bl, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnGameThreadOrInit();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.viewport((int)left, (int)top, (int)width, (int)height);
        if (bl) {
            RenderSystem.disableBlend();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        float f = (float)width / (float)height;
        float f1 = (float)this.f_83917_ / (float)this.f_83918_;
        float f2 = width;
        float f3 = height;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (keepAspect) {
            if (f > f1) {
                float f6 = (float)width / (float)this.f_83917_;
                f4 = 0.0f;
                f2 = width;
                f5 = (float)height / 2.0f - (float)this.f_83918_ / 2.0f * f6;
                f3 = (float)height / 2.0f + (float)this.f_83918_ / 2.0f * f6;
            } else {
                float f10 = (float)height / (float)this.f_83918_;
                f4 = (float)width / 2.0f - (float)this.f_83917_ / 2.0f * f10;
                f2 = (float)width / 2.0f + (float)this.f_83917_ / 2.0f * f10;
                f5 = 0.0f;
                f3 = height;
            }
        }
        float f11 = width;
        float f7 = height;
        float f8 = (float)this.f_83917_ / (float)this.f_83915_;
        float f9 = (float)this.f_83918_ / (float)this.f_83916_;
        if (instance == null) {
            instance = minecraft.f_91063_.f_172635_;
            instance.m_173350_("DiffuseSampler", (Object)this.f_83923_);
        } else {
            for (int k = 0; k < RenderSystemAccessor.getShaderTextures().length; ++k) {
                int l = RenderSystem.getShaderTexture((int)k);
                instance.m_173350_("Sampler" + k, (Object)l);
            }
        }
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        if (instance.f_173308_ != null) {
            instance.f_173308_.m_5679_(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        }
        if (instance.f_173309_ != null) {
            instance.f_173309_.m_5679_(matrix4f);
        }
        instance.m_173363_();
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, instance.m_173364_());
        bufferbuilder.m_5483_((double)f4, (double)f3, 0.0).m_7421_(xCropFactor, yCropFactor).m_6122_(255, 255, 255, 255).m_5752_();
        bufferbuilder.m_5483_((double)f2, (double)f3, 0.0).m_7421_(f8 - xCropFactor, yCropFactor).m_6122_(255, 255, 255, 255).m_5752_();
        bufferbuilder.m_5483_((double)f2, (double)f5, 0.0).m_7421_(f8 - xCropFactor, f9 - yCropFactor).m_6122_(255, 255, 255, 255).m_5752_();
        bufferbuilder.m_5483_((double)f4, (double)f5, 0.0).m_7421_(xCropFactor, f9 - yCropFactor).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        instance.m_173362_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

