/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_xr.render_pass;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import org.vivecraft.client_vr.VRTextureTarget;

public class WorldRenderPass
implements AutoCloseable {
    private static final Minecraft mc = Minecraft.m_91087_();
    public static WorldRenderPass stereoXR;
    public static WorldRenderPass center;
    public static WorldRenderPass mixedReality;
    public static WorldRenderPass leftTelescope;
    public static WorldRenderPass rightTelescope;
    public static WorldRenderPass camera;
    public final VRTextureTarget target;
    public final PostChain transparencyChain;
    public final PostChain outlineChain;
    public PostChain postEffect = null;

    public WorldRenderPass(VRTextureTarget target) throws IOException {
        this.target = target;
        this.transparencyChain = Minecraft.m_91085_() ? WorldRenderPass.createPostChain(new ResourceLocation("shaders/post/vrtransparency.json"), this.target) : null;
        this.outlineChain = WorldRenderPass.createPostChain(new ResourceLocation("shaders/post/entity_outline.json"), this.target);
    }

    public static PostChain createPostChain(ResourceLocation resourceLocation, RenderTarget target) throws IOException {
        PostChain postchain = new PostChain(mc.m_91097_(), mc.m_91098_(), target, resourceLocation);
        postchain.m_110025_(target.f_83917_, target.f_83918_);
        return postchain;
    }

    public void resize(int width, int height) {
        this.target.m_83941_(width, height, Minecraft.f_91002_);
        this.outlineChain.m_110025_(width, height);
        if (this.transparencyChain != null) {
            this.transparencyChain.m_110025_(width, height);
        }
        if (this.postEffect != null) {
            this.postEffect.m_110025_(width, height);
        }
    }

    @Override
    public void close() {
        this.target.m_83930_();
        if (this.transparencyChain != null) {
            this.transparencyChain.close();
        }
        this.outlineChain.close();
    }
}

