/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.trackers.CameraTracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRWidgetHelper {
    private static final RandomSource random = RandomSource.m_216327_();
    public static boolean debug = false;

    public static void renderVRThirdPersonCamWidget() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (!(!dataholder.vrSettings.mixedRealityRenderCameraModel || dataholder.currentPass != RenderPass.LEFT && dataholder.currentPass != RenderPass.RIGHT || dataholder.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY && dataholder.vrSettings.displayMirrorMode != VRSettings.MirrorMode.THIRD_PERSON || ClientDataHolderVR.getInstance().vrSettings.displayMirrorUseScreenshotCamera && ClientDataHolderVR.getInstance().cameraTracker.isVisible())) {
            float f = 0.35f;
            if (dataholder.interactTracker.isInCamera() && !VRHotkeys.isMovingThirdPersonCam()) {
                f *= 1.03f;
            }
            VRWidgetHelper.renderVRCameraWidget(-0.748f, -0.438f, -0.06f, f, RenderPass.THIRD, ClientDataHolderVR.thirdPersonCameraModel, ClientDataHolderVR.thirdPersonCameraDisplayModel, () -> {
                dataholder.vrRenderer.framebufferMR.m_83956_();
                RenderSystem.setShaderTexture((int)0, (int)dataholder.vrRenderer.framebufferMR.m_83975_());
            }, face -> {
                if (face == Direction.NORTH) {
                    return DisplayFace.MIRROR;
                }
                return face == Direction.SOUTH ? DisplayFace.NORMAL : DisplayFace.NONE;
            });
        }
    }

    public static void renderVRHandheldCameraWidget() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (dataholder.currentPass != RenderPass.CAMERA && dataholder.cameraTracker.isVisible()) {
            float f = 0.25f;
            if (dataholder.interactTracker.isInHandheldCamera() && !dataholder.cameraTracker.isMoving()) {
                f *= 1.03f;
            }
            VRWidgetHelper.renderVRCameraWidget(-0.5f, -0.25f, -0.22f, f, RenderPass.CAMERA, CameraTracker.cameraModel, CameraTracker.cameraDisplayModel, () -> {
                if (VREffectsHelper.getNearOpaqueBlock(dataholder.vrPlayer.vrdata_world_render.getEye(RenderPass.CAMERA).getPosition(), ((GameRendererExtension)minecraft.f_91063_).vivecraft$getMinClipDistance()) == null) {
                    dataholder.vrRenderer.cameraFramebuffer.m_83956_();
                    RenderSystem.setShaderTexture((int)0, (int)dataholder.vrRenderer.cameraFramebuffer.m_83975_());
                } else {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("vivecraft:textures/black.png"));
                }
            }, face -> face == Direction.SOUTH ? DisplayFace.NORMAL : DisplayFace.NONE);
        }
    }

    public static void renderVRCameraWidget(float offsetX, float offsetY, float offsetZ, float scale, RenderPass renderPass, ModelResourceLocation model, ModelResourceLocation displayModel, Runnable displayBindFunc, Function<Direction, DisplayFace> displayFaceFunc) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderHelper.applyVRModelView(dataholder.currentPass, poseStack);
        Vec3 widgetPosition = dataholder.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition();
        Vec3 eye = RenderHelper.getSmoothCameraPosition(dataholder.currentPass, dataholder.vrPlayer.vrdata_world_render);
        Vec3 widgetOffset = widgetPosition.m_82546_(eye);
        poseStack.m_85837_(widgetOffset.f_82479_, widgetOffset.f_82480_, widgetOffset.f_82481_);
        poseStack.m_252931_(dataholder.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix().toMCMatrix());
        poseStack.m_85841_(scale *= dataholder.vrPlayer.vrdata_world_render.worldScale, scale, scale);
        if (debug) {
            MethodHolder.rotateDeg(poseStack, 180.0f, 0.0f, 1.0f, 0.0f);
            RenderHelper.renderDebugAxes(0, 0, 0, 0.08f);
            MethodHolder.rotateDeg(poseStack, 180.0f, 0.0f, 1.0f, 0.0f);
        }
        poseStack.m_252880_(offsetX, offsetY, offsetZ);
        RenderSystem.applyModelViewMatrix();
        BlockPos blockpos = BlockPos.m_274446_((Position)dataholder.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition());
        int i = Utils.getCombinedLightWithMin((BlockAndTintGetter)minecraft.f_91073_, blockpos, 0);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        if (minecraft.f_91073_ != null) {
            RenderSystem.setShader(GameRenderer::m_172667_);
        } else {
            RenderSystem.setShader(GameRenderer::m_172838_);
        }
        minecraft.f_91063_.m_109154_().m_109896_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        PoseStack poseStack2 = new PoseStack();
        RenderHelper.applyVRModelView(dataholder.currentPass, poseStack2);
        poseStack2.m_85850_().m_252922_().identity();
        poseStack2.m_85850_().m_252943_().mul((Matrix3fc)new Matrix3f((Matrix4fc)dataholder.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix().toMCMatrix()));
        minecraft.m_91289_().m_110937_().m_111067_(poseStack2.m_85850_(), (VertexConsumer)bufferbuilder, null, minecraft.m_91304_().m_119422_(model), 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        displayBindFunc.run();
        RenderSystem.setShader(GameRenderer::m_172661_);
        BufferBuilder bufferbuilder1 = tesselator.m_85915_();
        bufferbuilder1.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        for (BakedQuad bakedquad : minecraft.m_91304_().m_119422_(displayModel).m_213637_(null, null, random)) {
            if (displayFaceFunc.apply(bakedquad.m_111306_()) == DisplayFace.NONE || !bakedquad.m_173410_().m_245424_().m_246162_().equals((Object)new ResourceLocation("vivecraft:transparent"))) continue;
            int[] vertexList = bakedquad.m_111303_();
            boolean flag = displayFaceFunc.apply(bakedquad.m_111306_()) == DisplayFace.MIRROR;
            Vector3f normal = poseStack.m_85850_().m_252943_().transform(new Vector3f(0.0f, 1.0f, 0.0f));
            int j = LightTexture.m_109885_((int)15, (int)15);
            int step = vertexList.length / 4;
            bufferbuilder1.m_5483_((double)Float.intBitsToFloat(vertexList[0]), (double)Float.intBitsToFloat(vertexList[1]), (double)Float.intBitsToFloat(vertexList[2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(flag ? 1.0f : 0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            bufferbuilder1.m_5483_((double)Float.intBitsToFloat(vertexList[step]), (double)Float.intBitsToFloat(vertexList[step + 1]), (double)Float.intBitsToFloat(vertexList[step + 2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(flag ? 1.0f : 0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            bufferbuilder1.m_5483_((double)Float.intBitsToFloat(vertexList[step * 2]), (double)Float.intBitsToFloat(vertexList[step * 2 + 1]), (double)Float.intBitsToFloat(vertexList[step * 2 + 2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(flag ? 0.0f : 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_5601_(normal.x, normal.y, normal.z).m_5752_();
            bufferbuilder1.m_5483_((double)Float.intBitsToFloat(vertexList[step * 3]), (double)Float.intBitsToFloat(vertexList[step * 3 + 1]), (double)Float.intBitsToFloat(vertexList[step * 3 + 2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(flag ? 0.0f : 1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_5601_(normal.x, normal.y, normal.z).m_5752_();
        }
        tesselator.m_85914_();
        minecraft.f_91063_.m_109154_().m_109891_();
        RenderSystem.enableBlend();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static enum DisplayFace {
        NONE,
        NORMAL,
        MIRROR;

    }
}

