/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.ShadersHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class VRArmHelper {
    private static final ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Vec3i tpUnlimitedColor = new Vec3i(173, 216, 230);
    private static final Vec3i tpLimitedColor = new Vec3i(205, 169, 205);
    private static final Vec3i tpInvalidColor = new Vec3i(83, 83, 83);

    public static boolean shouldRenderHands() {
        if (ClientDataHolderVR.viewonly) {
            return false;
        }
        if (VRArmHelper.dataHolder.currentPass == RenderPass.THIRD) {
            return VRArmHelper.dataHolder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY;
        }
        return VRArmHelper.dataHolder.currentPass != RenderPass.CAMERA;
    }

    public static void renderVRHands(float partialTicks, boolean renderRight, boolean renderLeft, boolean menuHandRight, boolean menuHandLeft, PoseStack poseStack) {
        PoseStack newPoseStack;
        mc.m_91307_().m_6180_("hands");
        RenderSystem.backupProjectionMatrix();
        if (renderRight) {
            ClientDataHolderVR.ismainhand = true;
            if (menuHandRight) {
                VRArmHelper.renderMainMenuHand(0, partialTicks, false, poseStack);
            } else {
                ((GameRendererExtension)VRArmHelper.mc.f_91063_).vivecraft$resetProjectionMatrix(partialTicks);
                newPoseStack = new PoseStack();
                newPoseStack.m_85850_().m_252922_().identity();
                RenderHelper.applyVRModelView(VRArmHelper.dataHolder.currentPass, newPoseStack);
                VRArmHelper.renderVRHand_Main(newPoseStack, partialTicks);
            }
            ClientDataHolderVR.ismainhand = false;
        }
        if (renderLeft) {
            if (menuHandLeft) {
                VRArmHelper.renderMainMenuHand(1, partialTicks, false, poseStack);
            } else {
                ((GameRendererExtension)VRArmHelper.mc.f_91063_).vivecraft$resetProjectionMatrix(partialTicks);
                newPoseStack = new PoseStack();
                newPoseStack.m_85850_().m_252922_().identity();
                RenderHelper.applyVRModelView(VRArmHelper.dataHolder.currentPass, newPoseStack);
                VRArmHelper.renderVRHand_Offhand(partialTicks, true, newPoseStack);
            }
        }
        RenderSystem.restoreProjectionMatrix();
        mc.m_91307_().m_7238_();
    }

    public static void renderMainMenuHand(int c, float partialTicks, boolean depthAlways, PoseStack poseStack) {
        ((GameRendererExtension)VRArmHelper.mc.f_91063_).vivecraft$resetProjectionMatrix(partialTicks);
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderHelper.applyVRModelView(VRArmHelper.dataHolder.currentPass, poseStack);
        RenderHelper.setupRenderingAtController(c, poseStack);
        if (mc.m_91265_() == null) {
            mc.m_91097_().m_174784_(new ResourceLocation("vivecraft:textures/white.png"));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("vivecraft:textures/white.png"));
        }
        Tesselator tesselator = Tesselator.m_85913_();
        if (depthAlways && c == 0) {
            RenderSystem.depthFunc((int)519);
        } else {
            RenderSystem.depthFunc((int)515);
        }
        Vec3i color = new Vec3i(64, 64, 64);
        byte alpha = -1;
        Vec3 dir = new Vec3(0.0, 0.0, -1.0);
        Vec3 start = new Vec3(0.0, 0.0, 0.0);
        Vec3 end = new Vec3(start.f_82479_ - dir.f_82479_ * 0.18, start.f_82480_ - dir.f_82480_ * 0.18, start.f_82481_ - dir.f_82481_ * 0.18);
        if (VRArmHelper.mc.f_91073_ != null) {
            int minLight;
            float light = VRArmHelper.mc.f_91073_.m_46803_(BlockPos.m_274446_((Position)VRArmHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getPosition()));
            if (light < (float)(minLight = ShadersHelper.ShaderLight())) {
                light = minLight;
            }
            float lightPercent = light / (float)VRArmHelper.mc.f_91073_.m_7469_();
            color = new Vec3i(Mth.m_14143_((float)((float)color.m_123341_() * lightPercent)), Mth.m_14143_((float)((float)color.m_123342_() * lightPercent)), Mth.m_14143_((float)((float)color.m_123343_() * lightPercent)));
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        tesselator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
        RenderHelper.renderBox(tesselator, start, end, -0.02f, 0.02f, -0.0125f, 0.0125f, color, alpha, poseStack);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)tesselator.m_85915_().m_231175_());
        poseStack.m_85849_();
        RenderSystem.depthFunc((int)515);
    }

    public static void renderVRHand_Main(PoseStack poseStack, float partialTicks) {
        poseStack.m_85836_();
        RenderHelper.setupRenderingAtController(0, poseStack);
        ItemStack item = VRArmHelper.mc.f_91074_.m_21205_();
        Object override = null;
        if (override != null) {
            item = override;
        }
        if (VRArmHelper.dataHolder.climbTracker.isClimbeyClimb() && !VRArmHelper.dataHolder.climbTracker.isClaws(item) && override == null) {
            item = VRArmHelper.mc.f_91074_.m_21206_();
        }
        if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.mc.f_91074_, InteractionHand.MAIN_HAND)) {
            ItemStack ammo;
            c = false;
            if (VRArmHelper.dataHolder.vrSettings.reverseShootingEye) {
                c = true;
            }
            item = (ammo = VRArmHelper.mc.f_91074_.m_6298_(VRArmHelper.mc.f_91074_.m_21205_())) != ItemStack.f_41583_ && !VRArmHelper.dataHolder.bowTracker.isNotched() ? ammo : ItemStack.f_41583_;
        } else if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.mc.f_91074_, InteractionHand.OFF_HAND) && VRArmHelper.dataHolder.bowTracker.isNotched()) {
            c = false;
            if (VRArmHelper.dataHolder.vrSettings.reverseShootingEye) {
                c = true;
            }
            item = ItemStack.f_41583_;
        }
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.beginEntities();
        }
        poseStack.m_85836_();
        VRArmHelper.mc.f_91063_.m_109154_().m_109896_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VRArmHelper.mc.f_91063_.f_109055_.m_109371_((AbstractClientPlayer)VRArmHelper.mc.f_91074_, partialTicks, 0.0f, InteractionHand.MAIN_HAND, VRArmHelper.mc.f_91074_.m_21324_(partialTicks), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, mc.m_91290_().m_114394_((Entity)VRArmHelper.mc.f_91074_, partialTicks));
        bufferSource.m_109911_();
        VRArmHelper.mc.f_91063_.m_109154_().m_109891_();
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.endEntities();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public static void renderVRHand_Offhand(float partialTicks, boolean renderTeleport, PoseStack poseStack) {
        poseStack.m_85836_();
        RenderHelper.setupRenderingAtController(1, poseStack);
        ItemStack item = VRArmHelper.mc.f_91074_.m_21206_();
        Object override = null;
        if (override != null) {
            item = override;
        }
        if (VRArmHelper.dataHolder.climbTracker.isClimbeyClimb() && !VRArmHelper.dataHolder.climbTracker.isClaws(item) && override == null) {
            item = VRArmHelper.mc.f_91074_.m_21205_();
        }
        if (BowTracker.isHoldingBow((LivingEntity)VRArmHelper.mc.f_91074_, InteractionHand.MAIN_HAND)) {
            boolean c = true;
            if (VRArmHelper.dataHolder.vrSettings.reverseShootingEye) {
                c = false;
            }
            item = VRArmHelper.mc.f_91074_.m_21205_();
        }
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.beginEntities();
        }
        poseStack.m_85836_();
        VRArmHelper.mc.f_91063_.m_109154_().m_109896_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VRArmHelper.mc.f_91063_.f_109055_.m_109371_((AbstractClientPlayer)VRArmHelper.mc.f_91074_, partialTicks, 0.0f, InteractionHand.OFF_HAND, VRArmHelper.mc.f_91074_.m_21324_(partialTicks), item, 0.0f, poseStack, (MultiBufferSource)bufferSource, mc.m_91290_().m_114394_((Entity)VRArmHelper.mc.f_91074_, partialTicks));
        bufferSource.m_109911_();
        VRArmHelper.mc.f_91063_.m_109154_().m_109891_();
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.endEntities();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        if (renderTeleport) {
            poseStack.m_85836_();
            poseStack.m_166856_();
            RenderHelper.applyVRModelView(VRArmHelper.dataHolder.currentPass, poseStack);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (ClientNetworking.isLimitedSurvivalTeleport() && !VRArmHelper.dataHolder.vrPlayer.getFreeMove() && VRArmHelper.mc.f_91072_.m_105289_() && VRArmHelper.dataHolder.teleportTracker.vrMovementStyle.arcAiming && !VRArmHelper.dataHolder.bowTracker.isActive(VRArmHelper.mc.f_91074_)) {
                poseStack.m_85836_();
                RenderHelper.setupRenderingAtController(1, poseStack);
                Vec3 start = new Vec3(0.0, 0.005, 0.03);
                float max = 0.03f;
                float r = VRArmHelper.dataHolder.teleportTracker.isAiming() ? 2.0f * (float)((double)VRArmHelper.dataHolder.teleportTracker.getTeleportEnergy() - 4.0 * VRArmHelper.dataHolder.teleportTracker.movementTeleportDistance) / 100.0f * max : 2.0f * VRArmHelper.dataHolder.teleportTracker.getTeleportEnergy() / 100.0f * max;
                if (r < 0.0f) {
                    r = 0.0f;
                }
                RenderSystem.setShader(GameRenderer::m_172811_);
                mc.m_91097_().m_174784_(new ResourceLocation("vivecraft:textures/white.png"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("vivecraft:textures/white.png"));
                RenderHelper.renderFlatQuad(start.m_82520_(0.0, 0.05001, 0.0), r, r, 0.0f, tpLimitedColor.m_123341_(), tpLimitedColor.m_123342_(), tpLimitedColor.m_123343_(), 128, poseStack);
                RenderHelper.renderFlatQuad(start.m_82520_(0.0, 0.05, 0.0), max, max, 0.0f, tpLimitedColor.m_123341_(), tpLimitedColor.m_123342_(), tpLimitedColor.m_123343_(), 50, poseStack);
                poseStack.m_85849_();
            }
            if (VRArmHelper.dataHolder.teleportTracker.isAiming()) {
                RenderSystem.enableDepthTest();
                if (VRArmHelper.dataHolder.teleportTracker.vrMovementStyle.arcAiming) {
                    VRArmHelper.renderTeleportArc(poseStack);
                }
            }
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
        }
    }

    public static void renderTeleportArc(PoseStack poseStack) {
        if (VRArmHelper.dataHolder.teleportTracker.vrMovementStyle.showBeam && VRArmHelper.dataHolder.teleportTracker.isAiming() && VRArmHelper.dataHolder.teleportTracker.movementTeleportArcSteps > 1) {
            Vec3i color;
            mc.m_91307_().m_6180_("teleportArc");
            RenderSystem.enableCull();
            RenderSystem.setShader(GameRenderer::m_172811_);
            mc.m_91097_().m_174784_(new ResourceLocation("vivecraft:textures/white.png"));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("vivecraft:textures/white.png"));
            Tesselator tesselator = Tesselator.m_85913_();
            tesselator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_166851_);
            double VOffset = VRArmHelper.dataHolder.teleportTracker.lastTeleportArcDisplayOffset;
            Vec3 dest = VRArmHelper.dataHolder.teleportTracker.getDestination();
            boolean validLocation = dest.f_82479_ != 0.0 || dest.f_82480_ != 0.0 || dest.f_82481_ != 0.0;
            byte alpha = -1;
            if (!validLocation) {
                color = tpInvalidColor;
                alpha = -128;
            } else {
                color = ClientNetworking.isLimitedSurvivalTeleport() && !VRArmHelper.mc.f_91074_.m_150110_().f_35936_ ? tpLimitedColor : tpUnlimitedColor;
                VRArmHelper.dataHolder.teleportTracker.lastTeleportArcDisplayOffset = VOffset = VRArmHelper.dataHolder.vrRenderer.getCurrentTimeSecs() * (double)VRArmHelper.dataHolder.teleportTracker.vrMovementStyle.textureScrollSpeed * 0.6;
            }
            float segmentHalfWidth = VRArmHelper.dataHolder.teleportTracker.vrMovementStyle.beamHalfWidth * 0.15f;
            int segments = VRArmHelper.dataHolder.teleportTracker.movementTeleportArcSteps - 1;
            if (VRArmHelper.dataHolder.teleportTracker.vrMovementStyle.beamGrow) {
                segments = (int)((double)segments * VRArmHelper.dataHolder.teleportTracker.movementTeleportProgress);
            }
            double segmentProgress = 1.0 / (double)segments;
            Vec3 cameraPosition = RenderHelper.getSmoothCameraPosition(VRArmHelper.dataHolder.currentPass, VRArmHelper.dataHolder.vrPlayer.getVRDataWorld());
            for (int i = 0; i < segments; ++i) {
                double progress = (double)i / (double)segments + VOffset * segmentProgress;
                int progressBase = Mth.m_14107_((double)progress);
                Vec3 start = VRArmHelper.dataHolder.teleportTracker.getInterpolatedArcPosition((float)((progress -= (double)progressBase) - segmentProgress * (double)0.4f)).m_82546_(cameraPosition);
                Vec3 end = VRArmHelper.dataHolder.teleportTracker.getInterpolatedArcPosition((float)progress).m_82546_(cameraPosition);
                float shift = (float)progress * 2.0f;
                RenderHelper.renderBox(tesselator, start, end, -segmentHalfWidth, segmentHalfWidth, (-1.0f + shift) * segmentHalfWidth, (1.0f + shift) * segmentHalfWidth, color, alpha, poseStack);
            }
            tesselator.m_85914_();
            if (validLocation && VRArmHelper.dataHolder.teleportTracker.movementTeleportProgress >= 1.0) {
                RenderSystem.disableCull();
                Vec3 vec34 = new Vec3(dest.f_82479_, dest.f_82480_, dest.f_82481_).m_82546_(cameraPosition);
                float offset = 0.01f;
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                RenderHelper.renderFlatQuad(vec34.m_82520_(x, y += (double)offset, z), 0.6f, 0.6f, 0.0f, (int)((double)color.m_123341_() * 1.03), (int)((double)color.m_123342_() * 1.03), (int)((double)color.m_123343_() * 1.03), 64, poseStack);
                RenderHelper.renderFlatQuad(vec34.m_82520_(x, y += (double)offset, z), 0.4f, 0.4f, 0.0f, (int)((double)color.m_123341_() * 1.04), (int)((double)color.m_123342_() * 1.04), (int)((double)color.m_123343_() * 1.04), 64, poseStack);
                RenderHelper.renderFlatQuad(vec34.m_82520_(x, y += (double)offset, z), 0.2f, 0.2f, 0.0f, (int)((double)color.m_123341_() * 1.05), (int)((double)color.m_123342_() * 1.05), (int)((double)color.m_123343_() * 1.05), 64, poseStack);
                RenderSystem.enableCull();
            }
            mc.m_91307_().m_7238_();
        }
    }
}

