/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.ItemTags;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;

public class VivecraftItemRendering {
    private static final ClientDataHolderVR dh = ClientDataHolderVR.getInstance();

    public static VivecraftItemTransformType getTransformType(ItemStack pStack, AbstractClientPlayer pPlayer, ItemRenderer itemRenderer) {
        VivecraftItemTransformType rendertype = VivecraftItemTransformType.Item;
        Item item = pStack.m_41720_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (pStack.m_41780_() != UseAnim.EAT && pStack.m_41780_() != UseAnim.DRINK) {
            if (item instanceof BlockItem) {
                BakedModel bakedmodel;
                Block block = ((BlockItem)item).m_40614_();
                rendertype = block instanceof TorchBlock ? VivecraftItemTransformType.Block_Stick : ((bakedmodel = itemRenderer.m_174264_(pStack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0)).m_7539_() ? VivecraftItemTransformType.Block_3D : VivecraftItemTransformType.Block_Item);
            } else if (item instanceof MapItem || pStack.m_204117_(ItemTags.VIVECRAFT_MAPS)) {
                rendertype = VivecraftItemTransformType.Map;
            } else if (pStack.m_41780_() == UseAnim.BOW && !pStack.m_204117_(ItemTags.VIVECRAFT_BOW_EXCLUSION)) {
                rendertype = VivecraftItemTransformType.Bow_Seated;
                if (VivecraftItemRendering.dh.bowTracker.isActive((LocalPlayer)pPlayer)) {
                    rendertype = VivecraftItemRendering.dh.bowTracker.isDrawing ? VivecraftItemTransformType.Bow_Roomscale_Drawing : VivecraftItemTransformType.Bow_Roomscale;
                }
            } else if (pStack.m_41780_() == UseAnim.TOOT_HORN) {
                rendertype = VivecraftItemTransformType.Horn;
            } else if (item instanceof SwordItem || pStack.m_204117_(ItemTags.VIVECRAFT_SWORDS)) {
                rendertype = VivecraftItemTransformType.Sword;
            } else if (item instanceof ShieldItem || pStack.m_204117_(ItemTags.VIVECRAFT_SHIELDS)) {
                rendertype = VivecraftItemTransformType.Shield;
            } else if (item instanceof TridentItem || pStack.m_204117_(ItemTags.VIVECRAFT_SPEARS)) {
                rendertype = VivecraftItemTransformType.Spear;
            } else if (item instanceof CrossbowItem || pStack.m_204117_(ItemTags.VIVECRAFT_CROSSBOWS)) {
                rendertype = VivecraftItemTransformType.Crossbow;
            } else if (item instanceof CompassItem || item == Items.f_42524_ || pStack.m_204117_(ItemTags.VIVECRAFT_COMPASSES)) {
                rendertype = VivecraftItemTransformType.Compass;
            } else if (SwingTracker.isTool(item)) {
                rendertype = VivecraftItemTransformType.Tool;
                if (item instanceof FoodOnAStickItem || item instanceof FishingRodItem || pStack.m_204117_(ItemTags.VIVECRAFT_FISHING_RODS)) {
                    rendertype = VivecraftItemTransformType.Tool_Rod;
                }
            } else if (TelescopeTracker.isTelescope(pStack)) {
                rendertype = VivecraftItemTransformType.Telescope;
            }
        } else {
            rendertype = VivecraftItemTransformType.Noms;
        }
        return rendertype;
    }

    public static void applyThirdPersonItemTransforms(PoseStack pMatrixStack, VivecraftItemTransformType rendertype, boolean mainHand, AbstractClientPlayer pPlayer, float pEquippedProgress, float pPartialTicks, ItemStack pStack, InteractionHand pHand) {
        int k = mainHand ? 1 : -1;
        Minecraft minecraft = Minecraft.m_91087_();
        double scale = 0.525;
        double translateX = 0.0;
        double translateY = 0.05;
        double translateZ = 0.0;
        boolean useLeftHandModelinLeftHand = false;
        if (VivecraftItemRendering.dh.climbTracker.isClaws(pStack)) {
            scale = 0.4;
        }
        pMatrixStack.m_85837_(translateX, translateY, translateZ);
        pMatrixStack.m_85841_((float)scale, (float)scale, (float)scale);
    }

    public static void applyFirstPersonItemTransforms(PoseStack pMatrixStack, VivecraftItemTransformType rendertype, boolean mainHand, AbstractClientPlayer pPlayer, float pEquippedProgress, float pPartialTicks, ItemStack pStack, InteractionHand pHand) {
        int k = mainHand ? 1 : -1;
        Minecraft minecraft = Minecraft.m_91087_();
        double scale = 0.7;
        double translateX = -0.05;
        double translateY = 0.005;
        double translateZ = 0.0;
        boolean useLeftHandModelinLeftHand = false;
        double gunAngle = VivecraftItemRendering.dh.vr.getGunAngle();
        Quaternionf rotation = Axis.f_252436_.m_252977_(0.0f);
        Quaternionf preRotation = Axis.f_252436_.m_252977_(0.0f);
        rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(-110.0 + gunAngle)));
        if (rendertype == VivecraftItemTransformType.Bow_Seated) {
            translateY += -0.1;
            translateZ += 0.1;
            rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(90.0 - gunAngle)));
            scale = 0.7f;
        } else if (rendertype == VivecraftItemTransformType.Bow_Roomscale) {
            rotation = Axis.f_252529_.m_252977_(0.0f);
            pMatrixStack.m_252781_(Axis.f_252529_.m_252977_((float)(-110.0 + gunAngle)));
            translateY -= 0.25;
            translateZ += (double)0.025f + 0.03 * gunAngle / 40.0;
            translateX += -0.0225;
            scale = 1.0;
        } else if (rendertype == VivecraftItemTransformType.Bow_Roomscale_Drawing) {
            rotation = Axis.f_252436_.m_252977_(0.0f);
            scale = 1.0;
            boolean i = false;
            if (VivecraftItemRendering.dh.vrSettings.reverseShootingEye) {
                i = true;
            }
            Vec3 vec3 = VivecraftItemRendering.dh.bowTracker.getAimVector();
            Vec3 vec31 = new Vec3(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            Vec3 vec32 = VivecraftItemRendering.dh.vrPlayer.vrdata_world_render.getHand(1).getCustomVector(new Vec3(0.0, -1.0, 0.0));
            Vec3 vec33 = VivecraftItemRendering.dh.vrPlayer.vrdata_world_render.getHand(1).getCustomVector(new Vec3(0.0, 0.0, -1.0));
            vec31.m_82537_(vec32);
            double d4 = 57.29577951308232 * Math.acos(vec31.m_82526_(vec32));
            float f = (float)Math.toDegrees(Math.asin(vec31.f_82480_ / vec31.m_82553_()));
            float f1 = (float)Math.toDegrees(Math.atan2(vec31.f_82479_, vec31.f_82481_));
            Vec3 vec34 = new Vec3(0.0, 1.0, 0.0);
            Vec3 vec35 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
            Vec3 vec36 = Vec3.f_82478_;
            double d5 = vec33.m_82526_(vec35);
            if (d5 != 0.0) {
                vec36 = vec35.m_82490_(d5);
            }
            double d6 = 0.0;
            Vec3 vec37 = vec33.m_82546_(vec36).m_82541_();
            d6 = vec37.m_82526_(vec34);
            double d7 = vec35.m_82526_(vec37.m_82537_(vec34));
            float f2 = d7 < 0.0 ? -((float)Math.acos(d6)) : (float)Math.acos(d6);
            float f3 = (float)(57.29577951308232 * (double)f2);
            if (VivecraftItemRendering.dh.bowTracker.isCharged()) {
                long j = Util.m_137550_() - VivecraftItemRendering.dh.bowTracker.startDrawTime;
                translateX += 0.003 * Math.sin(j);
            }
            pMatrixStack.m_85837_(0.0, 0.0, 0.1);
            pMatrixStack.m_85850_().m_252922_().mul((Matrix4fc)VivecraftItemRendering.dh.vrPlayer.vrdata_world_render.getController(1).getMatrix().transposed().toMCMatrix());
            rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_(f1));
            rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-f));
            rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(-f3));
            rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(180.0f));
            pMatrixStack.m_85850_().m_252922_().rotate((Quaternionfc)rotation);
            rotation = Axis.f_252436_.m_252977_(0.0f);
            rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_(180.0f));
            rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(160.0f));
            translateY += 0.1225;
            translateX += 0.125;
            translateZ += 0.16;
        } else if (rendertype == VivecraftItemTransformType.Crossbow) {
            translateX += (double)0.01f;
            translateZ += (double)-0.02f;
            translateY += (double)-0.02f;
            scale = 0.5;
            rotation = Axis.f_252529_.m_252977_(0.0f);
            rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_(10.0f));
        } else if (rendertype == VivecraftItemTransformType.Map) {
            rotation = Axis.f_252529_.m_252977_(-45.0f);
            translateX = 0.0;
            translateY = 0.16;
            translateZ = -0.075;
            scale = 0.75;
        } else if (rendertype == VivecraftItemTransformType.Noms) {
            long l = minecraft.f_91074_.m_21212_();
            rotation = Axis.f_252403_.m_252977_(180.0f);
            rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-135.0f));
            translateZ += 0.006 * Math.sin(l);
            translateZ += (double)0.02f;
            translateX += (double)0.08f;
            scale = 0.4f;
        } else if (rendertype != VivecraftItemTransformType.Item && rendertype != VivecraftItemTransformType.Block_Item) {
            if (rendertype == VivecraftItemTransformType.Compass) {
                rotation = Axis.f_252436_.m_252977_(90.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(25.0f));
                scale = 0.4f;
            } else if (rendertype == VivecraftItemTransformType.Block_3D) {
                scale = 0.3f;
                translateZ += (double)-0.1f;
                translateX += (double)0.05f;
            } else if (rendertype == VivecraftItemTransformType.Block_Stick) {
                rotation = Axis.f_252529_.m_252977_(0.0f);
                translateY += -0.105 + 0.06 * gunAngle / 40.0;
                translateZ += (double)-0.1f;
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-45.0f));
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)gunAngle));
            } else if (rendertype == VivecraftItemTransformType.Horn) {
                scale = 0.3f;
                rotation = Axis.f_252529_.m_252977_(0.0f);
                translateY += -0.105 + 0.06 * gunAngle / 40.0;
                translateZ += (double)-0.1f;
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-45.0f));
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)gunAngle));
            } else if (rendertype == VivecraftItemTransformType.Shield) {
                boolean reverse = VivecraftItemRendering.dh.vrSettings.reverseHands;
                if (reverse) {
                    k *= -1;
                }
                scale = 0.4f;
                translateY += (double)0.18f;
                if (k == 1) {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(105.0 - gunAngle)));
                    translateX += (double)0.11f;
                } else {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(115.0 - gunAngle)));
                    translateX += -0.015;
                }
                translateZ += (double)0.1f;
                if (pPlayer.m_6117_() && pPlayer.m_21212_() > 0 && pPlayer.m_7655_() == pHand) {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)k * 5.0f));
                    rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(-5.0f));
                    if (k == 1) {
                        translateY += (double)-0.12f;
                        translateZ += (double)-0.1f;
                        translateX += (double)0.04f;
                    } else {
                        translateY += (double)-0.12f;
                        translateZ += (double)-0.11f;
                        translateX += (double)0.19f;
                    }
                    if (pPlayer.m_21254_()) {
                        rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)k * 90.0f));
                    } else {
                        rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((1.0f - pEquippedProgress) * (float)k * 90.0f));
                    }
                }
                rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)k * -90.0f));
            } else if (rendertype == VivecraftItemTransformType.Spear) {
                rotation = Axis.f_252529_.m_252977_(0.0f);
                translateX += (double)-0.135f;
                translateZ += (double)0.575f;
                scale = 0.6f;
                float f4 = 0.0f;
                boolean flag5 = false;
                int i1 = 0;
                if (pPlayer.m_6117_() && pPlayer.m_21212_() > 0 && pPlayer.m_7655_() == pHand) {
                    flag5 = true;
                    i1 = EnchantmentHelper.m_44932_((ItemStack)pStack);
                    if ((i1 <= 0 || i1 > 0 && pPlayer.m_20070_()) && (f4 = (float)pStack.m_41779_() - ((float)minecraft.f_91074_.m_21212_() - pPartialTicks + 1.0f)) > 10.0f) {
                        f4 = 10.0f;
                        if (i1 > 0 && pPlayer.m_20070_()) {
                            pMatrixStack.m_252781_(Axis.f_252403_.m_252977_((float)(-VivecraftItemRendering.dh.tickCounter * 10 * i1 % 360) - pPartialTicks * 10.0f * (float)i1));
                        }
                        if (VivecraftItemRendering.dh.frameIndex % 4L == 0L) {
                            VivecraftItemRendering.dh.vr.triggerHapticPulse(mainHand ? 0 : 1, 200);
                        }
                        long j1 = Util.m_137550_() - VivecraftItemRendering.dh.bowTracker.startDrawTime;
                        translateX += 0.003 * Math.sin(j1);
                    }
                }
                if (pPlayer.m_21209_()) {
                    i1 = 5;
                    translateZ += (double)-0.15f;
                    pMatrixStack.m_252781_(Axis.f_252403_.m_252977_((float)(-VivecraftItemRendering.dh.tickCounter * 10 * i1 % 360) - pPartialTicks * 10.0f * (float)i1));
                    flag5 = true;
                }
                if (!flag5) {
                    translateY += 0.0 + 0.2 * gunAngle / 40.0;
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)gunAngle));
                }
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-65.0f));
                translateZ += (double)(-0.75f + f4 / 10.0f * 0.25f);
            } else if (rendertype != VivecraftItemTransformType.Sword) {
                if (rendertype == VivecraftItemTransformType.Tool_Rod) {
                    translateZ += (double)-0.15f;
                    translateY += -0.02 + gunAngle / 40.0 * 0.1;
                    translateX += (double)0.05f;
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(40.0f));
                    scale = 0.8f;
                } else if (rendertype == VivecraftItemTransformType.Tool) {
                    if (pStack.m_41720_() instanceof ArrowItem || pStack.m_204117_(ItemTags.VIVECRAFT_ARROWS)) {
                        preRotation = Axis.f_252403_.m_252977_(-180.0f);
                        rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)(-gunAngle)));
                    }
                } else if (rendertype == VivecraftItemTransformType.Telescope) {
                    preRotation = Axis.f_252529_.m_252977_(0.0f);
                    rotation = Axis.f_252529_.m_252977_(0.0f);
                    translateZ = 0.0;
                    translateY = 0.0;
                    translateX = 0.0;
                }
            }
        } else {
            rotation = Axis.f_252403_.m_252977_(180.0f);
            rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-135.0f));
            scale = 0.4f;
            translateX += (double)0.08f;
            translateZ += (double)-0.08f;
        }
        pMatrixStack.m_252781_(preRotation);
        pMatrixStack.m_85837_(translateX, translateY, translateZ);
        pMatrixStack.m_252781_(rotation);
        pMatrixStack.m_85841_((float)scale, (float)scale, (float)scale);
    }

    public static enum VivecraftItemTransformType {
        Item,
        Block_3D,
        Block_Stick,
        Block_Item,
        Shield,
        Sword,
        Tool,
        Tool_Rod,
        Bow_Seated,
        Bow_Roomscale,
        Bow_Roomscale_Drawing,
        Spear,
        Map,
        Noms,
        Crossbow,
        Telescope,
        Compass,
        Horn;

    }
}

