/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.ItemTags;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.render.RenderPass;

public class TelescopeTracker
extends Tracker {
    public static final ModelResourceLocation scopeModel = new ModelResourceLocation("vivecraft", "spyglass_in_hand", "inventory");
    private static final double lensDistMax = 0.05;
    private static final double lensDistMin = 0.185;
    private static final double lensDotMax = 0.9;
    private static final double lensDotMin = 0.75;

    public TelescopeTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        return false;
    }

    @Override
    public void doProcess(LocalPlayer player) {
    }

    public static boolean isTelescope(ItemStack i) {
        return i != null && (i.m_41720_() == Items.f_151059_ || TelescopeTracker.isLegacyTelescope(i) || i.m_204117_(ItemTags.VIVECRAFT_TELESCOPE));
    }

    public static boolean isLegacyTelescope(ItemStack i) {
        if (i.m_41619_()) {
            return false;
        }
        if (!i.m_41788_()) {
            return false;
        }
        if (i.m_41720_() != Items.f_42545_) {
            return false;
        }
        if (!i.m_41782_() || !i.m_41783_().m_128471_("Unbreakable")) {
            return false;
        }
        return i.m_41786_().m_214077_() instanceof TranslatableContents && ((TranslatableContents)i.m_41786_().m_214077_()).m_237508_().equals("vivecraft.item.telescope") || i.m_41786_().getString().equals("Eye of the Farseer");
    }

    private static Vec3 getLensOrigin(int controller) {
        VRData.VRDevicePose vrdata$vrdevicepose = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getController(controller);
        return vrdata$vrdevicepose.getPosition().m_82549_(TelescopeTracker.getViewVector(controller).m_82490_(-0.2).m_82549_(vrdata$vrdevicepose.getDirection().m_82490_((double)0.05f)));
    }

    private static Vec3 getViewVector(int controller) {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getController(controller).getCustomVector(new Vec3(0.0, -1.0, 0.0));
    }

    public static boolean isViewing(int controller) {
        return TelescopeTracker.viewPercent(controller) > 0.0f;
    }

    public static float viewPercent(int controller) {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null && ClientDataHolderVR.getInstance().vrSettings.seated) {
            if (TelescopeTracker.isTelescope(p.m_21211_())) {
                return 1.0f;
            }
            return 0.0f;
        }
        float out = 0.0f;
        for (int e = 0; e < 2; ++e) {
            float tmp = TelescopeTracker.viewPercent(controller, e);
            if (!(tmp > out)) continue;
            out = tmp;
        }
        return out;
    }

    private static float viewPercent(int controller, int e) {
        if (e == -1 || ClientDataHolderVR.getInstance().vrPlayer == null) {
            return 0.0f;
        }
        VRData.VRDevicePose eye = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getEye(RenderPass.values()[e]);
        double dist = eye.getPosition().m_82546_(TelescopeTracker.getLensOrigin(controller)).m_82553_();
        Vec3 look = eye.getDirection();
        double dot = Math.abs(look.m_82526_(TelescopeTracker.getViewVector(controller)));
        double dfact = 0.0;
        double distfact = 0.0;
        if (dot > 0.75) {
            dfact = dot > 0.9 ? 1.0 : (dot - 0.75) / 0.15000000000000002;
        }
        if (dist < 0.185) {
            distfact = dist < 0.05 ? 1.0 : 1.0 - (dist - 0.05) / 0.135;
        }
        return (float)Math.min(dfact, distfact);
    }
}

