/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.BlockTags;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRMovementStyle;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRUtil;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.utils.math.Angle;
import org.vivecraft.common.utils.math.Matrix4f;
import org.vivecraft.common.utils.math.Quaternion;
import org.vivecraft.common.utils.math.Vector3;

public class TeleportTracker
extends Tracker {
    private float teleportEnergy;
    private Vec3 movementTeleportDestination = new Vec3(0.0, 0.0, 0.0);
    private Direction movementTeleportDestinationSideHit;
    public double movementTeleportProgress;
    public double movementTeleportDistance;
    private final Vec3[] movementTeleportArc = new Vec3[50];
    public int movementTeleportArcSteps = 0;
    public double lastTeleportArcDisplayOffset = 0.0;
    public VRMovementStyle vrMovementStyle;

    public TeleportTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
        this.vrMovementStyle = new VRMovementStyle(dh);
    }

    public float getTeleportEnergy() {
        return this.teleportEnergy;
    }

    public boolean isAiming() {
        return this.movementTeleportProgress > 0.0;
    }

    public Vec3 getDestination() {
        return this.movementTeleportDestination;
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (p == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!p.m_6084_()) {
            return false;
        }
        return !p.m_5803_();
    }

    @Override
    public void reset(LocalPlayer player) {
        this.movementTeleportDestination = new Vec3(0.0, 0.0, 0.0);
        this.movementTeleportArcSteps = 0;
        this.movementTeleportProgress = 0.0;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        boolean flag2;
        Random random = new Random();
        if (this.teleportEnergy < 100.0f) {
            this.teleportEnergy += 1.0f;
        }
        boolean flag = false;
        Vec3 vec3 = null;
        boolean flag1 = VivecraftVRMod.INSTANCE.keyTeleport.m_90857_() && this.dh.vrPlayer.isTeleportEnabled();
        boolean bl = flag2 = this.dh.vrSettings.seated && !this.dh.vrPlayer.getFreeMove() && (player.f_108618_.f_108567_ != 0.0f || player.f_108618_.f_108566_ != 0.0f);
        if ((flag1 || flag2) && !player.m_20159_()) {
            vec3 = this.movementTeleportDestination;
            if (this.vrMovementStyle.teleportOnRelease) {
                if (((PlayerExtension)player).vivecraft$getMovementTeleportTimer() == 0) {
                    String string = this.vrMovementStyle.startTeleportingSound;
                }
                ((PlayerExtension)player).vivecraft$setMovementTeleportTimer(((PlayerExtension)player).vivecraft$getMovementTeleportTimer() + 1);
                if (((PlayerExtension)player).vivecraft$getMovementTeleportTimer() > 0) {
                    this.movementTeleportProgress = ((PlayerExtension)player).vivecraft$getMovementTeleportTimer();
                    if (this.movementTeleportProgress >= 1.0) {
                        this.movementTeleportProgress = 1.0;
                    }
                    if (vec3.f_82479_ != 0.0 || vec3.f_82480_ != 0.0 || vec3.f_82481_ != 0.0) {
                        Vec3 vec38 = this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition();
                        Vec3 vec31 = vec3.m_82520_(-vec38.f_82479_, -vec38.f_82480_, -vec38.f_82481_).m_82541_();
                        Vec3 vec32 = player.m_20154_();
                        Vec3 vec33 = vec32.m_82537_(new Vec3(0.0, 1.0, 0.0));
                        Vec3 vec34 = vec33.m_82537_(vec32);
                        if (this.vrMovementStyle.airSparkles) {
                            for (int i = 0; i < 3; ++i) {
                                double d0 = random.nextDouble() + 3.5;
                                double d1 = random.nextDouble() * 2.5;
                                double d2 = random.nextDouble() * 4.0 - 2.0;
                                Vec3 vec36 = new Vec3(vec38.f_82479_ + vec32.f_82479_ * d0, vec38.f_82480_ + vec32.f_82480_ * d0, vec38.f_82481_ + vec32.f_82481_ * d0);
                                vec36 = vec36.m_82520_(vec33.f_82479_ * d2, vec33.f_82480_ * d2, vec33.f_82481_ * d2);
                                vec36.m_82520_(vec34.f_82479_ * d1, vec34.f_82480_ * d1, vec34.f_82481_ * d1);
                                double d = -0.6;
                            }
                        }
                    }
                }
            } else if (((PlayerExtension)player).vivecraft$getMovementTeleportTimer() >= 0 && (vec3.f_82479_ != 0.0 || vec3.f_82480_ != 0.0 || vec3.f_82481_ != 0.0)) {
                if (((PlayerExtension)player).vivecraft$getMovementTeleportTimer() == 0) {
                    // empty if block
                }
                ((PlayerExtension)player).vivecraft$setMovementTeleportTimer(((PlayerExtension)player).vivecraft$getMovementTeleportTimer() + 1);
                Vec3 vec39 = player.m_20182_();
                double d6 = vec3.m_82554_(vec39);
                double d7 = (double)((PlayerExtension)player).vivecraft$getMovementTeleportTimer() / (d6 + 3.0);
                if (((PlayerExtension)player).vivecraft$getMovementTeleportTimer() > 0) {
                    this.movementTeleportProgress = d7;
                    if (this.vrMovementStyle.destinationSparkles) {
                        // empty if block
                    }
                    Vec3 vec310 = vec3.m_82520_(-player.m_20185_(), -player.m_20186_(), -player.m_20189_()).m_82541_();
                    Vec3 vec311 = player.m_20154_();
                    Vec3 vec35 = vec311.m_82537_(new Vec3(0.0, 1.0, 0.0));
                    Vec3 vec312 = vec35.m_82537_(vec311);
                    if (this.vrMovementStyle.airSparkles) {
                        for (int j = 0; j < 3; ++j) {
                            double d8 = random.nextDouble() + 3.5;
                            double d9 = random.nextDouble() * 2.5;
                            double d4 = random.nextDouble() * 4.0 - 2.0;
                            Vec3 vec37 = new Vec3(player.m_20185_() + vec311.f_82479_ * d8, player.m_20186_() + vec311.f_82480_ * d8, player.m_20189_() + vec311.f_82481_ * d8);
                            vec37 = vec37.m_82520_(vec35.f_82479_ * d4, vec35.f_82480_ * d4, vec35.f_82481_ * d4);
                            vec37.m_82520_(vec312.f_82479_ * d9, vec312.f_82480_ * d9, vec312.f_82481_ * d9);
                            double d = -0.6;
                        }
                    }
                } else {
                    this.movementTeleportProgress = 0.0;
                }
                if (d7 >= 1.0) {
                    flag = true;
                }
            }
        } else {
            if (this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                vec3 = this.movementTeleportDestination;
                flag = true;
            }
            ((PlayerExtension)player).vivecraft$setMovementTeleportTimer(0);
            this.movementTeleportProgress = 0.0;
        }
        if (flag && vec3 != null && (vec3.f_82479_ != 0.0 || vec3.f_82480_ != 0.0 || vec3.f_82481_ != 0.0)) {
            this.movementTeleportDistance = vec3.m_82554_(player.m_20182_());
            if (this.movementTeleportDistance > 0.0 && this.vrMovementStyle.endTeleportingSound != null) {
                boolean vec39 = true;
            } else {
                boolean vec39 = false;
            }
            Object block = null;
            if (!this.dh.vrPlayer.isTeleportSupported()) {
                String s1 = "tp " + vec3.f_82479_ + " " + vec3.f_82480_ + " " + vec3.f_82481_;
                this.mc.f_91074_.f_108617_.m_246623_(s1);
            } else {
                if (ClientNetworking.serverSupportsDirectTeleport) {
                    ((PlayerExtension)player).vivecraft$setTeleported(true);
                }
                player.m_6027_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            this.doTeleportCallback();
            ((PlayerExtension)this.mc.f_91074_).vivecraft$stepSound(BlockPos.m_274446_((Position)vec3), vec3);
        }
    }

    public void updateTeleportDestinations(GameRenderer renderer, Minecraft mc, LocalPlayer player) {
        mc.m_91307_().m_6180_("updateTeleportDestinations");
        if (this.vrMovementStyle.arcAiming) {
            this.movementTeleportDestination = new Vec3(0.0, 0.0, 0.0);
            if (this.movementTeleportProgress > 0.0) {
                this.updateTeleportArc(mc, player);
            }
        }
        mc.m_91307_().m_7238_();
    }

    private void updateTeleportArc(Minecraft mc, LocalPlayer player) {
        Vec3 vec3 = this.dh.vrPlayer.vrdata_world_render.getController(1).getPosition();
        Vec3 vec31 = this.dh.vrPlayer.vrdata_world_render.getController(1).getDirection();
        Matrix4f matrix4f = this.dh.vr.getAimRotation(1);
        if (this.dh.vrSettings.seated) {
            vec3 = RenderHelper.getControllerRenderPos(0);
            vec31 = this.dh.vrPlayer.vrdata_world_render.getController(0).getDirection();
            matrix4f = this.dh.vr.getAimRotation(0);
        }
        Matrix4f matrix4f1 = Matrix4f.rotationY(this.dh.vrPlayer.vrdata_world_render.rotation_radians);
        matrix4f = Matrix4f.multiply(matrix4f1, matrix4f);
        Quaternion quaternion = OpenVRUtil.convertMatrix4ftoRotationQuat(matrix4f);
        Angle angle = quaternion.toEuler();
        int i = 50;
        this.movementTeleportArc[0] = new Vec3(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.movementTeleportArcSteps = 1;
        float f = 0.098f;
        Matrix4f matrix4f2 = Utils.rotationZMatrix((float)Math.toRadians(-angle.getRoll()));
        Matrix4f matrix4f3 = Utils.rotationXMatrix(-2.5132742f);
        Matrix4f matrix4f4 = Matrix4f.multiply(matrix4f, matrix4f2);
        Vector3 vector3 = new Vector3(0.0f, 1.0f, 0.0f);
        Vector3 vector31 = matrix4f4.transform(vector3);
        Vec3 vec32 = vector31.negate().toVector3d();
        vec32 = vec32.m_82490_((double)f);
        float f1 = 0.5f;
        Vec3 vec33 = new Vec3(vec31.f_82479_ * (double)f1, vec31.f_82480_ * (double)f1, vec31.f_82481_ * (double)f1);
        Vec3 vec34 = new Vec3(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        for (int j = this.movementTeleportArcSteps; j < i && !((float)(j * 4) > this.teleportEnergy); ++j) {
            Vec3 vec35 = new Vec3(vec34.f_82479_ + vec33.f_82479_, vec34.f_82480_ + vec33.f_82480_, vec34.f_82481_ + vec33.f_82481_);
            boolean flag = false;
            flag = this.dh.vrSettings.seated ? ((GameRendererExtension)mc.f_91063_).vivecraft$isInWater() : !mc.f_91073_.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_();
            BlockHitResult blockhitresult = mc.f_91073_.m_45547_(new ClipContext(vec34, vec35, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)mc.f_91074_));
            if (blockhitresult != null && blockhitresult.m_6662_() != HitResult.Type.MISS) {
                boolean flag1;
                this.movementTeleportArc[j] = blockhitresult.m_82450_();
                this.movementTeleportArcSteps = j + 1;
                Vec3 vec36 = vec34.m_82546_(vec35).m_82541_();
                Vec3 vec37 = new Vec3(-vec36.f_82479_ * 0.02, -vec36.f_82480_ * 0.02, -vec36.f_82481_ * 0.02);
                this.checkAndSetTeleportDestination(mc, player, vec3, blockhitresult, vec37);
                Vec3 vec38 = mc.f_91074_.m_20182_().m_82546_(this.movementTeleportDestination);
                double d0 = vec38.f_82480_;
                this.movementTeleportDistance = vec38.m_82553_();
                double d1 = Math.sqrt(vec38.f_82479_ * vec38.f_82479_ + vec38.f_82481_ * vec38.f_82481_);
                boolean bl = flag1 = !mc.f_91074_.m_6144_() || !(d0 > 0.2);
                if (!mc.f_91074_.m_150110_().f_35936_ && ClientNetworking.isLimitedSurvivalTeleport()) {
                    if (ClientNetworking.getTeleportDownLimit() > 0 && d0 > (double)ClientNetworking.getTeleportDownLimit() + 0.2) {
                        flag1 = false;
                    } else if (ClientNetworking.getTeleportUpLimit() > 0 && -d0 > (double)ClientNetworking.getTeleportUpLimit() * (double)((PlayerExtension)player).vivecraft$getMuhJumpFactor() + 0.2) {
                        flag1 = false;
                    } else if (ClientNetworking.getTeleportHorizLimit() > 0 && d1 > (double)ClientNetworking.getTeleportHorizLimit() * (double)((PlayerExtension)player).vivecraft$getMuhSpeedFactor() + 0.2) {
                        flag1 = false;
                    }
                }
                if (flag1) break;
                this.movementTeleportDestination = new Vec3(0.0, 0.0, 0.0);
                this.movementTeleportDistance = 0.0;
                break;
            }
            vec34 = new Vec3(vec35.f_82479_, vec35.f_82480_, vec35.f_82481_);
            this.movementTeleportArc[j] = new Vec3(vec35.f_82479_, vec35.f_82480_, vec35.f_82481_);
            this.movementTeleportArcSteps = j + 1;
            vec33 = vec33.m_82549_(vec32);
        }
    }

    private void doTeleportCallback() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        dataholder.swingTracker.disableSwing = 3;
        if (ClientNetworking.isLimitedSurvivalTeleport()) {
            minecraft.f_91074_.m_36399_((float)(this.movementTeleportDistance / 16.0 * (double)1.2f));
            if (minecraft.f_91072_.m_105289_() && this.vrMovementStyle.arcAiming) {
                this.teleportEnergy = (float)((double)this.teleportEnergy - this.movementTeleportDistance * 4.0);
            }
        }
        minecraft.f_91074_.f_19789_ = 0.0f;
        ((PlayerExtension)minecraft.f_91074_).vivecraft$setMovementTeleportTimer(-1);
    }

    private boolean checkAndSetTeleportDestination(Minecraft mc, LocalPlayer player, Vec3 start, BlockHitResult collision, Vec3 reverseEpsilon) {
        BlockPos blockpos = collision.m_82425_();
        BlockState blockstate = player.m_9236_().m_8055_(blockpos);
        if (!mc.f_91073_.m_6425_(blockpos).m_76178_()) {
            Vec3 vec3 = new Vec3(collision.m_82450_().f_82479_, (double)blockpos.m_123342_(), collision.m_82450_().f_82481_);
            Vec3 vec31 = vec3.m_82492_(player.m_20185_(), player.m_20191_().f_82289_, player.m_20189_());
            AABB aabb = player.m_20191_().m_82386_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            boolean flag = mc.f_91073_.m_45756_((Entity)player, aabb);
            if (!flag) {
                Vec3 vec32 = Vec3.m_82539_((Vec3i)blockpos);
                vec31 = vec32.m_82492_(player.m_20185_(), player.m_20191_().f_82289_, player.m_20189_());
                aabb = player.m_20191_().m_82386_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                flag = mc.f_91073_.m_45756_((Entity)player, aabb);
            }
            float f = 0.0f;
            if (this.dh.vrSettings.seated) {
                f = 0.5f;
            }
            if (flag) {
                this.movementTeleportDestination = new Vec3(aabb.m_82399_().f_82479_, aabb.f_82289_ + (double)f, aabb.m_82399_().f_82481_);
                this.movementTeleportDestinationSideHit = collision.m_82434_();
                return true;
            }
        } else if (collision.m_82434_() != Direction.UP) {
            if (blockstate.m_60734_() instanceof LadderBlock || blockstate.m_60734_() instanceof VineBlock || blockstate.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE)) {
                Vec3 vec36 = new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5);
                Block block = mc.f_91073_.m_8055_(blockpos.m_7495_()).m_60734_();
                if (block == blockstate.m_60734_()) {
                    vec36 = vec36.m_82520_(0.0, -1.0, 0.0);
                }
                this.movementTeleportDestination = vec36.m_82490_(1.0);
                this.movementTeleportDestinationSideHit = collision.m_82434_();
                return true;
            }
            if (!mc.f_91074_.m_150110_().f_35936_ && ClientNetworking.isLimitedSurvivalTeleport()) {
                return false;
            }
        }
        double d1 = 0.0;
        BlockPos blockpos1 = collision.m_82425_().m_7495_();
        for (int i = 0; i < 2; ++i) {
            boolean flag1;
            blockstate = player.m_9236_().m_8055_(blockpos1);
            if (blockstate.m_60812_((BlockGetter)mc.f_91073_, blockpos1).m_83281_()) {
                blockpos1 = blockpos1.m_7494_();
                continue;
            }
            double d2 = blockstate.m_60812_((BlockGetter)mc.f_91073_, blockpos1).m_83297_(Direction.Axis.Y);
            Vec3 vec33 = new Vec3(collision.m_82450_().f_82479_, (double)blockpos1.m_123342_() + d2, collision.m_82450_().f_82481_);
            Vec3 vec34 = vec33.m_82492_(player.m_20185_(), player.m_20191_().f_82289_, player.m_20189_());
            AABB aabb1 = player.m_20191_().m_82386_(vec34.f_82479_, vec34.f_82480_, vec34.f_82481_);
            double d0 = 0.0;
            if (blockstate.m_60734_() == Blocks.f_50135_ || blockstate.m_60734_() == Blocks.f_50719_) {
                d0 = 0.05;
            }
            boolean bl = flag1 = mc.f_91073_.m_45756_((Entity)player, aabb1) && !mc.f_91073_.m_45756_((Entity)player, aabb1.m_82377_(0.0, 0.125 + d0, 0.0));
            if (!flag1) {
                Vec3 vec35 = Vec3.m_82514_((Vec3i)blockpos1, (double)d2);
                vec34 = vec35.m_82492_(player.m_20185_(), player.m_20191_().f_82289_, player.m_20189_());
                aabb1 = player.m_20191_().m_82386_(vec34.f_82479_, vec34.f_82480_, vec34.f_82481_);
                boolean bl2 = flag1 = mc.f_91073_.m_45756_((Entity)player, aabb1) && !mc.f_91073_.m_45756_((Entity)player, aabb1.m_82377_(0.0, 0.125 + d0, 0.0));
            }
            if (flag1) {
                Vec3 vec37 = new Vec3(aabb1.m_82399_().f_82479_, (double)blockpos1.m_123342_() + d2, aabb1.m_82399_().f_82481_);
                this.movementTeleportDestination = vec37.m_82490_(1.0);
                return true;
            }
            blockpos1 = blockpos1.m_7494_();
        }
        return false;
    }

    public Vec3 getInterpolatedArcPosition(float progress) {
        if (this.movementTeleportArcSteps != 1 && !(progress <= 0.0f)) {
            if (progress >= 1.0f) {
                return new Vec3(this.movementTeleportArc[this.movementTeleportArcSteps - 1].f_82479_, this.movementTeleportArc[this.movementTeleportArcSteps - 1].f_82480_, this.movementTeleportArc[this.movementTeleportArcSteps - 1].f_82481_);
            }
            float f = progress * (float)(this.movementTeleportArcSteps - 1);
            int i = (int)Math.floor(f);
            double d0 = this.movementTeleportArc[i + 1].f_82479_ - this.movementTeleportArc[i].f_82479_;
            double d1 = this.movementTeleportArc[i + 1].f_82480_ - this.movementTeleportArc[i].f_82480_;
            double d2 = this.movementTeleportArc[i + 1].f_82481_ - this.movementTeleportArc[i].f_82481_;
            float f1 = f - (float)i;
            return new Vec3(this.movementTeleportArc[i].f_82479_ + d0 * (double)f1, this.movementTeleportArc[i].f_82480_ + d1 * (double)f1, this.movementTeleportArc[i].f_82481_ + d2 * (double)f1);
        }
        return new Vec3(this.movementTeleportArc[0].f_82479_, this.movementTeleportArc[0].f_82480_, this.movementTeleportArc[0].f_82481_);
    }
}

