/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client_vr.BlockTags;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.ItemTags;
import org.vivecraft.client_vr.Vec3History;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.bettercombat.BetterCombatHelper;
import org.vivecraft.mod_compat_vr.epicfight.EpicFightHelper;

public class SwingTracker
extends Tracker {
    private final Vec3[] lastWeaponEndAir = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
    private final boolean[] lastWeaponSolid = new boolean[2];
    public Vec3[] miningPoint = new Vec3[2];
    public Vec3[] attackingPoint = new Vec3[2];
    public Vec3History[] tipHistory = new Vec3History[]{new Vec3History(), new Vec3History()};
    public boolean[] canact = new boolean[2];
    public int disableSwing = 3;
    Vec3 forward = new Vec3(0.0, 0.0, -1.0);
    double speedthresh = 3.0;

    public SwingTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (this.disableSwing > 0) {
            --this.disableSwing;
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (p == null) {
            return false;
        }
        if (!p.m_6084_()) {
            return false;
        }
        if (p.m_5803_()) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (minecraft.f_91080_ != null) {
            return false;
        }
        if (dataholder.vrSettings.weaponCollision == VRSettings.WeaponCollision.OFF) {
            return false;
        }
        if (dataholder.vrSettings.weaponCollision == VRSettings.WeaponCollision.AUTO) {
            return !p.m_7500_();
        }
        if (dataholder.vrSettings.seated) {
            return false;
        }
        if (dataholder.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.RUN_IN_PLACE && p.f_20902_ > 0.0f) {
            return false;
        }
        if (p.m_21254_()) {
            return false;
        }
        return !dataholder.jumpTracker.isjumping();
    }

    public static boolean isTool(Item item) {
        return item instanceof DiggerItem || item instanceof ArrowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem || item instanceof ShearsItem || item == Items.f_42500_ || item == Items.f_42585_ || item == Items.f_41911_ || item == Items.f_42000_ || item == Items.f_41978_ || item == Items.f_42398_ || item == Items.f_42751_ || item instanceof FlintAndSteelItem || item instanceof BrushItem || item.m_7968_().m_204117_(ItemTags.VIVECRAFT_TOOLS);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        this.speedthresh = 3.0;
        if (player.m_7500_()) {
            this.speedthresh *= 1.5;
        }
        this.mc.m_91307_().m_6180_("updateSwingAttack");
        for (int c = 0; c < 2; ++c) {
            BlockHitResult blockhitresult;
            float entityReachAdd;
            float weaponLength;
            if (this.dh.climbTracker.isGrabbingLadder(c)) continue;
            Vec3 handPos = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            Vec3 handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(this.forward);
            ItemStack itemstack = player.m_21120_(c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            Item item = itemstack.m_41720_();
            boolean isTool = false;
            boolean isSword = false;
            if (!(item instanceof SwordItem || itemstack.m_204117_(ItemTags.VIVECRAFT_SWORDS) || item instanceof TridentItem || itemstack.m_204117_(ItemTags.VIVECRAFT_SPEARS))) {
                if (SwingTracker.isTool(item)) {
                    isTool = true;
                }
            } else {
                isSword = true;
                isTool = true;
            }
            double playerEntityReach = Xplat.getItemEntityReach(3.0, itemstack, c == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            if (Xplat.isModLoaded("bettercombat")) {
                playerEntityReach = BetterCombatHelper.getItemRange(playerEntityReach, itemstack);
            }
            playerEntityReach = Math.min(playerEntityReach, 6.0) - 0.5;
            if (isSword) {
                weaponLength = 0.6f;
                entityReachAdd = (float)playerEntityReach - weaponLength;
            } else if (isTool) {
                weaponLength = 0.35f;
                entityReachAdd = (float)playerEntityReach * 0.62f - weaponLength;
            } else if (!itemstack.m_41619_()) {
                weaponLength = 0.1f;
                entityReachAdd = (float)playerEntityReach * 0.16f - weaponLength;
            } else {
                weaponLength = 0.0f;
                entityReachAdd = 0.3f;
            }
            this.miningPoint[c] = handPos.m_82549_(handDirection.m_82490_((double)(weaponLength *= this.dh.vrPlayer.vrdata_world_pre.worldScale)));
            Vec3 tip = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPosition().m_82549_(this.dh.vrPlayer.vrdata_room_pre.getHand(c).getCustomVector(this.forward).m_82490_(0.3));
            this.tipHistory[c].add(tip);
            float speed = (float)this.tipHistory[c].averageSpeed(0.33);
            boolean inAnEntity = false;
            this.canact[c] = (double)speed > this.speedthresh && !this.lastWeaponSolid[c];
            boolean entityAct = this.canact[c];
            if (entityAct && (blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition(), handPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_))).m_6662_() != HitResult.Type.MISS) {
                entityAct = false;
            }
            this.attackingPoint[c] = this.constrain(handPos, this.miningPoint[c]);
            Vec3 weaponTip = handPos.m_82549_(handDirection.m_82490_((double)(weaponLength + entityReachAdd)));
            weaponTip = this.constrain(handPos, weaponTip);
            AABB weaponBB = new AABB(handPos, this.attackingPoint[c]);
            AABB weaponTipBB = new AABB(handPos, weaponTip);
            List mobs = this.mc.f_91073_.m_45933_((Entity)this.mc.f_91074_, weaponTipBB);
            mobs.removeIf(e -> e instanceof Player);
            List players = this.mc.f_91073_.m_45933_((Entity)this.mc.f_91074_, weaponBB);
            players.removeIf(e -> !(e instanceof Player));
            mobs.addAll(players);
            for (Entity entity : mobs) {
                if (!entity.m_6087_() || entity == this.mc.m_91288_().m_20202_()) continue;
                if (entityAct) {
                    if (!EpicFightHelper.isLoaded() || !EpicFightHelper.attack()) {
                        this.mc.f_91072_.m_105223_((Player)player, entity);
                    } else {
                        entityAct = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 1000);
                    this.lastWeaponSolid[c] = true;
                }
                inAnEntity = true;
            }
            if (this.dh.climbTracker.isClimbeyClimb() && (!isTool || c == 0 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) || c == 1 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT))) continue;
            BlockPos blockpos = BlockPos.m_274446_((Position)this.miningPoint[c]);
            BlockState blockstate = this.mc.f_91073_.m_8055_(blockpos);
            boolean mineableByItem = this.dh.vrSettings.swordBlockCollision && (itemstack.m_41735_(blockstate) || blockstate.m_60625_((Player)player, (BlockGetter)player.m_9236_(), blockpos) == 1.0f);
            this.canact[c] = this.canact[c] && (!isSword || mineableByItem) && !inAnEntity;
            BlockHitResult blockHit = this.mc.f_91073_.m_45547_(new ClipContext(this.lastWeaponEndAir[c], this.miningPoint[c], ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_));
            if (!blockstate.m_60795_() && blockHit.m_6662_() == HitResult.Type.BLOCK && this.lastWeaponEndAir[c].m_82553_() != 0.0) {
                boolean protectedBlock;
                this.lastWeaponSolid[c] = true;
                boolean sameBlock = blockHit.m_82425_().equals((Object)blockpos);
                boolean bl = protectedBlock = this.dh.vrSettings.realisticClimbEnabled && (blockstate.m_60734_() instanceof LadderBlock || blockstate.m_60734_() instanceof VineBlock || blockstate.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE));
                if (blockHit.m_6662_() != HitResult.Type.BLOCK || !sameBlock || !this.canact[c] || protectedBlock) continue;
                int totalHits = 3;
                if ((item instanceof HoeItem || itemstack.m_204117_(ItemTags.VIVECRAFT_HOES) || itemstack.m_204117_(ItemTags.VIVECRAFT_SCYTHES)) && (blockstate.m_60734_() instanceof CropBlock || blockstate.m_60734_() instanceof StemBlock || blockstate.m_60734_() instanceof AttachedStemBlock || blockstate.m_204336_(BlockTags.VIVECRAFT_CROPS) || item.m_6225_(new UseOnContext((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit)).m_19080_())) {
                    boolean useSuccessful = this.mc.f_91072_.m_233732_(player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit).m_19080_();
                    if (itemstack.m_204117_(ItemTags.VIVECRAFT_SCYTHES) && !useSuccessful) {
                        this.mc.f_91072_.m_233721_((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    }
                } else if (item instanceof BrushItem) {
                    ((BrushItem)item).m_278154_(player.m_9236_(), blockHit, blockstate, player.m_20252_(0.0f), c == 0 ? player.m_5737_() : player.m_5737_().m_20828_());
                    player.m_9236_().m_247517_((Player)player, blockHit.m_82425_(), blockstate.m_60734_() instanceof BrushableBlock ? ((BrushableBlock)blockstate.m_60734_()).m_276856_() : SoundEvents.f_276624_, SoundSource.BLOCKS);
                    this.mc.f_91072_.m_233732_(player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit);
                } else if (blockstate.m_60734_() instanceof NoteBlock || blockstate.m_204336_(BlockTags.VIVECRAFT_MUSIC_BLOCKS)) {
                    this.mc.f_91072_.m_105283_(blockHit.m_82425_(), blockHit.m_82434_());
                } else {
                    totalHits = (int)((double)totalHits + Math.min((double)speed - this.speedthresh, 4.0));
                    this.mc.f_91072_.m_105269_(blockHit.m_82425_(), blockHit.m_82434_());
                    if (this.getIsHittingBlock()) {
                        for (int hit = 0; hit < totalHits; ++hit) {
                            if (this.mc.f_91072_.m_105283_(blockHit.m_82425_(), blockHit.m_82434_())) {
                                this.mc.f_91061_.m_107367_(blockHit.m_82425_(), blockHit.m_82434_());
                            }
                            this.clearBlockHitDelay();
                            if (!this.getIsHittingBlock()) break;
                        }
                        Minecraft.m_91087_().f_91072_.f_105195_ = 0;
                    }
                    this.dh.vrPlayer.blockDust(blockHit.m_82450_().f_82479_, blockHit.m_82450_().f_82480_, blockHit.m_82450_().f_82481_, 3 * totalHits, blockpos, blockstate, 0.6f, 1.0f);
                }
                this.dh.vr.triggerHapticPulse(c, 250 * totalHits);
                continue;
            }
            this.lastWeaponEndAir[c] = this.miningPoint[c];
            this.lastWeaponSolid[c] = false;
        }
        this.mc.m_91307_().m_7238_();
    }

    private boolean getIsHittingBlock() {
        return Minecraft.m_91087_().f_91072_.m_105296_();
    }

    private void clearBlockHitDelay() {
    }

    public Vec3 constrain(Vec3 start, Vec3 end) {
        BlockHitResult blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_));
        return blockhitresult.m_6662_() == HitResult.Type.BLOCK ? blockhitresult.m_82450_() : end;
    }

    public static float getItemFade(LocalPlayer p, ItemStack is) {
        float fade = p.m_36403_(0.0f) * 0.75f + 0.25f;
        if (p.m_6144_()) {
            fade = 0.75f;
        }
        boolean[] aboolean = ClientDataHolderVR.getInstance().swingTracker.lastWeaponSolid;
        Minecraft.m_91087_().m_91291_();
        if (aboolean[ClientDataHolderVR.ismainhand ? 0 : 1]) {
            fade -= 0.25f;
        }
        if (is != ItemStack.f_41583_) {
            if (p.m_21254_() && p.m_21211_() != is) {
                fade -= 0.25f;
            }
            if (is.m_41720_() == Items.f_42740_ && !p.m_21254_()) {
                fade -= 0.25f;
            }
        }
        if ((double)fade < 0.1) {
            fade = 0.1f;
        }
        if (fade > 1.0f) {
            fade = 1.0f;
        }
        return fade;
    }
}

