/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.VRSettings;

public class RunTracker
extends Tracker {
    private double direction = 0.0;
    private double speed = 0.0;
    private Vec3 movedir;

    public RunTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (ClientDataHolderVR.getInstance().vrPlayer.getFreeMove() && !ClientDataHolderVR.getInstance().vrSettings.seated) {
            if (ClientDataHolderVR.getInstance().vrSettings.vrFreeMoveMode != VRSettings.FreeMove.RUN_IN_PLACE) {
                return false;
            }
            if (p != null && p.m_6084_()) {
                if (this.mc.f_91072_ == null) {
                    return false;
                }
                if (p.m_20096_() || !p.m_20069_() && !p.m_20077_()) {
                    if (p.m_6147_()) {
                        return false;
                    }
                    return !ClientDataHolderVR.getInstance().bowTracker.isNotched();
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public double getYaw() {
        return this.direction;
    }

    public double getSpeed() {
        return this.speed;
    }

    @Override
    public void reset(LocalPlayer player) {
        this.speed = 0.0;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        Vec3 vec3 = this.dh.vrPlayer.vrdata_world_pre.getController(0).getPosition();
        Vec3 vec31 = this.dh.vrPlayer.vrdata_world_pre.getController(1).getPosition();
        double d0 = this.dh.vr.controllerHistory[0].averageSpeed(0.33);
        double d1 = this.dh.vr.controllerHistory[1].averageSpeed(0.33);
        if (this.speed > 0.0) {
            if (d0 < 0.1 && d1 < 0.1) {
                this.speed = 0.0;
                return;
            }
        } else if (d0 < 0.6 && d1 < 0.6) {
            this.speed = 0.0;
            return;
        }
        if (Math.abs(d0 - d1) > 0.5) {
            this.speed = 0.0;
        } else {
            Vec3 vec32 = this.dh.vrPlayer.vrdata_world_pre.getController(0).getDirection().m_82549_(this.dh.vrPlayer.vrdata_world_pre.getController(1).getDirection()).m_82490_(0.5);
            this.direction = (float)Math.toDegrees(Math.atan2(-vec32.f_82479_, vec32.f_82481_));
            double d2 = (d0 + d1) / 2.0;
            this.speed = d2 * 1.0 * 1.3;
            if (this.speed > 0.1) {
                this.speed = 1.0;
            }
            if (this.speed > 1.0) {
                this.speed = 1.3f;
            }
        }
    }
}

