/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.math.Quaternion;

public class HorseTracker
extends Tracker {
    double boostTrigger = 1.4;
    double pullTrigger = 0.8;
    int speedLevel = 0;
    int maxSpeedLevel = 3;
    int coolDownMillis = 500;
    long lastBoostMillis = -1L;
    double turnspeed = 6.0;
    double bodyturnspeed = 0.2;
    double baseSpeed = 0.2;
    Horse horse = null;
    ModelInfo info = new ModelInfo();

    public HorseTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        return false;
    }

    @Override
    public void reset(LocalPlayer player) {
        super.reset(player);
        if (this.horse != null) {
            this.horse.m_21557_(false);
        }
    }

    @Override
    public void doProcess(LocalPlayer player) {
        this.horse = (Horse)player.m_20202_();
        this.horse.m_21557_(true);
        float f = (this.horse.m_146908_() + 360.0f) % 360.0f;
        float f1 = (this.horse.f_20883_ + 360.0f) % 360.0f;
        Vec3 vec3 = this.dh.vr.controllerHistory[1].netMovement(0.1).m_82490_(10.0);
        Vec3 vec31 = this.dh.vr.controllerHistory[0].netMovement(0.1).m_82490_(10.0);
        double d0 = Math.min(-vec3.f_82480_, -vec31.f_82480_);
        if (d0 > this.boostTrigger) {
            this.boost();
        }
        Quaternion quaternion = new Quaternion(0.0f, -this.horse.f_20883_, 0.0f);
        Vec3 vec32 = quaternion.multiply(new Vec3(0.0, 0.0, -1.0));
        Vec3 vec33 = quaternion.multiply(new Vec3(1.0, 0.0, 0.0));
        Vec3 vec34 = quaternion.multiply(new Vec3(-1.0, 0.0, 0.0));
        Quaternion quaternion1 = new Quaternion(0.0f, VRSettings.inst.worldRotation, 0.0f);
        Vec3 vec35 = VRPlayer.get().roomOrigin.m_82549_(quaternion1.multiply(this.dh.vr.controllerHistory[1].latest()));
        Vec3 vec36 = VRPlayer.get().roomOrigin.m_82549_(quaternion1.multiply(this.dh.vr.controllerHistory[0].latest()));
        double d1 = vec35.m_82546_(this.info.leftReinPos).m_82526_(vec32) + vec35.m_82546_(this.info.leftReinPos).m_82526_(vec33);
        double d2 = vec36.m_82546_(this.info.rightReinPos).m_82526_(vec32) + vec36.m_82546_(this.info.rightReinPos).m_82526_(vec34);
        if (this.speedLevel < 0) {
            this.speedLevel = 0;
        }
        if (d1 > this.pullTrigger + 0.3 && d2 > this.pullTrigger + 0.3 && Math.abs(d2 - d1) < 0.1) {
            if (this.speedLevel <= 0 && System.currentTimeMillis() > this.lastBoostMillis + (long)this.coolDownMillis) {
                this.speedLevel = -1;
            } else {
                this.doBreak();
            }
        } else {
            double d3 = 0.0;
            double d4 = 0.0;
            if (d1 > this.pullTrigger) {
                d3 = d1 - this.pullTrigger;
            }
            if (d2 > this.pullTrigger) {
                d4 = d2 - this.pullTrigger;
            }
            this.horse.m_146922_((float)((double)f + (d4 - d3) * this.turnspeed));
        }
        this.horse.f_20883_ = (float)Utils.lerpMod(f1, f, this.bodyturnspeed, 360.0);
        this.horse.f_20885_ = f;
        Vec3 vec37 = quaternion.multiply(new Vec3(0.0, 0.0, (double)this.speedLevel * this.baseSpeed));
        this.horse.m_20334_(vec37.f_82479_, this.horse.m_20184_().f_82480_, vec37.f_82481_);
    }

    boolean boost() {
        if (this.speedLevel >= this.maxSpeedLevel) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + (long)this.coolDownMillis) {
            return false;
        }
        ++this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    boolean doBreak() {
        if (this.speedLevel <= 0) {
            return false;
        }
        if (System.currentTimeMillis() < this.lastBoostMillis + (long)this.coolDownMillis) {
            return false;
        }
        System.out.println("Breaking");
        --this.speedLevel;
        this.lastBoostMillis = System.currentTimeMillis();
        return true;
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    public class ModelInfo {
        public Vec3 leftReinPos = Vec3.f_82478_;
        public Vec3 rightReinPos = Vec3.f_82478_;
    }
}

