/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;

public class EatingTracker
extends Tracker {
    float mouthtoEyeDistance = 0.0f;
    float threshold = 0.25f;
    public boolean[] eating = new boolean[2];
    int eattime = 2100;
    long eatStart;
    private final Random r = new Random();

    public EatingTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    public boolean isEating() {
        return this.eating[0] || this.eating[1];
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        UseAnim useanim;
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return false;
        }
        if (p == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!p.m_6084_()) {
            return false;
        }
        if (p.m_5803_()) {
            return false;
        }
        if (p.m_21205_() != null && ((useanim = p.m_21205_().m_41780_()) == UseAnim.EAT || useanim == UseAnim.DRINK || useanim == UseAnim.TOOT_HORN)) {
            return true;
        }
        if (p.m_21206_() != null) {
            UseAnim useanim1 = p.m_21206_().m_41780_();
            return useanim1 == UseAnim.EAT || useanim1 == UseAnim.DRINK || useanim1 == UseAnim.TOOT_HORN;
        }
        return false;
    }

    @Override
    public void reset(LocalPlayer player) {
        this.eating[0] = false;
        this.eating[1] = false;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        VRPlayer vrplayer = this.dh.vrPlayer;
        Vec3 hmdPos = vrplayer.vrdata_room_pre.hmd.getPosition();
        Vec3 mouthPos = vrplayer.vrdata_room_pre.getController(0).getCustomVector(new Vec3(0.0, (double)(-this.mouthtoEyeDistance), 0.0)).m_82549_(hmdPos);
        for (int c = 0; c < 2; ++c) {
            Vec3 controllerPos = this.dh.vr.controllerHistory[c].averagePosition(0.333).m_82549_(vrplayer.vrdata_room_pre.getController(c).getCustomVector(new Vec3(0.0, 0.0, -0.1)));
            if (mouthPos.m_82554_(controllerPos = controllerPos.m_82549_(this.dh.vrPlayer.vrdata_room_pre.getController(c).getDirection().m_82490_(0.1))) < (double)this.threshold) {
                long k;
                ItemStack itemstack;
                ItemStack itemStack = itemstack = c == 0 ? player.m_21205_() : player.m_21206_();
                if (itemstack == ItemStack.f_41583_) continue;
                int crunchiness = 0;
                if (itemstack.m_41780_() == UseAnim.DRINK) {
                    Vec3 vec3 = new Vec3(0.0, 1.0, 0.0);
                    if (vrplayer.vrdata_room_pre.getController((int)c).getCustomVector((Vec3)vec3).f_82480_ > 0.0) {
                        continue;
                    }
                } else if (itemstack.m_41780_() == UseAnim.EAT) {
                    crunchiness = 2;
                } else {
                    if (itemstack.m_41780_() != UseAnim.TOOT_HORN) continue;
                    crunchiness = 1;
                }
                if (!this.eating[c] && this.mc.f_91072_.m_233721_((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND).m_19077_()) {
                    this.mc.f_91063_.f_109055_.m_109320_(c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    this.eating[c] = true;
                    this.eatStart = Util.m_137550_();
                }
                if (this.eating[c] && (k = (long)player.m_21212_()) > 0L && k % 5L <= (long)crunchiness) {
                    this.dh.vr.triggerHapticPulse(c, 700);
                }
                if (Util.m_137550_() - this.eatStart <= (long)this.eattime) continue;
                this.eating[c] = false;
                continue;
            }
            this.eating[c] = false;
        }
    }
}

