/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.ItemTags;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.utils.math.Vector3;
import org.vivecraft.mod_compat_vr.pehkui.PehkuiHelper;

public class BowTracker
extends Tracker {
    private double lastcontrollersDist;
    private double lastcontrollersDot;
    private double controllersDist;
    private double controllersDot;
    private double currentDraw;
    private double lastDraw;
    public boolean isDrawing;
    private boolean pressed;
    private boolean lastpressed;
    private boolean canDraw;
    private boolean lastcanDraw;
    public long startDrawTime;
    private final double notchDotThreshold = 20.0;
    private double maxDraw;
    private final long maxDrawMillis = 1100L;
    private Vec3 aim;
    float tsNotch = 0.0f;
    int hapcounter = 0;
    int lasthapStep = 0;

    public BowTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    public Vec3 getAimVector() {
        return this.aim;
    }

    public float getDrawPercent() {
        return (float)(this.currentDraw / this.maxDraw);
    }

    public boolean isNotched() {
        return this.canDraw || this.isDrawing;
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack == ItemStack.f_41583_) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.OFF) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.VANILLA) {
            return itemStack.m_41720_() == Items.f_42411_;
        }
        return itemStack.m_41720_().m_6164_(itemStack) == UseAnim.BOW && !itemStack.m_204117_(ItemTags.VIVECRAFT_BOW_EXCLUSION);
    }

    public static boolean isHoldingBow(LivingEntity e, InteractionHand hand) {
        return !ClientDataHolderVR.getInstance().vrSettings.seated && BowTracker.isBow(e.m_21120_(hand));
    }

    public static boolean isHoldingBowEither(LivingEntity e) {
        return BowTracker.isHoldingBow(e, InteractionHand.MAIN_HAND) || BowTracker.isHoldingBow(e, InteractionHand.OFF_HAND);
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (p == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!p.m_6084_()) {
            return false;
        }
        if (p.m_5803_()) {
            return false;
        }
        return BowTracker.isHoldingBow((LivingEntity)p, InteractionHand.MAIN_HAND) || BowTracker.isHoldingBow((LivingEntity)p, InteractionHand.OFF_HAND);
    }

    public boolean isCharged() {
        return Util.m_137550_() - this.startDrawTime >= this.maxDrawMillis;
    }

    @Override
    public void reset(LocalPlayer player) {
        this.isDrawing = false;
        this.canDraw = false;
    }

    @Override
    public Tracker.EntryPoint getEntryPoint() {
        return Tracker.EntryPoint.SPECIAL_ITEMS;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        VRData vrdata = this.dh.vrPlayer.vrdata_world_render;
        if (vrdata == null) {
            vrdata = this.dh.vrPlayer.vrdata_world_pre;
        }
        VRPlayer vrplayer = this.dh.vrPlayer;
        if (this.dh.vrSettings.seated) {
            this.aim = vrdata.getController(0).getCustomVector(new Vec3(0.0, 0.0, 1.0));
        } else {
            this.lastcontrollersDist = this.controllersDist;
            this.lastcontrollersDot = this.controllersDot;
            this.lastpressed = this.pressed;
            this.lastDraw = this.currentDraw;
            this.lastcanDraw = this.canDraw;
            this.maxDraw = (double)this.mc.f_91074_.m_20206_() * 0.22;
            if (Xplat.isModLoaded("pehkui")) {
                this.maxDraw /= (double)PehkuiHelper.getPlayerBbScale((Entity)player, this.mc.m_91296_());
            }
            Vec3 vec3 = vrdata.getController(0).getPosition();
            Vec3 vec31 = vrdata.getController(1).getPosition();
            this.controllersDist = vec31.m_82554_(vec3);
            Vec3 vec32 = new Vec3(0.0, 1.0 * (double)vrdata.worldScale, 0.0);
            Vec3 vec33 = vrdata.getHand(1).getCustomVector(vec32).m_82490_(this.maxDraw * 0.5).m_82549_(vec31);
            double d0 = vec3.m_82554_(vec33);
            this.aim = vec3.m_82546_(vec31).m_82541_();
            Vec3 vec34 = vrdata.getController(0).getCustomVector(new Vec3(0.0, 0.0, -1.0));
            Vector3 vector3 = new Vector3((float)vec34.f_82479_, (float)vec34.f_82480_, (float)vec34.f_82481_);
            Vec3 vec35 = vrdata.getHand(1).getCustomVector(new Vec3(0.0, -1.0, 0.0));
            Vector3 vector31 = new Vector3((float)vec35.f_82479_, (float)vec35.f_82480_, (float)vec35.f_82481_);
            this.controllersDot = 57.29577951308232 * Math.acos(vector31.dot(vector3));
            this.pressed = VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT);
            float f = 0.15f * vrdata.worldScale;
            boolean flag = BowTracker.isHoldingBow((LivingEntity)player, InteractionHand.MAIN_HAND);
            InteractionHand interactionhand = flag ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            ItemStack itemstack = ItemStack.f_41583_;
            ItemStack itemstack1 = ItemStack.f_41583_;
            if (flag) {
                itemstack1 = player.m_21205_();
                itemstack = player.m_6298_(itemstack1);
            } else {
                if (player.m_21205_().m_204117_(net.minecraft.tags.ItemTags.f_13161_)) {
                    itemstack = player.m_21205_();
                }
                itemstack1 = player.m_21206_();
            }
            int i = itemstack1.m_41779_();
            int j = itemstack1.m_41779_() - 15;
            int k = 0;
            if (itemstack != ItemStack.f_41583_ && d0 <= (double)f && this.controllersDot <= 20.0) {
                if (!this.canDraw) {
                    this.startDrawTime = Util.m_137550_();
                }
                this.canDraw = true;
                this.tsNotch = Util.m_137550_();
                if (!this.isDrawing) {
                    ((PlayerExtension)player).vivecraft$setItemInUseClient(itemstack1, interactionhand);
                    ((PlayerExtension)player).vivecraft$setItemInUseCountClient(i);
                }
            } else if (!this.isDrawing && (float)Util.m_137550_() - this.tsNotch > 500.0f) {
                this.canDraw = false;
                ((PlayerExtension)player).vivecraft$setItemInUseClient(ItemStack.f_41583_, interactionhand);
            }
            if (!this.isDrawing && this.canDraw && this.pressed && !this.lastpressed) {
                this.isDrawing = true;
                this.mc.f_91072_.m_233721_((Player)player, interactionhand);
            }
            if (this.isDrawing && !this.pressed && this.lastpressed && (double)this.getDrawPercent() > 0.0) {
                this.dh.vr.triggerHapticPulse(0, 500);
                this.dh.vr.triggerHapticPulse(1, 3000);
                ServerboundCustomPayloadPacket serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.DRAW, ByteBuffer.allocate(4).putFloat(this.getDrawPercent()).array());
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)serverboundcustompayloadpacket);
                this.mc.f_91072_.m_105277_((Player)player);
                serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.DRAW, ByteBuffer.allocate(4).putFloat(0.0f).array());
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)serverboundcustompayloadpacket);
                this.isDrawing = false;
            }
            if (!this.pressed) {
                this.isDrawing = false;
            }
            if (!this.isDrawing && this.canDraw && !this.lastcanDraw) {
                this.dh.vr.triggerHapticPulse(1, 800);
                this.dh.vr.triggerHapticPulse(0, 800);
            }
            if (this.isDrawing) {
                this.currentDraw = (this.controllersDist - (double)f) / (double)vrdata.worldScale;
                if (this.currentDraw > this.maxDraw) {
                    this.currentDraw = this.maxDraw;
                }
                int j1 = 0;
                if (this.getDrawPercent() > 0.0f) {
                    j1 = (int)(this.getDrawPercent() * 500.0f) + 700;
                }
                float f2 = itemstack1.m_41779_();
                float f3 = this.getDrawPercent();
                Objects.requireNonNull(this);
                int l = (int)(f2 - f3 * 1100.0f);
                ((PlayerExtension)player).vivecraft$setItemInUseClient(itemstack1, interactionhand);
                double d1 = this.getDrawPercent();
                if (d1 >= 1.0) {
                    ((PlayerExtension)player).vivecraft$setItemInUseCountClient(k);
                } else if (d1 > 0.4) {
                    ((PlayerExtension)player).vivecraft$setItemInUseCountClient(j);
                } else {
                    ((PlayerExtension)player).vivecraft$setItemInUseCountClient(i);
                }
                int i1 = (int)(d1 * 4.0 * 4.0 * 3.0);
                if (i1 % 2 == 0 && this.lasthapStep != i1) {
                    this.dh.vr.triggerHapticPulse(0, j1);
                    if (d1 == 1.0) {
                        this.dh.vr.triggerHapticPulse(1, j1);
                    }
                }
                if (this.isCharged() && this.hapcounter % 4 == 0) {
                    this.dh.vr.triggerHapticPulse(1, 200);
                }
                this.lasthapStep = i1;
                ++this.hapcounter;
            } else {
                this.hapcounter = 0;
                this.lasthapStep = 0;
            }
        }
    }
}

