/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.screenhandlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.HandedKeyBinding;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRUtil;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.math.Matrix4f;
import org.vivecraft.common.utils.math.Quaternion;
import org.vivecraft.common.utils.math.Vector3;

public class GuiHandler {
    public static Minecraft mc = Minecraft.m_91087_();
    public static ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    static boolean lastPressedLeftClick;
    static boolean lastPressedRightClick;
    static boolean lastPressedMiddleClick;
    static boolean lastPressedShift;
    static boolean lastPressedCtrl;
    static boolean lastPressedAlt;
    private static double controllerMouseX;
    private static double controllerMouseY;
    public static boolean controllerMouseValid;
    public static int controllerMouseTicks;
    public static boolean guiAppearOverBlockActive;
    public static float guiScale;
    public static float guiScaleApplied;
    public static Vec3 IPoint;
    public static Vec3 guiPos_room;
    public static Matrix4f guiRotation_room;
    public static float hudScale;
    public static Vec3 hudPos_room;
    public static Matrix4f hudRotation_room;
    public static final KeyMapping keyLeftClick;
    public static final KeyMapping keyRightClick;
    public static final KeyMapping keyMiddleClick;
    public static final KeyMapping keyShift;
    public static final KeyMapping keyCtrl;
    public static final KeyMapping keyAlt;
    public static final KeyMapping keyScrollUp;
    public static final KeyMapping keyScrollDown;
    public static final KeyMapping keyScrollAxis;
    public static final HandedKeyBinding keyKeyboardClick;
    public static final HandedKeyBinding keyKeyboardShift;
    public static RenderTarget guiFramebuffer;
    public static int guiWidth;
    public static int guiHeight;
    public static int guiScaleFactorMax;
    public static int guiScaleFactor;
    public static int scaledWidth;
    public static int scaledHeight;
    public static int scaledWidthMax;
    public static int scaledHeightMax;

    public static int calculateScale(int scaleIn, boolean forceUnicode, int framebufferWidth, int framebufferHeight) {
        int maxScale;
        int scale = 1;
        for (maxScale = 1; maxScale < framebufferWidth && maxScale < framebufferHeight && framebufferWidth / (maxScale + 1) >= 320 && framebufferHeight / (maxScale + 1) >= 240; ++maxScale) {
            if (scale >= scaleIn && scaleIn != 0) continue;
            ++scale;
        }
        if (forceUnicode) {
            if (scale % 2 != 0) {
                ++scale;
            }
            if (maxScale % 2 != 0) {
                ++maxScale;
            }
        }
        guiScaleFactorMax = maxScale;
        scaledWidth = Mth.m_14167_((float)((float)framebufferWidth / (float)scale));
        scaledWidthMax = Mth.m_14167_((float)((float)framebufferWidth / (float)maxScale));
        scaledHeight = Mth.m_14167_((float)((float)framebufferHeight / (float)scale));
        scaledHeightMax = Mth.m_14167_((float)((float)framebufferHeight / (float)maxScale));
        return scale;
    }

    public static boolean updateResolution() {
        int oldWidth = guiWidth;
        int oldHeight = guiHeight;
        int oldGuiScale = guiScaleFactor;
        guiWidth = GuiHandler.dh.vrSettings.doubleGUIResolution ? 2560 : 1280;
        guiHeight = GuiHandler.dh.vrSettings.doubleGUIResolution ? 1440 : 720;
        guiScaleFactor = GuiHandler.calculateScale(GuiHandler.dh.vrSettings.doubleGUIResolution ? GuiHandler.dh.vrSettings.guiScale : (int)Math.ceil((float)GuiHandler.dh.vrSettings.guiScale * 0.5f), false, guiWidth, guiHeight);
        if (oldWidth != guiWidth) {
            InputSimulator.setMousePos(GuiHandler.mc.f_91067_.m_91589_() * (double)((WindowExtension)mc.m_91268_()).vivecraft$getActualScreenWidth() / (double)oldWidth, GuiHandler.mc.f_91067_.m_91594_() * (double)((WindowExtension)mc.m_91268_()).vivecraft$getActualScreenHeight() / (double)oldHeight);
            controllerMouseX *= (double)guiWidth / (double)oldWidth;
            controllerMouseY *= (double)guiHeight / (double)oldHeight;
            return true;
        }
        return oldGuiScale != guiScaleFactor;
    }

    public static void processGui() {
        if (!(GuiHandler.mc.f_91080_ == null && GuiHandler.mc.f_91067_.m_91600_() || GuiHandler.dh.vrSettings.seated || guiRotation_room == null || !MCVR.get().isControllerTracking(0))) {
            Vec2 vec2 = GuiHandler.getTexCoordsForCursor(guiPos_room, guiRotation_room, GuiHandler.mc.f_91080_, guiScale, GuiHandler.dh.vrPlayer.vrdata_room_pre.getController(0));
            float f = vec2.f_82470_;
            float f1 = vec2.f_82471_;
            if (!(f < 0.0f || f1 < 0.0f || f > 1.0f || f1 > 1.0f)) {
                if (controllerMouseX == -1.0) {
                    controllerMouseX = (int)(f * (float)mc.m_91268_().m_85443_());
                    controllerMouseY = (int)(f1 * (float)mc.m_91268_().m_85444_());
                } else {
                    float f2 = (int)(f * (float)mc.m_91268_().m_85443_());
                    float f3 = (int)(f1 * (float)mc.m_91268_().m_85444_());
                    controllerMouseX = controllerMouseX * (double)0.7f + (double)(f2 * 0.3f);
                    controllerMouseY = controllerMouseY * (double)0.7f + (double)(f3 * 0.3f);
                }
            } else {
                controllerMouseX = -1.0;
                controllerMouseY = -1.0;
            }
            if (controllerMouseX >= 0.0 && controllerMouseX < (double)mc.m_91268_().m_85443_() && controllerMouseY >= 0.0 && controllerMouseY < (double)mc.m_91268_().m_85444_()) {
                double d1 = Math.min(Math.max((int)controllerMouseX, 0), mc.m_91268_().m_85443_());
                double d0 = Math.min(Math.max((int)controllerMouseY, 0), mc.m_91268_().m_85444_());
                boolean i = false;
                boolean j = false;
                if (MCVR.get().isControllerTracking(ControllerType.RIGHT)) {
                    InputSimulator.setMousePos(d1 * ((double)((WindowExtension)mc.m_91268_()).vivecraft$getActualScreenWidth() / (double)mc.m_91268_().m_85443_()), d0 * ((double)((WindowExtension)mc.m_91268_()).vivecraft$getActualScreenHeight() / (double)mc.m_91268_().m_85444_()));
                    controllerMouseValid = true;
                }
            } else {
                if (controllerMouseTicks == 0) {
                    controllerMouseValid = false;
                }
                if (controllerMouseTicks > 0) {
                    --controllerMouseTicks;
                }
            }
        }
    }

    public static Vec2 getTexCoordsForCursor(Vec3 guiPos_room, Matrix4f guiRotation_room, Screen screen, float guiScale, VRData.VRDevicePose controller) {
        Vec3 vec3 = controller.getPosition();
        Vector3 vector3 = new Vector3(vec3);
        Vec3 vec31 = controller.getDirection();
        Vector3 vector31 = new Vector3((float)vec31.f_82479_, (float)vec31.f_82480_, (float)vec31.f_82481_);
        Vector3 vector32 = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 vector33 = guiRotation_room.transform(vector32);
        Vector3 vector34 = guiRotation_room.transform(new Vector3(1.0f, 0.0f, 0.0f));
        Vector3 vector35 = guiRotation_room.transform(new Vector3(0.0f, 1.0f, 0.0f));
        float f = vector33.dot(vector31);
        if (Math.abs(f) > 1.0E-5f) {
            float f1 = 1.0f;
            float f2 = f1 * 0.5f;
            float f3 = 1.0f;
            float f4 = f3 * 0.5f;
            Vector3 vector36 = new Vector3();
            vector36.setX((float)guiPos_room.f_82479_);
            vector36.setY((float)guiPos_room.f_82480_);
            vector36.setZ((float)guiPos_room.f_82481_);
            Vector3 vector37 = vector36.subtract(vector35.divide(1.0f / f4)).subtract(vector34.divide(1.0f / f2));
            float f5 = -vector33.dot(vector3.subtract(vector37)) / f;
            if (f5 > 0.0f) {
                Vector3 vector38 = vector3.add(vector31.divide(1.0f / f5));
                Vector3 vector39 = vector38.subtract(vector37);
                float f6 = vector39.dot(vector34.divide(1.0f / f1));
                float f7 = vector39.dot(vector35.divide(1.0f / f1));
                float f8 = (float)mc.m_91268_().m_85446_() / (float)mc.m_91268_().m_85445_();
                f6 = (f6 - 0.5f) / 1.5f / guiScale + 0.5f;
                f7 = (f7 - 0.5f) / f8 / 1.5f / guiScale + 0.5f;
                f7 = 1.0f - f7;
                return new Vec2(f6, f7);
            }
        }
        return new Vec2(-1.0f, -1.0f);
    }

    public static void processBindingsGui() {
        boolean flag;
        boolean bl = flag = controllerMouseX >= 0.0 && controllerMouseX < (double)mc.m_91268_().m_85443_() && controllerMouseY >= 0.0 && controllerMouseY < (double)mc.m_91268_().m_85443_();
        if (keyLeftClick.m_90859_() && GuiHandler.mc.f_91080_ != null && flag) {
            InputSimulator.pressMouse(0);
            lastPressedLeftClick = true;
        }
        if (!keyLeftClick.m_90857_() && lastPressedLeftClick) {
            InputSimulator.releaseMouse(0);
            lastPressedLeftClick = false;
        }
        if (keyRightClick.m_90859_() && GuiHandler.mc.f_91080_ != null && flag) {
            InputSimulator.pressMouse(1);
            lastPressedRightClick = true;
        }
        if (!keyRightClick.m_90857_() && lastPressedRightClick) {
            InputSimulator.releaseMouse(1);
            lastPressedRightClick = false;
        }
        if (keyMiddleClick.m_90859_() && GuiHandler.mc.f_91080_ != null && flag) {
            InputSimulator.pressMouse(2);
            lastPressedMiddleClick = true;
        }
        if (!keyMiddleClick.m_90857_() && lastPressedMiddleClick) {
            InputSimulator.releaseMouse(2);
            lastPressedMiddleClick = false;
        }
        if (keyShift.m_90859_() && GuiHandler.mc.f_91080_ != null) {
            InputSimulator.pressKey(340);
            lastPressedShift = true;
        }
        if (!keyShift.m_90857_() && lastPressedShift) {
            InputSimulator.releaseKey(340);
            lastPressedShift = false;
        }
        if (keyCtrl.m_90859_() && GuiHandler.mc.f_91080_ != null) {
            InputSimulator.pressKey(341);
            lastPressedCtrl = true;
        }
        if (!keyCtrl.m_90857_() && lastPressedCtrl) {
            InputSimulator.releaseKey(341);
            lastPressedCtrl = false;
        }
        if (keyAlt.m_90859_() && GuiHandler.mc.f_91080_ != null) {
            InputSimulator.pressKey(342);
            lastPressedAlt = true;
        }
        if (!keyAlt.m_90857_() && lastPressedAlt) {
            InputSimulator.releaseKey(342);
            lastPressedAlt = false;
        }
        if (keyScrollUp.m_90859_() && GuiHandler.mc.f_91080_ != null) {
            InputSimulator.scrollMouse(0.0, 4.0);
        }
        if (keyScrollDown.m_90859_() && GuiHandler.mc.f_91080_ != null) {
            InputSimulator.scrollMouse(0.0, -4.0);
        }
    }

    public static void onScreenChanged(Screen previousGuiScreen, Screen newScreen, boolean unpressKeys) {
        GuiHandler.onScreenChanged(previousGuiScreen, newScreen, unpressKeys, false);
    }

    public static void onScreenChanged(Screen previousGuiScreen, Screen newScreen, boolean unpressKeys, boolean infrontOfHand) {
        if (!VRState.vrRunning) {
            return;
        }
        if (unpressKeys) {
            GuiHandler.dh.vr.ignorePressesNextFrame = true;
        }
        if (newScreen == null) {
            guiPos_room = null;
            guiRotation_room = null;
            guiScale = 1.0f;
            if (KeyboardHandler.keyboardForGui && GuiHandler.dh.vrSettings.autoCloseKeyboard) {
                KeyboardHandler.setOverlayShowing(false);
            }
        } else {
            RadialHandler.setOverlayShowing(false, null);
        }
        if (GuiHandler.mc.f_91073_ != null && !(newScreen instanceof WinScreen)) {
            if (GuiHandler.dh.vrSettings.worldRotationCached != 0.0f) {
                GuiHandler.dh.vrSettings.worldRotation = GuiHandler.dh.vrSettings.worldRotationCached;
                GuiHandler.dh.vrSettings.worldRotationCached = 0.0f;
            }
        } else {
            GuiHandler.dh.vrSettings.worldRotationCached = GuiHandler.dh.vrSettings.worldRotation;
            GuiHandler.dh.vrSettings.worldRotation = 0.0f;
        }
        boolean staticScreen = GuiHandler.mc.f_91063_ == null || ((GameRendererExtension)GuiHandler.mc.f_91063_).vivecraft$willBeInMenuRoom(newScreen);
        if (staticScreen &= !GuiHandler.dh.vrSettings.seated && !GuiHandler.dh.vrSettings.menuAlwaysFollowFace) {
            guiScale = 2.0f;
            Vector2f afloat = MCVR.get().getPlayAreaSize();
            guiPos_room = new Vec3(0.02, (double)1.3f, (double)(-Math.max(afloat != null ? afloat.y / 2.0f : 0.0f, 1.5f)));
            guiRotation_room = new Matrix4f();
            GuiHandler.guiRotation_room.M[3][3] = 1.0f;
            GuiHandler.guiRotation_room.M[2][2] = 1.0f;
            GuiHandler.guiRotation_room.M[1][1] = 1.0f;
            GuiHandler.guiRotation_room.M[0][0] = 1.0f;
            GuiHandler.guiRotation_room.M[3][1] = 0.0f;
            GuiHandler.guiRotation_room.M[2][3] = 0.0f;
            GuiHandler.guiRotation_room.M[1][0] = 0.0f;
            GuiHandler.guiRotation_room.M[0][1] = 0.0f;
            GuiHandler.guiRotation_room.M[3][2] = 0.0f;
            GuiHandler.guiRotation_room.M[2][0] = 0.0f;
            GuiHandler.guiRotation_room.M[1][2] = 0.0f;
            GuiHandler.guiRotation_room.M[0][2] = 0.0f;
            GuiHandler.guiRotation_room.M[3][0] = 0.0f;
            GuiHandler.guiRotation_room.M[2][1] = 0.0f;
            GuiHandler.guiRotation_room.M[1][3] = 0.0f;
            GuiHandler.guiRotation_room.M[0][3] = 0.0f;
        } else {
            if (previousGuiScreen == null && newScreen != null || newScreen instanceof ChatScreen || newScreen instanceof BookEditScreen || newScreen instanceof AbstractSignEditScreen) {
                VRData.VRDevicePose facingDevice;
                boolean isBlockScreen = newScreen instanceof AbstractContainerScreen && GuiHandler.mc.f_91077_ != null && GuiHandler.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                boolean isEntityScreen = newScreen instanceof AbstractContainerScreen && GuiHandler.mc.f_91077_ instanceof EntityHitResult && ((EntityHitResult)GuiHandler.mc.f_91077_).m_82443_() instanceof ContainerEntity;
                VRData.VRDevicePose vRDevicePose = facingDevice = infrontOfHand ? GuiHandler.dh.vrPlayer.vrdata_room_pre.getController(0) : GuiHandler.dh.vrPlayer.vrdata_room_pre.hmd;
                if (guiAppearOverBlockActive && (isBlockScreen || isEntityScreen) && GuiHandler.dh.vrSettings.guiAppearOverBlock) {
                    Vec3 sourcePos;
                    if (isEntityScreen) {
                        EntityHitResult entityHitResult = (EntityHitResult)GuiHandler.mc.f_91077_;
                        sourcePos = new Vec3(entityHitResult.m_82443_().m_20185_(), entityHitResult.m_82443_().m_20186_(), entityHitResult.m_82443_().m_20189_());
                    } else {
                        BlockHitResult blockHitResult = (BlockHitResult)GuiHandler.mc.f_91077_;
                        sourcePos = new Vec3((double)((float)blockHitResult.m_82425_().m_123341_() + 0.5f), (double)blockHitResult.m_82425_().m_123342_(), (double)((float)blockHitResult.m_82425_().m_123343_() + 0.5f));
                    }
                    Vec3 roomPos = VRPlayer.world_to_room_pos(sourcePos, GuiHandler.dh.vrPlayer.vrdata_world_pre);
                    Vec3 hmdPos = GuiHandler.dh.vrPlayer.vrdata_room_pre.hmd.getPosition();
                    double distance = roomPos.m_82546_(hmdPos).m_82553_();
                    guiScale = (float)Math.sqrt(distance);
                    Vec3 sourcePosWorld = new Vec3(sourcePos.f_82479_, sourcePos.f_82480_ + 1.1 + (double)(0.5f * guiScale / 2.0f), sourcePos.f_82481_);
                    guiPos_room = VRPlayer.world_to_room_pos(sourcePosWorld, GuiHandler.dh.vrPlayer.vrdata_world_pre);
                } else {
                    Vec3 vec3 = new Vec3(0.0, 0.0, -2.0);
                    if (newScreen instanceof ChatScreen) {
                        vec3 = new Vec3(0.0, 0.5, -2.0);
                    } else if (newScreen instanceof BookEditScreen || newScreen instanceof AbstractSignEditScreen) {
                        vec3 = new Vec3(0.0, 0.25, -2.0);
                    }
                    Vec3 hmdPos = facingDevice.getPosition();
                    Vec3 vec32 = facingDevice.getCustomVector(vec3);
                    guiPos_room = new Vec3(vec32.f_82479_ / 2.0 + hmdPos.f_82479_, vec32.f_82480_ / 2.0 + hmdPos.f_82480_, vec32.f_82481_ / 2.0 + hmdPos.f_82481_);
                    if (GuiHandler.dh.vrSettings.physicalKeyboard && KeyboardHandler.Showing && GuiHandler.guiPos_room.f_82480_ < hmdPos.f_82480_ + 0.2) {
                        guiPos_room = new Vec3(GuiHandler.guiPos_room.f_82479_, hmdPos.f_82480_ + 0.2, GuiHandler.guiPos_room.f_82481_);
                    }
                }
                Vec3 hmdPos = facingDevice.getPosition();
                Vector3 look = new Vector3();
                look.setX((float)(GuiHandler.guiPos_room.f_82479_ - hmdPos.f_82479_));
                look.setY((float)(GuiHandler.guiPos_room.f_82480_ - hmdPos.f_82480_));
                look.setZ((float)(GuiHandler.guiPos_room.f_82481_ - hmdPos.f_82481_));
                float pitch = (float)Math.asin(look.getY() / look.length());
                float yaw = (float)(Math.PI + Math.atan2(look.getX(), look.getZ()));
                guiRotation_room = Matrix4f.rotationY(yaw);
                Matrix4f tilt = Utils.rotationXMatrix(pitch);
                guiRotation_room = Matrix4f.multiply(guiRotation_room, tilt);
            }
            KeyboardHandler.orientOverlay(newScreen != null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Vec3 applyGUIModelView(RenderPass currentPass, PoseStack pMatrixStack) {
        mc.m_91307_().m_6180_("applyGUIModelView");
        Vec3 vec3 = RenderHelper.getSmoothCameraPosition(currentPass, GuiHandler.dh.vrPlayer.vrdata_world_render);
        if (GuiHandler.mc.f_91080_ != null && guiPos_room == null) {
            GuiHandler.onScreenChanged(null, GuiHandler.mc.f_91080_, false);
        } else if (GuiHandler.mc.f_91080_ == null && !GuiHandler.mc.f_91067_.m_91600_()) {
            if (guiPos_room == null) {
                GuiHandler.onScreenChanged(null, new Screen((Component)Component.m_237119_()){}, false, true);
            }
        } else if (GuiHandler.mc.f_91080_ == null && guiPos_room != null) {
            GuiHandler.onScreenChanged(null, null, false);
        }
        Vec3 guipos = guiPos_room;
        Matrix4f guirot = guiRotation_room;
        Vec3 guilocal = new Vec3(0.0, 0.0, 0.0);
        float scale = guiScale;
        if (guipos == null) {
            guirot = null;
            scale = 1.0f;
            if (!(GuiHandler.mc.f_91073_ == null || GuiHandler.mc.f_91080_ != null && GuiHandler.dh.vrSettings.floatInventory)) {
                int i = 1;
                if (GuiHandler.dh.vrSettings.reverseHands) {
                    i = -1;
                }
                if (!GuiHandler.dh.vrSettings.seated && GuiHandler.dh.vrSettings.vrHudLockMode != VRSettings.HUDLock.HEAD) {
                    if (GuiHandler.dh.vrSettings.vrHudLockMode == VRSettings.HUDLock.HAND) {
                        Matrix4f matrix4f5 = GuiHandler.dh.vr.getAimRotation(1);
                        Matrix4f matrix4f = Matrix4f.rotationY(GuiHandler.dh.vrPlayer.vrdata_world_render.rotation_radians);
                        Matrix4f matrix4f9 = Matrix4f.multiply(matrix4f, matrix4f5);
                        guirot = Matrix4f.multiply(matrix4f9, Utils.rotationXMatrix(-0.62831855f));
                        guirot = Matrix4f.multiply(guirot, Matrix4f.rotationY(0.31415927f * (float)i));
                        scale = 0.58823526f;
                        guilocal = new Vec3(guilocal.f_82479_, 0.32 * (double)GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale, guilocal.f_82481_);
                        guipos = RenderHelper.getControllerRenderPos(1);
                        GuiHandler.dh.vr.hudPopup = true;
                    } else if (GuiHandler.dh.vrSettings.vrHudLockMode == VRSettings.HUDLock.WRIST) {
                        Matrix4f matrix4f6 = GuiHandler.dh.vr.getAimRotation(1);
                        Matrix4f matrix4f = Matrix4f.rotationY(GuiHandler.dh.vrPlayer.vrdata_world_render.rotation_radians);
                        guirot = Matrix4f.multiply(matrix4f, matrix4f6);
                        guirot = Matrix4f.multiply(guirot, Utils.rotationZMatrix(1.5707964f * (float)i));
                        guirot = Matrix4f.multiply(guirot, Matrix4f.rotationY(0.9424779f * (float)i));
                        guipos = RenderHelper.getControllerRenderPos(1);
                        GuiHandler.dh.vr.hudPopup = true;
                        boolean flag = GuiHandler.mc.f_91074_.m_108564_().equals("slim");
                        scale = 0.4f;
                        guilocal = new Vec3((double)((float)i * -0.136f * GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale), (flag ? 0.13 : 0.12) * (double)GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale, 0.06 * (double)GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale);
                        guirot = Matrix4f.multiply(guirot, Matrix4f.rotationY(0.62831855f * (float)i));
                    }
                } else {
                    void var9_18;
                    Matrix4f matrix4f1 = Matrix4f.rotationY(GuiHandler.dh.vrPlayer.vrdata_world_render.rotation_radians);
                    Matrix4f matrix4f = Matrix4f.multiply(matrix4f1, GuiHandler.dh.vr.hmdRotation);
                    Vec3 vec33 = GuiHandler.dh.vrPlayer.vrdata_world_render.hmd.getPosition();
                    Vec3 vec34 = GuiHandler.dh.vrPlayer.vrdata_world_render.hmd.getDirection();
                    if (GuiHandler.dh.vrSettings.seated && GuiHandler.dh.vrSettings.seatedHudAltMode) {
                        vec34 = GuiHandler.dh.vrPlayer.vrdata_world_render.getController(0).getDirection();
                        Matrix4f matrix4f2 = Matrix4f.multiply(matrix4f1, GuiHandler.dh.vr.getAimRotation(0));
                    }
                    guipos = new Vec3(vec33.f_82479_ + vec34.f_82479_ * (double)GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale * (double)GuiHandler.dh.vrSettings.hudDistance, vec33.f_82480_ + vec34.f_82480_ * (double)GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale * (double)GuiHandler.dh.vrSettings.hudDistance, vec33.f_82481_ + vec34.f_82481_ * (double)GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale * (double)GuiHandler.dh.vrSettings.hudDistance);
                    Quaternion quaternion = OpenVRUtil.convertMatrix4ftoRotationQuat((Matrix4f)var9_18);
                    guirot = new Matrix4f(quaternion);
                    scale = GuiHandler.dh.vrSettings.hudScale;
                }
            }
        } else {
            VRPlayer vrplayer1 = GuiHandler.dh.vrPlayer;
            guipos = VRPlayer.room_to_world_pos(guipos, GuiHandler.dh.vrPlayer.vrdata_world_render);
            Matrix4f matrix4f4 = Matrix4f.rotationY(GuiHandler.dh.vrPlayer.vrdata_world_render.rotation_radians);
            guirot = Matrix4f.multiply(matrix4f4, guirot);
        }
        if ((GuiHandler.dh.vrSettings.seated || GuiHandler.dh.vrSettings.menuAlwaysFollowFace) && ((GameRendererExtension)GuiHandler.mc.f_91063_).vivecraft$isInMenuRoom()) {
            scale = 2.0f;
            Vec3 vec35 = new Vec3(0.0, 0.0, 0.0);
            for (Vec3 vec32 : GuiHandler.dh.vr.hmdPosSamples) {
                vec35 = new Vec3(vec35.f_82479_ + vec32.f_82479_, vec35.f_82480_ + vec32.f_82480_, vec35.f_82481_ + vec32.f_82481_);
            }
            vec35 = new Vec3(vec35.f_82479_ / (double)GuiHandler.dh.vr.hmdPosSamples.size(), vec35.f_82480_ / (double)GuiHandler.dh.vr.hmdPosSamples.size(), vec35.f_82481_ / (double)GuiHandler.dh.vr.hmdPosSamples.size());
            float f1 = 0.0f;
            Iterator iterator = GuiHandler.dh.vr.hmdYawSamples.iterator();
            while (iterator.hasNext()) {
                float f3 = ((Float)iterator.next()).floatValue();
                f1 += f3;
            }
            f1 /= (float)GuiHandler.dh.vr.hmdYawSamples.size();
            f1 = (float)Math.toRadians(f1);
            Vec3 vec33 = new Vec3(-Math.sin(f1), 0.0, Math.cos(f1));
            float f4 = ((GameRendererExtension)GuiHandler.mc.f_91063_).vivecraft$isInMenuRoom() ? 2.5f * GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale : GuiHandler.dh.vrSettings.hudDistance;
            Vec3 vec39 = vec35.m_82549_(new Vec3(vec33.f_82479_ * (double)f4, vec33.f_82480_ * (double)f4, vec33.f_82481_ * (double)f4));
            Vec3 vec310 = new Vec3(vec39.f_82479_, vec39.f_82480_, vec39.f_82481_);
            Matrix4f matrix4f3 = Matrix4f.rotationY((float)Math.PI - f1);
            guirot = Matrix4f.multiply(matrix4f3, Matrix4f.rotationY(GuiHandler.dh.vrPlayer.vrdata_world_render.rotation_radians));
            VRPlayer vrplayer = GuiHandler.dh.vrPlayer;
            guipos = VRPlayer.room_to_world_pos(vec310, GuiHandler.dh.vrPlayer.vrdata_world_render);
            guiRotation_room = matrix4f3;
            guiScale = 2.0f;
            guiPos_room = vec310;
        }
        if (guipos == null) {
            VRSettings.logger.error("guipos was null, how did that happen. vrRunning: {}", (Object)VRState.vrRunning);
            new RuntimeException().printStackTrace();
            guiPos_room = new Vec3(0.0, 0.0, 0.0);
            guipos = VRPlayer.room_to_world_pos(guiPos_room, GuiHandler.dh.vrPlayer.vrdata_world_render);
            guiRotation_room = new Matrix4f();
            guirot = new Matrix4f();
            guiScale = 1.0f;
        }
        Vec3 vec36 = guipos.m_82546_(vec3);
        pMatrixStack.m_85837_(vec36.f_82479_, vec36.f_82480_, vec36.f_82481_);
        pMatrixStack.m_252931_(guirot.toMCMatrix());
        pMatrixStack.m_85837_(guilocal.f_82479_, guilocal.f_82480_, guilocal.f_82481_);
        float f2 = scale * GuiHandler.dh.vrPlayer.vrdata_world_render.worldScale;
        pMatrixStack.m_85841_(f2, f2, f2);
        guiScaleApplied = f2;
        mc.m_91307_().m_7238_();
        return guipos;
    }

    static {
        controllerMouseX = -1.0;
        controllerMouseY = -1.0;
        guiAppearOverBlockActive = false;
        guiScale = 1.0f;
        guiScaleApplied = 1.0f;
        IPoint = new Vec3(0.0, 0.0, 0.0);
        guiPos_room = null;
        guiRotation_room = null;
        hudScale = 1.0f;
        hudPos_room = new Vec3(0.0, 0.0, 0.0);
        hudRotation_room = new Matrix4f();
        keyLeftClick = new KeyMapping("vivecraft.key.guiLeftClick", -1, "vivecraft.key.category.gui");
        keyRightClick = new KeyMapping("vivecraft.key.guiRightClick", -1, "vivecraft.key.category.gui");
        keyMiddleClick = new KeyMapping("vivecraft.key.guiMiddleClick", -1, "vivecraft.key.category.gui");
        keyShift = new KeyMapping("vivecraft.key.guiShift", -1, "vivecraft.key.category.gui");
        keyCtrl = new KeyMapping("vivecraft.key.guiCtrl", -1, "vivecraft.key.category.gui");
        keyAlt = new KeyMapping("vivecraft.key.guiAlt", -1, "vivecraft.key.category.gui");
        keyScrollUp = new KeyMapping("vivecraft.key.guiScrollUp", -1, "vivecraft.key.category.gui");
        keyScrollDown = new KeyMapping("vivecraft.key.guiScrollDown", -1, "vivecraft.key.category.gui");
        keyScrollAxis = new KeyMapping("vivecraft.key.guiScrollAxis", -1, "vivecraft.key.category.gui");
        keyKeyboardClick = new HandedKeyBinding("vivecraft.key.keyboardClick", -1, "vivecraft.key.category.keyboard"){

            @Override
            public boolean isPriorityOnController(ControllerType type) {
                if (KeyboardHandler.Showing && !GuiHandler.dh.vrSettings.physicalKeyboard) {
                    return KeyboardHandler.isUsingController(type);
                }
                return RadialHandler.isShowing() && RadialHandler.isUsingController(type);
            }
        };
        keyKeyboardShift = new HandedKeyBinding("vivecraft.key.keyboardShift", -1, "vivecraft.key.category.keyboard"){

            @Override
            public boolean isPriorityOnController(ControllerType type) {
                if (KeyboardHandler.Showing) {
                    return GuiHandler.dh.vrSettings.physicalKeyboard || KeyboardHandler.isUsingController(type);
                }
                return RadialHandler.isShowing() && RadialHandler.isUsingController(type);
            }
        };
        guiFramebuffer = null;
        guiWidth = 1280;
        guiHeight = 720;
        guiScaleFactor = GuiHandler.calculateScale(0, false, guiWidth, guiHeight);
    }
}

