/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.ItemTags;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.gameplay.trackers.VehicleTracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.mod_compat_vr.pehkui.PehkuiHelper;

public class VRPlayer {
    Minecraft mc = Minecraft.m_91087_();
    ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    public VRData vrdata_room_pre;
    public VRData vrdata_world_pre;
    public VRData vrdata_room_post;
    public VRData vrdata_world_post;
    public VRData vrdata_world_render;
    ArrayList<Tracker> trackers = new ArrayList();
    public float worldScale;
    private float rawWorldScale;
    private boolean teleportOverride;
    public boolean teleportWarning;
    public boolean vrSwitchWarning;
    public int chatWarningTimer;
    public Vec3 roomOrigin;
    private boolean isFreeMoveCurrent;
    public double wfMode;
    public int wfCount;
    public int roomScaleMovementDelay;
    boolean initdone;
    public boolean onTick;

    public void registerTracker(Tracker tracker) {
        this.trackers.add(tracker);
    }

    public VRPlayer() {
        this.worldScale = ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.rawWorldScale = ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.teleportOverride = false;
        this.teleportWarning = false;
        this.vrSwitchWarning = false;
        this.chatWarningTimer = -1;
        this.roomOrigin = new Vec3(0.0, 0.0, 0.0);
        this.isFreeMoveCurrent = true;
        this.wfMode = 0.0;
        this.wfCount = 0;
        this.roomScaleMovementDelay = 0;
        this.initdone = false;
        this.vrdata_room_pre = new VRData(new Vec3(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_room_post = new VRData(new Vec3(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(new Vec3(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_pre = new VRData(new Vec3(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
    }

    public VRData getVRDataWorld() {
        return this.vrdata_world_render != null ? this.vrdata_world_render : this.vrdata_world_pre;
    }

    public static VRPlayer get() {
        return ClientDataHolderVR.getInstance().vrPlayer;
    }

    public static Vec3 room_to_world_pos(Vec3 pos, VRData data) {
        Vec3 vec3 = new Vec3(pos.f_82479_ * (double)data.worldScale, pos.f_82480_ * (double)data.worldScale, pos.f_82481_ * (double)data.worldScale);
        vec3 = vec3.m_82524_(data.rotation_radians);
        return vec3.m_82520_(data.origin.f_82479_, data.origin.f_82480_, data.origin.f_82481_);
    }

    public static Vec3 world_to_room_pos(Vec3 pos, VRData data) {
        Vec3 vec3 = pos.m_82520_(-data.origin.f_82479_, -data.origin.f_82480_, -data.origin.f_82481_);
        vec3 = new Vec3(vec3.f_82479_ / (double)data.worldScale, vec3.f_82480_ / (double)data.worldScale, vec3.f_82481_ / (double)data.worldScale);
        return vec3.m_82524_(-data.rotation_radians);
    }

    public void postPoll() {
        this.vrdata_room_pre = new VRData(new Vec3(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        GuiHandler.processGui();
        KeyboardHandler.processGui();
        RadialHandler.processGui();
    }

    public void preTick() {
        this.onTick = true;
        this.vrdata_world_pre = new VRData(this.roomOrigin, this.dh.vrSettings.walkMultiplier, this.worldScale, (float)Math.toRadians(this.dh.vrSettings.worldRotation));
        VRSettings.ServerOverrides.Setting worldScaleOverride = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE);
        float f = worldScaleOverride.getFloat();
        if (((GameRendererExtension)this.mc.f_91063_).vivecraft$isInMenuRoom()) {
            this.worldScale = 1.0f;
        } else {
            if (this.wfCount > 0 && !this.mc.m_91104_()) {
                if (this.wfCount < 40) {
                    this.rawWorldScale = (float)((double)this.rawWorldScale - this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale < f) {
                            this.rawWorldScale = f;
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale > f) {
                        this.rawWorldScale = f;
                    }
                } else {
                    this.rawWorldScale = (float)((double)this.rawWorldScale + this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale > Mth.m_14036_((float)20.0f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax())) {
                            this.rawWorldScale = Mth.m_14036_((float)20.0f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax());
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale < Mth.m_14036_((float)0.1f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax())) {
                        this.rawWorldScale = Mth.m_14036_((float)0.1f, (float)worldScaleOverride.getValueMin(), (float)worldScaleOverride.getValueMax());
                    }
                }
                --this.wfCount;
            } else {
                this.rawWorldScale = f;
            }
            this.worldScale = this.rawWorldScale;
            if (Xplat.isModLoaded("pehkui")) {
                this.worldScale *= PehkuiHelper.getPlayerScale((Entity)this.mc.f_91074_, this.mc.m_91296_());
                if (this.worldScale > 100.0f) {
                    this.worldScale = 100.0f;
                } else if (this.worldScale < 0.025f) {
                    this.worldScale = 0.025f;
                }
            }
            if (this.mc.f_91073_ != null && this.mc.m_91090_() && (worldScaleOverride.isValueMinOverridden() || worldScaleOverride.isValueMaxOverridden())) {
                float measuredIPD = (float)ClientDataHolderVR.getInstance().vr.getEyePosition(RenderPass.LEFT).m_82546_(ClientDataHolderVR.getInstance().vr.getEyePosition(RenderPass.RIGHT)).m_82553_();
                float queriedIPD = ClientDataHolderVR.getInstance().vr.getIPD();
                float runtimeWorldScale = queriedIPD / measuredIPD;
                float actualWorldScale = this.rawWorldScale * runtimeWorldScale;
                if (actualWorldScale < worldScaleOverride.getValueMin() * 0.99f || actualWorldScale > worldScaleOverride.getValueMax() * 1.01f) {
                    VRSettings.logger.info("VIVECRAFT: disconnected user from server. runtime IPD: {}, measured IPD: {}, runtime worldscale: {}", new Object[]{Float.valueOf(queriedIPD), Float.valueOf(measuredIPD), Float.valueOf(runtimeWorldScale)});
                    this.mc.f_91073_.m_7462_();
                    this.mc.m_91320_((Screen)new DisconnectedScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()), (Component)Component.m_237115_((String)"vivecraft.message.worldscaleOutOfRange.title"), (Component)Component.m_237110_((String)"vivecraft.message.worldscaleOutOfRange", (Object[])new Object[]{Component.m_237113_((String)"%.2fx".formatted(Float.valueOf(worldScaleOverride.getValueMin()))).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)"%.2fx".formatted(Float.valueOf(worldScaleOverride.getValueMax()))).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)ClientDataHolderVR.getInstance().vr.getRuntimeName()).m_130938_(style -> style.m_131140_(ChatFormatting.GOLD))})));
                }
            }
        }
        if (this.dh.vrSettings.seated && !((GameRendererExtension)this.mc.f_91063_).vivecraft$isInMenuRoom()) {
            this.dh.vrSettings.worldRotation = this.dh.vr.seatedRot;
        }
    }

    public void postTick() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        VRData vrdata = new VRData(this.vrdata_world_pre.origin, dataholder.vrSettings.walkMultiplier, this.vrdata_world_pre.worldScale, this.vrdata_world_pre.rotation_radians);
        VRData vrdata1 = new VRData(this.vrdata_world_pre.origin, dataholder.vrSettings.walkMultiplier, this.worldScale, this.vrdata_world_pre.rotation_radians);
        Vec3 vec3 = vrdata1.hmd.getPosition().m_82546_(vrdata.hmd.getPosition());
        this.roomOrigin = this.roomOrigin.m_82546_(vec3);
        VRData vrdata2 = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, this.vrdata_world_pre.rotation_radians);
        float f = dataholder.vrSettings.worldRotation;
        float f1 = (float)Math.toDegrees(this.vrdata_world_pre.rotation_radians);
        this.rotateOriginAround(-f + f1, vrdata2.getHeadPivot());
        this.vrdata_room_post = new VRData(new Vec3(0.0, 0.0, 0.0), dataholder.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, (float)Math.toRadians(dataholder.vrSettings.worldRotation));
        this.doPermanantLookOverride(minecraft.f_91074_, this.vrdata_world_post);
        ClientNetworking.sendVRPlayerPositions(this);
        this.onTick = false;
    }

    public void preRender(float par1) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        float f = this.vrdata_world_post.worldScale * par1 + this.vrdata_world_pre.worldScale * (1.0f - par1);
        float f1 = this.vrdata_world_post.rotation_radians;
        float f2 = this.vrdata_world_pre.rotation_radians;
        float f3 = Math.abs(f1 - f2);
        if ((double)f3 > Math.PI) {
            if (f1 > f2) {
                f2 = (float)((double)f2 + Math.PI * 2);
            } else {
                f1 = (float)((double)f1 + Math.PI * 2);
            }
        }
        float f4 = f1 * par1 + f2 * (1.0f - par1);
        Vec3 vec3 = new Vec3(this.vrdata_world_pre.origin.f_82479_ + (this.vrdata_world_post.origin.f_82479_ - this.vrdata_world_pre.origin.f_82479_) * (double)par1, this.vrdata_world_pre.origin.f_82480_ + (this.vrdata_world_post.origin.f_82480_ - this.vrdata_world_pre.origin.f_82480_) * (double)par1, this.vrdata_world_pre.origin.f_82481_ + (this.vrdata_world_post.origin.f_82481_ - this.vrdata_world_pre.origin.f_82481_) * (double)par1);
        this.vrdata_world_render = new VRData(vec3, dataholder.vrSettings.walkMultiplier, f, f4);
        for (Tracker tracker : this.trackers) {
            if (tracker.getEntryPoint() != Tracker.EntryPoint.SPECIAL_ITEMS) continue;
            tracker.idleTick(minecraft.f_91074_);
            if (tracker.isActive(minecraft.f_91074_)) {
                tracker.doProcess(minecraft.f_91074_);
                continue;
            }
            tracker.reset(minecraft.f_91074_);
        }
    }

    public void postRender(float par1) {
    }

    public void setRoomOrigin(double x, double y, double z, boolean reset) {
        if (reset && this.vrdata_world_pre != null) {
            this.vrdata_world_pre.origin = new Vec3(x, y, z);
        }
        this.roomOrigin = new Vec3(x, y, z);
    }

    public void snapRoomOriginToPlayerEntity(LocalPlayer player, boolean reset, boolean instant) {
        if (!Thread.currentThread().getName().equals("Server thread") && player != null && player.m_20182_() != Vec3.f_82478_) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
            if (dataholder.sneakTracker.sneakCounter <= 0) {
                VRData vrdata = this.vrdata_world_pre;
                if (instant) {
                    vrdata = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, (float)Math.toRadians(dataholder.vrSettings.worldRotation));
                }
                Vec3 vec3 = vrdata.getHeadPivot().m_82546_(vrdata.origin);
                double d0 = player.m_20185_() - vec3.f_82479_;
                double d2 = player.m_20189_() - vec3.f_82481_;
                double d1 = player.m_20186_() + ((PlayerExtension)player).vivecraft$getRoomYOffsetFromPose();
                this.setRoomOrigin(d0, d1, d2, reset);
            }
        }
    }

    public float rotDiff_Degrees(float start, float end) {
        double d0 = Math.toRadians(end);
        double d1 = Math.toRadians(start);
        return (float)Math.toDegrees(Math.atan2(Math.sin(d0 - d1), Math.cos(d0 - d1)));
    }

    public void rotateOriginAround(float degrees, Vec3 o) {
        Vec3 vec3 = this.roomOrigin;
        float f = (float)Math.toRadians(degrees);
        if (f != 0.0f) {
            this.setRoomOrigin(Math.cos(f) * (vec3.f_82479_ - o.f_82479_) - Math.sin(f) * (vec3.f_82481_ - o.f_82481_) + o.f_82479_, vec3.f_82480_, Math.sin(f) * (vec3.f_82479_ - o.f_82479_) + Math.cos(f) * (vec3.f_82481_ - o.f_82481_) + o.f_82481_, false);
        }
    }

    public void tick(LocalPlayer player, Minecraft mc, RandomSource rand) {
        if (((PlayerExtension)player).vivecraft$getInitFromServer()) {
            if (!this.initdone) {
                System.out.println("<Debug info start>");
                System.out.println("Room object: " + this);
                System.out.println("Room origin: " + this.vrdata_world_pre.origin);
                System.out.println("Hmd position room: " + this.vrdata_room_pre.hmd.getPosition());
                System.out.println("Hmd position world: " + this.vrdata_world_pre.hmd.getPosition());
                System.out.println("Hmd Projection Left: " + this.dh.vrRenderer.eyeproj[0]);
                System.out.println("Hmd Projection Right: " + this.dh.vrRenderer.eyeproj[1]);
                System.out.println("<Debug info end>");
                this.initdone = true;
            }
            this.doPlayerMoveInRoom(player);
            for (Tracker tracker : this.trackers) {
                if (tracker.getEntryPoint() != Tracker.EntryPoint.LIVING_UPDATE) continue;
                tracker.idleTick(mc.f_91074_);
                if (tracker.isActive(mc.f_91074_)) {
                    tracker.doProcess(mc.f_91074_);
                    continue;
                }
                tracker.reset(mc.f_91074_);
            }
            if (player.m_20159_()) {
                Mob mob;
                Entity entity = mc.f_91074_.m_20202_();
                if (entity instanceof AbstractHorse) {
                    AbstractHorse abstracthorse = (AbstractHorse)entity;
                    if (abstracthorse.m_6109_() && abstracthorse.m_6254_() && !this.dh.horseTracker.isActive(mc.f_91074_)) {
                        abstracthorse.f_20883_ = this.vrdata_world_pre.getBodyYaw();
                        this.dh.vehicleTracker.rotationCooldown = 10;
                    }
                } else if (entity instanceof Mob && (mob = (Mob)entity).m_6109_()) {
                    mob.f_20883_ = this.vrdata_world_pre.getBodyYaw();
                    this.dh.vehicleTracker.rotationCooldown = 10;
                }
            }
        }
    }

    public void doPlayerMoveInRoom(LocalPlayer player) {
        block6: {
            float climbShrink;
            double shrunkClimbHalfWidth;
            AABB bbClimb;
            VRData tempVrdata;
            Minecraft minecraft;
            ClientDataHolderVR dataholder;
            block7: {
                block5: {
                    dataholder = ClientDataHolderVR.getInstance();
                    if (this.roomScaleMovementDelay <= 0) break block5;
                    --this.roomScaleMovementDelay;
                    break block6;
                }
                if (player == null || player.m_6144_() || player.m_5803_() || dataholder.jumpTracker.isjumping() || dataholder.climbTracker.isGrabbingLadder() || !player.m_6084_()) break block6;
                minecraft = Minecraft.m_91087_();
                tempVrdata = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, this.vrdata_world_pre.rotation_radians);
                if (!dataholder.vrSettings.realisticDismountEnabled || !dataholder.vehicleTracker.canRoomscaleDismount(minecraft.f_91074_)) break block7;
                Vec3 mountpos = minecraft.f_91074_.m_20202_().m_20182_();
                Vec3 head = tempVrdata.getHeadPivot();
                double distance = Math.sqrt((head.f_82479_ - mountpos.f_82479_) * (head.f_82479_ - mountpos.f_82479_) + (head.f_82481_ - mountpos.f_82481_) * (head.f_82481_ - mountpos.f_82481_));
                if (!(distance > 1.0)) break block6;
                dataholder.sneakTracker.sneakCounter = 5;
                break block6;
            }
            float playerHalfWidth = player.m_20205_() / 2.0f;
            float playerHeight = player.m_20206_();
            Vec3 eyePos = tempVrdata.getHeadPivot();
            double x = eyePos.f_82479_;
            double y = player.m_20186_();
            double z = eyePos.f_82481_;
            AABB bb = new AABB(x - (double)playerHalfWidth, y, z - (double)playerHalfWidth, x + (double)playerHalfWidth, y + (double)playerHeight, z + (double)playerHalfWidth);
            Vec3 torso = new Vec3(x, y, z);
            if (minecraft.f_91073_.m_45756_((Entity)player, bb)) {
                player.m_20343_(x, !dataholder.vrSettings.simulateFalling ? y : player.m_20186_(), z);
                player.m_20011_(bb);
                player.f_19789_ = 0.0f;
            } else if ((dataholder.vrSettings.walkUpBlocks && ((PlayerExtension)player).vivecraft$getMuhJumpFactor() == 1.0f || dataholder.climbTracker.isGrabbingLadder() && dataholder.vrSettings.realisticClimbEnabled) && player.f_19789_ == 0.0f && !minecraft.f_91073_.m_45756_((Entity)player, bbClimb = new AABB(torso.f_82479_ - (shrunkClimbHalfWidth = (double)(playerHalfWidth - (climbShrink = player.m_6972_((Pose)player.m_20089_()).f_20377_ * 0.45f))), bb.f_82289_, torso.f_82481_ - shrunkClimbHalfWidth, torso.f_82479_ + shrunkClimbHalfWidth, bb.f_82292_, torso.f_82481_ + shrunkClimbHalfWidth))) {
                int extra = 0;
                if (player.m_6147_() && dataholder.vrSettings.realisticClimbEnabled) {
                    extra = 6;
                }
                for (int i = 0; i <= 10 + extra; ++i) {
                    if (!minecraft.f_91073_.m_45756_((Entity)player, bb = bb.m_82386_(0.0, 0.1, 0.0))) continue;
                    player.m_20343_(x, bb.f_82289_, z);
                    player.m_20011_(bb);
                    Vec3 dest = this.roomOrigin.m_82520_(0.0, (double)(0.1f * (float)(i + 1)), 0.0);
                    this.setRoomOrigin(dest.f_82479_, dest.f_82480_, dest.f_82481_, false);
                    player.f_19789_ = 0.0f;
                    ((PlayerExtension)minecraft.f_91074_).vivecraft$stepSound(BlockPos.m_274446_((Position)player.m_20182_()), player.m_20182_());
                    break;
                }
            }
        }
    }

    public Vec3 getEstimatedTorsoPosition(double x, double y, double z) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        Vec3 vec3 = entity.m_20154_();
        Vec3 vec31 = new Vec3(vec3.f_82479_, 0.0, vec3.f_82481_).m_82541_();
        float f = (float)vec3.f_82480_ * 0.25f;
        return new Vec3(x + vec31.f_82479_ * (double)f, y + vec31.f_82480_ * (double)f, z + vec31.f_82481_ * (double)f);
    }

    public void blockDust(double x, double y, double z, int count, BlockPos bp, BlockState bs, float scale, float velscale) {
        new Random();
        Minecraft minecraft = Minecraft.m_91087_();
        for (int i = 0; i < count; ++i) {
            TerrainParticle terrainparticle = new TerrainParticle(minecraft.f_91073_, x, y, z, 0.0, 0.0, 0.0, bs);
            terrainparticle.m_107268_(velscale);
            minecraft.f_91061_.m_107344_(terrainparticle.m_6569_(scale));
        }
    }

    public void updateFreeMove() {
        if (this.dh.teleportTracker.isAiming()) {
            this.isFreeMoveCurrent = false;
        }
        if (this.mc.f_91074_.f_108618_ != null && (this.mc.f_91074_.f_108618_.f_108567_ != 0.0f || this.mc.f_91074_.f_108618_.f_108566_ != 0.0f)) {
            this.isFreeMoveCurrent = true;
        }
        this.updateTeleportKeys();
    }

    public boolean getFreeMove() {
        if (this.dh.vrSettings.seated) {
            return this.dh.vrSettings.seatedFreeMove || !this.isTeleportEnabled();
        }
        return this.isFreeMoveCurrent || this.dh.vrSettings.forceStandingFreeMove;
    }

    public String toString() {
        return "VRPlayer: \r\n \t origin: " + this.roomOrigin + "\r\n \t rotation: " + String.format("%.3f", Float.valueOf(ClientDataHolderVR.getInstance().vrSettings.worldRotation)) + "\r\n \t scale: " + String.format("%.3f", Float.valueOf(this.worldScale)) + "\r\n \t room_pre " + this.vrdata_room_pre + "\r\n \t world_pre " + this.vrdata_world_pre + "\r\n \t world_post " + this.vrdata_world_post + "\r\n \t world_render " + this.vrdata_world_render;
    }

    public Vec3 getRightClickLookOverride(Player entity, int c) {
        ItemStack itemstack;
        Vec3 vec3;
        block7: {
            block6: {
                vec3 = entity.m_20154_();
                if (((GameRendererExtension)this.mc.f_91063_).vivecraft$getCrossVec() != null) {
                    vec3 = entity.m_20299_(1.0f).m_82546_(((GameRendererExtension)this.mc.f_91063_).vivecraft$getCrossVec()).m_82541_().m_82548_();
                }
                ItemStack itemStack = itemstack = c == 0 ? entity.m_21205_() : entity.m_21206_();
                if (itemstack.m_41720_() instanceof SnowballItem || itemstack.m_41720_() instanceof EggItem || itemstack.m_41720_() instanceof SpawnEggItem || itemstack.m_41720_() instanceof PotionItem || itemstack.m_41720_() instanceof BowItem || itemstack.m_204117_(ItemTags.VIVECRAFT_THROW_ITEMS)) break block6;
                Item item = itemstack.m_41720_();
                if (!(item instanceof CrossbowItem)) break block7;
                CrossbowItem crossbowitem = (CrossbowItem)item;
                if (!CrossbowItem.m_40932_((ItemStack)itemstack)) break block7;
            }
            VRData vrdata = this.dh.vrPlayer.vrdata_world_pre;
            vec3 = vrdata.getController(c).getDirection();
            Vec3 vec31 = this.dh.bowTracker.getAimVector();
            if (this.dh.bowTracker.isNotched() && vec31 != null && vec31.m_82556_() > 0.0) {
                vec3 = vec31.m_82548_();
            }
            return vec3;
        }
        if (itemstack.m_41720_() == Items.f_42446_ && this.dh.interactTracker.bukkit[c]) {
            vec3 = entity.m_20299_(1.0f).m_82546_(this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition()).m_82541_().m_82548_();
        }
        return vec3;
    }

    public void doPermanantLookOverride(LocalPlayer entity, VRData data) {
        if (entity == null) {
            return;
        }
        if (entity.m_20159_()) {
            Vec3 vec3 = VehicleTracker.getSteeringDirection(entity);
            if (vec3 != null) {
                entity.m_146926_((float)Math.toDegrees(Math.asin(-vec3.f_82480_ / vec3.m_82553_())));
                entity.m_146922_((float)Math.toDegrees(Math.atan2(-vec3.f_82479_, vec3.f_82481_)));
                entity.m_5616_(entity.m_146908_());
            }
        } else if (entity.m_21254_()) {
            if (entity.m_7655_() == InteractionHand.MAIN_HAND) {
                entity.m_146922_(data.getController(0).getYaw());
                entity.m_5616_(entity.m_146908_());
                entity.m_146926_(-data.getController(0).getPitch());
            } else {
                entity.m_146922_(data.getController(1).getYaw());
                entity.m_5616_(entity.m_146908_());
                entity.m_146926_(-data.getController(1).getPitch());
            }
        } else if (entity.m_20142_() && (entity.f_108618_.f_108572_ || this.mc.f_91066_.f_92089_.m_90857_()) || entity.m_21255_() || entity.m_6069_() && entity.f_20902_ > 0.0f) {
            VRSettings.FreeMove freeMoveType;
            VRSettings.FreeMove freeMove = freeMoveType = entity.m_21255_() && this.dh.vrSettings.vrFreeMoveFlyMode != VRSettings.FreeMove.AUTO ? this.dh.vrSettings.vrFreeMoveFlyMode : this.dh.vrSettings.vrFreeMoveMode;
            if (freeMoveType == VRSettings.FreeMove.CONTROLLER) {
                entity.m_146922_(data.getController(1).getYaw());
                entity.m_5616_(entity.m_146908_());
                entity.m_146926_(-data.getController(1).getPitch());
            } else {
                entity.m_146922_(data.hmd.getYaw());
                entity.m_5616_(entity.m_146908_());
                entity.m_146926_(-data.hmd.getPitch());
            }
        } else if (((GameRendererExtension)this.mc.f_91063_).vivecraft$getCrossVec() != null) {
            Vec3 playerToCrosshair = entity.m_20299_(1.0f).m_82546_(((GameRendererExtension)this.mc.f_91063_).vivecraft$getCrossVec());
            double what = playerToCrosshair.f_82480_ / playerToCrosshair.m_82553_();
            if (what > 1.0) {
                what = 1.0;
            }
            if (what < -1.0) {
                what = -1.0;
            }
            float pitch = (float)Math.toDegrees(Math.asin(what));
            float yaw = (float)Math.toDegrees(Math.atan2(playerToCrosshair.f_82479_, -playerToCrosshair.f_82481_));
            entity.m_146926_(pitch);
            entity.m_146922_(yaw);
            entity.m_5616_(yaw);
        } else {
            entity.m_146922_(data.hmd.getYaw());
            entity.m_5616_(entity.m_146908_());
            entity.m_146926_(-data.hmd.getPitch());
        }
    }

    public Vec3 AimedPointAtDistance(VRData source, int controller, double distance) {
        Vec3 vec3 = source.getController(controller).getPosition();
        Vec3 vec31 = source.getController(controller).getDirection();
        return vec3.m_82520_(vec31.f_82479_ * distance, vec31.f_82480_ * distance, vec31.f_82481_ * distance);
    }

    public HitResult rayTraceBlocksVR(VRData source, int controller, double blockReachDistance, boolean p_174822_4_) {
        Vec3 vec3 = source.getController(controller).getPosition();
        Vec3 vec31 = this.AimedPointAtDistance(source, controller, blockReachDistance);
        return this.mc.f_91073_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_174822_4_ ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_));
    }

    public boolean isTeleportSupported() {
        return !VRServerPerms.INSTANCE.noTeleportClient;
    }

    public boolean isTeleportOverridden() {
        return this.teleportOverride;
    }

    public boolean isTeleportEnabled() {
        boolean flag;
        boolean bl = flag = !VRServerPerms.INSTANCE.noTeleportClient || this.teleportOverride;
        if (this.dh.vrSettings.seated) {
            return flag;
        }
        return flag && !this.dh.vrSettings.forceStandingFreeMove;
    }

    public void setTeleportOverride(boolean override) {
        this.teleportOverride = override;
        this.updateTeleportKeys();
    }

    public void updateTeleportKeys() {
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyTeleport).setEnabled(this.isTeleportEnabled());
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyTeleportFallback).setEnabled(!this.isTeleportEnabled());
    }
}

