/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.vivecraft.client.gui.screens.ErrorScreen;
import org.vivecraft.client.gui.screens.GarbageCollectorScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.menuworlds.MenuWorldRenderer;
import org.vivecraft.client_vr.provider.nullvr.NullVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.MCOpenVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.mod_compat_vr.ShadersHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class VRState {
    public static boolean vrRunning = false;
    public static boolean vrEnabled = false;
    public static boolean vrInitialized = false;

    public static void initializeVR() {
        if (vrInitialized) {
            return;
        }
        try {
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isAntialiasing()) {
                throw new RenderConfigException(Component.m_237115_((String)"vivecraft.messages.incompatiblesettings").getString(), (Component)Component.m_237115_((String)"vivecraft.messages.optifineaa"));
            }
            vrInitialized = true;
            ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
            if (dh.vrSettings.stereoProviderPluginID == VRSettings.VRProvider.OPENVR) {
                if (!Version.getVersion().startsWith("3.3.1")) {
                    String suppliedJar = "";
                    try {
                        suppliedJar = new File(Version.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
                    }
                    catch (Exception e) {
                        VRSettings.logger.error("couldn't check lwjgl source:", (Throwable)e);
                    }
                    throw new RenderConfigException("VR Init Error", (Component)Component.m_237110_((String)"vivecraft.messages.rendersetupfailed", (Object[])new Object[]{I18n.m_118938_((String)"vivecraft.messages.invalidlwjgl", (Object[])new Object[]{Version.getVersion(), "3.3.1", suppliedJar}), "OpenVR_LWJGL"}));
                }
                dh.vr = new MCOpenVR(Minecraft.m_91087_(), dh);
            } else {
                dh.vr = new NullVR(Minecraft.m_91087_(), dh);
            }
            if (!dh.vr.init()) {
                throw new RenderConfigException("VR Init Error", (Component)Component.m_237110_((String)"vivecraft.messages.rendersetupfailed", (Object[])new Object[]{dh.vr.initStatus, dh.vr.getName()}));
            }
            dh.vrRenderer = dh.vr.createVRRenderer();
            dh.vrRenderer.lastGuiScale = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
            dh.vrRenderer.setupRenderConfiguration();
            RenderPassManager.setVanillaRenderPass();
            dh.vrPlayer = new VRPlayer();
            dh.vrPlayer.registerTracker(dh.backpackTracker);
            dh.vrPlayer.registerTracker(dh.bowTracker);
            dh.vrPlayer.registerTracker(dh.climbTracker);
            dh.vrPlayer.registerTracker(dh.autoFood);
            dh.vrPlayer.registerTracker(dh.jumpTracker);
            dh.vrPlayer.registerTracker(dh.rowTracker);
            dh.vrPlayer.registerTracker(dh.runTracker);
            dh.vrPlayer.registerTracker(dh.sneakTracker);
            dh.vrPlayer.registerTracker(dh.swimTracker);
            dh.vrPlayer.registerTracker(dh.swingTracker);
            dh.vrPlayer.registerTracker(dh.interactTracker);
            dh.vrPlayer.registerTracker(dh.teleportTracker);
            dh.vrPlayer.registerTracker(dh.horseTracker);
            dh.vrPlayer.registerTracker(dh.vehicleTracker);
            dh.vrPlayer.registerTracker(dh.crawlTracker);
            dh.vrPlayer.registerTracker(dh.cameraTracker);
            dh.vr.postinit();
            dh.menuWorldRenderer = new MenuWorldRenderer();
            dh.menuWorldRenderer.init();
            try {
                String garbageCollector = StringUtils.getCommonPrefix((String[])((String[])ManagementFactory.getGarbageCollectorMXBeans().stream().map(MemoryManagerMXBean::getName).toArray(String[]::new))).trim();
                if (garbageCollector.isEmpty()) {
                    garbageCollector = ManagementFactory.getGarbageCollectorMXBeans().get(0).getName();
                }
                VRSettings.logger.info("Garbage collector: {}", (Object)garbageCollector);
                OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                VRSettings.logger.info("Available CPU threads: {}", (Object)Runtime.getRuntime().availableProcessors());
                VRSettings.logger.info("Total physical memory: {} GiB", (Object)String.format("%.01f", Float.valueOf((float)os.getTotalMemorySize() / 1.0737418E9f)));
                VRSettings.logger.info("Free physical memory: {} GiB", (Object)String.format("%.01f", Float.valueOf((float)os.getFreeMemorySize() / 1.0737418E9f)));
                if (!garbageCollector.startsWith("ZGC") && !ClientDataHolderVR.getInstance().vrSettings.disableGarbageCollectorMessage && os.getTotalMemorySize() >= 0x2F0000000L && Runtime.getRuntime().availableProcessors() >= 6) {
                    dh.incorrectGarbageCollector = garbageCollector;
                    Minecraft.m_91087_().m_91152_((Screen)new GarbageCollectorScreen(garbageCollector));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (RenderConfigException renderConfigException) {
            vrEnabled = false;
            VRState.destroyVR(true);
            renderConfigException.printStackTrace();
            Minecraft.m_91087_().m_91152_((Screen)new ErrorScreen(renderConfigException.title, renderConfigException.error));
        }
        catch (Throwable e) {
            vrEnabled = false;
            VRState.destroyVR(true);
            e.printStackTrace();
            MutableComponent component = Component.m_237113_((String)(e.getClass().getName() + (String)(e.getMessage() == null ? "" : ": " + e.getMessage())));
            for (StackTraceElement element : e.getStackTrace()) {
                component.m_7220_((Component)Component.m_237113_((String)("\n" + element.toString())));
            }
            Minecraft.m_91087_().m_91152_((Screen)new ErrorScreen("VR Init Error", (Component)component));
        }
    }

    public static void startVR() {
        GLFW.glfwSwapInterval((int)0);
    }

    public static void destroyVR(boolean disableVRSetting) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        if (dh.vr != null) {
            dh.vr.destroy();
        }
        dh.vr = null;
        dh.vrPlayer = null;
        if (dh.vrRenderer != null) {
            dh.vrRenderer.destroy();
        }
        dh.vrRenderer = null;
        if (dh.menuWorldRenderer != null) {
            dh.menuWorldRenderer.completeDestroy();
            dh.menuWorldRenderer = null;
        }
        vrEnabled = false;
        vrInitialized = false;
        vrRunning = false;
        if (disableVRSetting) {
            dh.vrSettings.vrEnabled = false;
            dh.vrSettings.saveOptions();
        }
        if (disableVRSetting) {
            ShadersHelper.maybeReloadShaders();
        }
    }

    public static void pauseVR() {
    }
}

