/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils.math;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class BezierCurve {
    public ArrayList<Node> nodes = new ArrayList();
    boolean circular;

    public BezierCurve(Node[] nodes, boolean circular) {
        this.nodes.addAll(Arrays.asList(nodes));
        this.circular = circular;
    }

    public BezierCurve(boolean circular) {
        this.circular = circular;
    }

    Vec3 getIntermediate(Node n1, Node n2, double perc) {
        Vec3 vec3 = n1.vertex;
        Vec3 vec31 = n1.controlOut;
        Vec3 vec32 = n2.controlIn;
        Vec3 vec33 = n2.vertex;
        return vec3.m_82490_(Math.pow(1.0 - perc, 3.0)).m_82549_(vec31.m_82490_(3.0 * Math.pow(1.0 - perc, 2.0) * perc)).m_82549_(vec32.m_82490_(3.0 * (1.0 - perc) * Math.pow(perc, 2.0))).m_82549_(vec33.m_82490_(Math.pow(perc, 3.0)));
    }

    public Vec3 getPointOnPath(double perc) {
        int k;
        int i = this.circular ? this.nodes.size() : this.nodes.size() - 1;
        double d0 = perc * (double)i;
        int j = (int)Math.floor(d0) % this.nodes.size();
        if (j == (k = (int)Math.ceil(d0) % this.nodes.size())) {
            return this.nodes.get((int)j).vertex;
        }
        Node beziercurve$node = this.nodes.get(j);
        Node beziercurve$node1 = this.nodes.get(k);
        return this.getIntermediate(beziercurve$node, beziercurve$node1, d0 - (double)j);
    }

    public Vec3[] getLinearInterpolation(int verticesPerNode) {
        if (this.nodes.size() == 0) {
            return new Vec3[0];
        }
        int i = verticesPerNode * (this.circular ? this.nodes.size() : this.nodes.size() - 1) + 1;
        Vec3[] avec3 = new Vec3[i];
        for (int j = 0; j < i; ++j) {
            double d0 = (double)j / (double)Math.max(1, i - 1);
            avec3[j] = this.getPointOnPath(d0);
        }
        return avec3;
    }

    public void render(int vertexCount, Color c, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        double d0 = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partialTicks;
        double d1 = player.f_19791_ + (player.m_20186_() - player.f_19791_) * (double)partialTicks;
        double d2 = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partialTicks;
        RenderSystem.depthMask((boolean)false);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        Vec3[] avec3 = this.getLinearInterpolation(vertexCount / this.nodes.size());
        for (int i = 0; i < avec3.length; ++i) {
            this.renderVertex(bufferbuilder, avec3[i], c, d0, d1, d2);
        }
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
    }

    void renderVertex(BufferBuilder buffer, Vec3 vert, Color color, double offX, double offY, double offZ) {
        buffer.m_5483_(vert.f_82479_ - offX, vert.f_82480_ - offY, vert.f_82481_ - offZ).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
    }

    public static class Node {
        Vec3 vertex;
        Vec3 controlIn;
        Vec3 controlOut;

        public Node(Vec3 vertex, Vec3 controlIn, Vec3 controlOut) {
            this.vertex = vertex;
            this.controlIn = controlIn;
            this.controlOut = controlOut;
        }

        public Node(Vec3 vertex, Vec3 controlDir, double controlLenIn, double controlLenOut) {
            this(vertex, vertex.m_82549_(controlDir.m_82541_().m_82490_(-controlLenIn)), vertex.m_82549_(controlDir.m_82541_().m_82490_(controlLenOut)));
        }
    }
}

