/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.common.utils.math.Quaternion;
import org.vivecraft.common.utils.math.Vector3;

public class Debug {
    Vec3 root;
    Quaternion rotation;
    public static boolean isEnabled = true;
    static Polygon cross = new Polygon(6);
    static Polygon arrowHead = new Polygon(8);
    private static final DebugRendererManual renderer = new DebugRendererManual();

    public Debug(Vec3 root) {
        this.root = root;
        this.rotation = new Quaternion();
    }

    public Debug(Vec3 root, Quaternion rotation) {
        this.root = root;
        this.rotation = rotation;
    }

    public void drawPoint(Vec3 point, Color color) {
        point = this.rotation.multiply(point);
        Vec3 vec3 = this.root.m_82549_(point);
        Polygon debug$polygon = cross.offset(vec3);
        for (int i = 0; i < debug$polygon.colors.length; ++i) {
            if (debug$polygon.colors[i] != null) continue;
            debug$polygon.colors[i] = color;
        }
        Debug.renderer.toDraw.add(debug$polygon);
    }

    public void drawVector(Vec3 start, Vec3 direction, Color color) {
        Polygon debug$polygon = new Polygon(2);
        start = this.rotation.multiply(start);
        direction = this.rotation.multiply(direction);
        debug$polygon.vertices[0] = this.root.m_82549_(start);
        debug$polygon.colors[0] = new Color(0, 0, 0, 0);
        debug$polygon.vertices[1] = this.root.m_82549_(start).m_82549_(direction);
        debug$polygon.colors[1] = color;
        Quaternion quaternion = Quaternion.createFromToVector(new Vector3(0.0f, 1.0f, 0.0f), new Vector3(direction.m_82541_()));
        Polygon debug$polygon1 = arrowHead.rotated(quaternion).offset(this.root.m_82549_(start).m_82549_(direction));
        for (int i = 0; i < debug$polygon1.colors.length; ++i) {
            if (debug$polygon1.colors[i] != null) continue;
            debug$polygon1.colors[i] = color;
        }
        Debug.renderer.toDraw.add(debug$polygon);
        Debug.renderer.toDraw.add(debug$polygon1);
    }

    public void drawLine(Vec3 start, Vec3 end, Color color) {
        start = this.rotation.multiply(start);
        end = this.rotation.multiply(end);
        Polygon debug$polygon = new Polygon(2);
        debug$polygon.vertices[0] = this.root.m_82549_(start);
        debug$polygon.colors[0] = new Color(0, 0, 0, 0);
        debug$polygon.vertices[1] = this.root.m_82549_(end);
        debug$polygon.colors[1] = color;
        Debug.renderer.toDraw.add(debug$polygon);
    }

    public void drawBoundingBox(AABB box, Color color) {
        Polygon debug$polygon = new Polygon(16);
        Vec3[] avec3 = new Vec3[4];
        Vec3[] avec31 = new Vec3[4];
        int i = 0;
        avec3[0] = new Vec3(box.f_82288_, box.f_82289_, box.f_82290_);
        avec3[1] = new Vec3(box.f_82288_, box.f_82289_, box.f_82293_);
        avec3[2] = new Vec3(box.f_82291_, box.f_82289_, box.f_82293_);
        avec3[3] = new Vec3(box.f_82291_, box.f_82289_, box.f_82290_);
        avec31[0] = new Vec3(box.f_82288_, box.f_82292_, box.f_82290_);
        avec31[1] = new Vec3(box.f_82288_, box.f_82292_, box.f_82293_);
        avec31[2] = new Vec3(box.f_82291_, box.f_82292_, box.f_82293_);
        avec31[3] = new Vec3(box.f_82291_, box.f_82292_, box.f_82290_);
        for (int j = 0; j < 4; ++j) {
            avec3[j] = this.root.m_82549_(this.rotation.multiply(avec3[j]));
            avec31[j] = this.root.m_82549_(this.rotation.multiply(avec31[j]));
        }
        for (int k = 0; k < 5; ++k) {
            debug$polygon.colors[i] = k == 0 ? new Color(0, 0, 0, 0) : color;
            debug$polygon.vertices[i] = avec3[k % 4];
            ++i;
        }
        for (int l = 0; l < 5; ++l) {
            debug$polygon.colors[i] = color;
            debug$polygon.vertices[i] = avec31[l % 4];
            ++i;
        }
        for (int i1 = 1; i1 < 4; ++i1) {
            debug$polygon.vertices[i] = avec3[i1];
            debug$polygon.colors[i] = new Color(0, 0, 0, 0);
            debug$polygon.vertices[++i] = avec31[i1];
            debug$polygon.colors[i] = color;
            ++i;
        }
        Debug.renderer.toDraw.add(debug$polygon);
    }

    public static DebugRendererManual getRenderer() {
        return renderer;
    }

    static {
        Debug.cross.colors[0] = new Color(0, 0, 0, 0);
        Debug.cross.vertices[0] = new Vec3(0.0, -0.1, 0.0);
        Debug.cross.vertices[1] = new Vec3(0.0, 0.1, 0.0);
        Debug.cross.colors[2] = new Color(0, 0, 0, 0);
        Debug.cross.vertices[2] = new Vec3(0.0, 0.0, -0.1);
        Debug.cross.vertices[3] = new Vec3(0.0, 0.0, 0.1);
        Debug.cross.colors[4] = new Color(0, 0, 0, 0);
        Debug.cross.vertices[4] = new Vec3(-0.1, 0.0, 0.0);
        Debug.cross.vertices[5] = new Vec3(0.1, 0.0, 0.0);
        Debug.arrowHead.colors[0] = new Color(0, 0, 0, 0);
        Debug.arrowHead.vertices[0] = new Vec3(0.0, 0.0, 0.0);
        Debug.arrowHead.vertices[1] = new Vec3(-0.05, -0.05, 0.0);
        Debug.arrowHead.colors[2] = new Color(0, 0, 0, 0);
        Debug.arrowHead.vertices[2] = new Vec3(0.0, 0.0, 0.0);
        Debug.arrowHead.vertices[3] = new Vec3(0.05, -0.05, 0.0);
        Debug.arrowHead.colors[4] = new Color(0, 0, 0, 0);
        Debug.arrowHead.vertices[4] = new Vec3(0.0, 0.0, 0.0);
        Debug.arrowHead.vertices[5] = new Vec3(0.0, -0.05, -0.05);
        Debug.arrowHead.colors[6] = new Color(0, 0, 0, 0);
        Debug.arrowHead.vertices[6] = new Vec3(0.0, 0.0, 0.0);
        Debug.arrowHead.vertices[7] = new Vec3(0.0, -0.05, 0.05);
    }

    static class Polygon {
        Vec3[] vertices;
        Color[] colors;

        public Polygon(int size) {
            this.vertices = new Vec3[size];
            this.colors = new Color[size];
        }

        public Polygon offset(Vec3 offset) {
            Polygon debug$polygon = new Polygon(this.vertices.length);
            for (int i = 0; i < this.vertices.length; ++i) {
                debug$polygon.vertices[i] = this.vertices[i].m_82549_(offset);
                debug$polygon.colors[i] = this.colors[i];
            }
            return debug$polygon;
        }

        public Polygon rotated(Quaternion quat) {
            Polygon debug$polygon = new Polygon(this.vertices.length);
            for (int i = 0; i < this.vertices.length; ++i) {
                debug$polygon.vertices[i] = quat.multiply(new Vector3(this.vertices[i])).toVector3d();
                debug$polygon.colors[i] = this.colors[i];
            }
            return debug$polygon;
        }
    }

    public static class DebugRendererManual
    implements DebugRenderer.SimpleDebugRenderer {
        public boolean manualClearing = false;
        ArrayList<Polygon> toDraw = new ArrayList();

        public void render(float partialTicks, long finishTimeNano) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            double d0 = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)partialTicks;
            double d1 = player.f_19791_ + (player.m_20186_() - player.f_19791_) * (double)partialTicks;
            double d2 = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)partialTicks;
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            for (Polygon debug$polygon : this.toDraw) {
                for (int i = 0; i < debug$polygon.vertices.length; ++i) {
                    this.renderVertex(bufferbuilder, debug$polygon.vertices[i], debug$polygon.colors[i], d0, d1, d2);
                }
            }
            tesselator.m_85914_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            if (!this.manualClearing) {
                this.toDraw.clear();
            }
        }

        public void m_5630_() {
            this.toDraw.clear();
        }

        void renderVertex(BufferBuilder buffer, Vec3 vert, Color color, double offX, double offY, double offZ) {
            buffer.m_5483_(vert.f_82479_ - offX, vert.f_82480_ - offY, vert.f_82481_ - offZ).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        }

        public void m_7790_(PoseStack pMatrixStack, MultiBufferSource pBuffer, double pCamX, double p_113510_, double pCamY) {
        }
    }
}

