/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.network;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.VRPlayersClient;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.common.network.BufferSerializable;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.VrPlayerState;

public class ClientNetworking {
    public static boolean displayedChatMessage = false;
    public static boolean displayedChatWarning = false;
    public static boolean serverWantsData = false;
    public static boolean serverAllowsClimbey = false;
    public static boolean serverSupportsDirectTeleport = false;
    public static boolean serverAllowsCrawling = false;
    public static boolean serverAllowsVrSwitching = false;
    public static int usedNetworkVersion = -1;
    private static float worldScallast = 0.0f;
    private static float heightlast = 0.0f;
    private static float capturedYaw;
    private static float capturedPitch;
    private static boolean overrideActive;
    public static boolean needsReset;

    public static ServerboundCustomPayloadPacket getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators command, byte[] payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(command.ordinal());
        buffer.writeBytes(payload);
        return new ServerboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static ServerboundCustomPayloadPacket createVRActivePacket(boolean vrActive) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.IS_VR_ACTIVE.ordinal());
        buffer.writeBoolean(vrActive);
        return new ServerboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static void resetServerSettings() {
        worldScallast = 0.0f;
        heightlast = 0.0f;
        serverAllowsClimbey = false;
        serverWantsData = false;
        serverSupportsDirectTeleport = false;
        serverAllowsCrawling = false;
        serverAllowsVrSwitching = false;
        usedNetworkVersion = -1;
        VRPlayersClient.clear();
        VRServerPerms.INSTANCE.setTeleportSupported(false);
        if (VRState.vrInitialized) {
            ClientDataHolderVR.getInstance().vrPlayer.setTeleportOverride(false);
        }
        ClientDataHolderVR.getInstance().vrSettings.overrides.resetAll();
    }

    public static void sendVersionInfo() {
        String s = CommonNetworkHelper.CHANNEL.toString();
        FriendlyByteBuf friendlybytebuf = new FriendlyByteBuf(Unpooled.buffer());
        friendlybytebuf.writeBytes(s.getBytes());
        Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundCustomPayloadPacket(new ResourceLocation("minecraft:register"), friendlybytebuf));
        Minecraft.m_91087_().m_91403_().m_104955_((Packet)ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.VERSION, (CommonDataHolder.getInstance().versionIdentifier + (VRState.vrRunning ? " VR" : " NONVR") + "\n0\n0").getBytes(Charsets.UTF_8)));
    }

    public static void sendVRPlayerPositions(VRPlayer vrPlayer) {
        float f1;
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (!serverWantsData || connection == null) {
            return;
        }
        float worldScale = ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_post.worldScale;
        if (worldScale != worldScallast) {
            ByteBuf bytebuf = Unpooled.buffer();
            bytebuf.writeFloat(worldScale);
            byte[] abyte = new byte[bytebuf.readableBytes()];
            bytebuf.readBytes(abyte);
            ServerboundCustomPayloadPacket serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.WORLDSCALE, abyte);
            Minecraft.m_91087_().m_91403_().m_104955_((Packet)serverboundcustompayloadpacket);
            worldScallast = worldScale;
        }
        if ((f1 = AutoCalibration.getPlayerHeight()) != heightlast) {
            ByteBuf bytebuf2 = Unpooled.buffer();
            bytebuf2.writeFloat(f1 / 1.52f);
            byte[] abyte3 = new byte[bytebuf2.readableBytes()];
            bytebuf2.readBytes(abyte3);
            ServerboundCustomPayloadPacket serverboundcustompayloadpacket1 = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.HEIGHT, abyte3);
            Minecraft.m_91087_().m_91403_().m_104955_((Packet)serverboundcustompayloadpacket1);
            heightlast = f1;
        }
        VrPlayerState vrPlayerState = VrPlayerState.create(vrPlayer);
        if (usedNetworkVersion >= 0) {
            connection.m_104955_((Packet)ClientNetworking.createVrPlayerStatePacket(vrPlayerState));
        } else {
            ClientNetworking.sendLegacyPackets(connection, vrPlayerState);
        }
        VRPlayersClient.getInstance().Update(Minecraft.m_91087_().f_91074_.m_36316_().getId(), vrPlayerState, worldScale, f1 / 1.52f, true);
    }

    private static byte[] serializeToArray(BufferSerializable object, byte[] additionalData) {
        FriendlyByteBuf tempBuffer = new FriendlyByteBuf(Unpooled.buffer());
        if (additionalData != null) {
            tempBuffer.writeBytes(additionalData);
        }
        object.serialize(tempBuffer);
        byte[] buffer = new byte[tempBuffer.readableBytes()];
        tempBuffer.readBytes(buffer);
        tempBuffer.release();
        return buffer;
    }

    public static ServerboundCustomPayloadPacket createVrPlayerStatePacket(VrPlayerState vrPlayerState) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.VR_PLAYER_STATE.ordinal());
        vrPlayerState.serialize(buffer);
        return new ServerboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static void sendLegacyPackets(ClientPacketListener connection, VrPlayerState vrPlayerState) {
        FriendlyByteBuf controller0Buffer = new FriendlyByteBuf(Unpooled.buffer());
        controller0Buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.CONTROLLER0DATA.ordinal());
        controller0Buffer.writeBoolean(ClientDataHolderVR.getInstance().vrSettings.reverseHands);
        vrPlayerState.controller0().serialize(controller0Buffer);
        connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, controller0Buffer));
        FriendlyByteBuf controller1Buffer = new FriendlyByteBuf(Unpooled.buffer());
        controller1Buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.CONTROLLER1DATA.ordinal());
        controller1Buffer.writeBoolean(ClientDataHolderVR.getInstance().vrSettings.reverseHands);
        vrPlayerState.controller1().serialize(controller1Buffer);
        connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, controller1Buffer));
        FriendlyByteBuf headBuffer = new FriendlyByteBuf(Unpooled.buffer());
        headBuffer.writeByte(CommonNetworkHelper.PacketDiscriminators.HEADDATA.ordinal());
        headBuffer.writeBoolean(ClientDataHolderVR.getInstance().vrSettings.seated);
        vrPlayerState.hmd().serialize(headBuffer);
        connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, headBuffer));
    }

    public static boolean isThirdPersonItems() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS).getBoolean();
    }

    public static boolean isThirdPersonItemsCustom() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS_CUSTOM).getBoolean();
    }

    public static boolean isLimitedSurvivalTeleport() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.LIMIT_TELEPORT).getBoolean();
    }

    public static int getTeleportUpLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_UP_LIMIT).getInt();
    }

    public static int getTeleportDownLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_DOWN_LIMIT).getInt();
    }

    public static int getTeleportHorizLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_HORIZ_LIMIT).getInt();
    }

    public static void sendActiveHand(byte c) {
        if (serverWantsData) {
            ServerboundCustomPayloadPacket serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.ACTIVEHAND, new byte[]{c});
            if (Minecraft.m_91087_().m_91403_() != null) {
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)serverboundcustompayloadpacket);
            }
        }
    }

    public static void overridePose(LocalPlayer player) {
        if (ClientDataHolderVR.getInstance().crawlTracker.crawling) {
            player.m_20124_(Pose.SWIMMING);
        }
    }

    public static void overrideLook(Player player, Vec3 view) {
        if (!serverWantsData) {
            capturedPitch = player.m_146909_();
            capturedYaw = player.m_146908_();
            float f = (float)Math.toDegrees(Math.asin(-view.f_82480_ / view.m_82553_()));
            float f1 = (float)Math.toDegrees(Math.atan2(-view.f_82479_, view.f_82481_));
            ((LocalPlayer)player).f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(f1, f, player.m_20096_()));
            overrideActive = true;
        }
    }

    public static void restoreLook(Player player) {
        if (!serverWantsData && overrideActive) {
            ((LocalPlayer)player).f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(capturedYaw, capturedPitch, player.m_20096_()));
            overrideActive = false;
        }
    }

    public static void handlePacket(CommonNetworkHelper.PacketDiscriminators packetID, FriendlyByteBuf buffer) {
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        Minecraft mc = Minecraft.m_91087_();
        switch (packetID) {
            case VERSION: {
                String s11 = buffer.m_130136_(1024);
                VRServerPerms.INSTANCE.setTeleportSupported(true);
                if (VRState.vrInitialized) {
                    dataholder.vrPlayer.teleportWarning = false;
                    dataholder.vrPlayer.vrSwitchWarning = true;
                }
                if (!displayedChatMessage && (dataholder.vrSettings.showServerPluginMessage == VRSettings.ChatServerPluginMessage.ALWAYS || dataholder.vrSettings.showServerPluginMessage == VRSettings.ChatServerPluginMessage.SERVER_ONLY && !Minecraft.m_91087_().m_91090_())) {
                    displayedChatMessage = true;
                    mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"vivecraft.messages.serverplugin", (Object[])new Object[]{s11}));
                }
                if (!VRState.vrEnabled || dataholder.vrSettings.manualCalibration != -1.0f || dataholder.vrSettings.seated) break;
                mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"vivecraft.messages.calibrateheight"));
                break;
            }
            case IS_VR_ACTIVE: {
                if (buffer.readBoolean()) break;
                VRPlayersClient.getInstance().disableVR(buffer.m_130259_());
                break;
            }
            case REQUESTDATA: {
                serverWantsData = true;
                break;
            }
            case CLIMBING: {
                serverAllowsClimbey = buffer.readBoolean();
                if (buffer.readableBytes() <= 0) break;
                dataholder.climbTracker.serverblockmode = buffer.readByte();
                dataholder.climbTracker.blocklist.clear();
                while (buffer.readableBytes() > 0) {
                    String s12 = buffer.m_130136_(16384);
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(s12));
                    if (block == Blocks.f_50016_) continue;
                    dataholder.climbTracker.blocklist.add(block);
                }
                break;
            }
            case TELEPORT: {
                serverSupportsDirectTeleport = true;
                break;
            }
            case UBERPACKET: {
                UUID uuid = buffer.m_130259_();
                VrPlayerState vrPlayerState = VrPlayerState.deserialize(buffer);
                float worldScale = buffer.readFloat();
                float heightScale = buffer.readFloat();
                VRPlayersClient.getInstance().Update(uuid, vrPlayerState, worldScale, heightScale);
                break;
            }
            case SETTING_OVERRIDE: {
                while (buffer.readableBytes() > 0) {
                    String s13 = buffer.m_130136_(16384);
                    String s14 = buffer.m_130136_(16384);
                    String[] astring = s13.split("\\.", 2);
                    if (!dataholder.vrSettings.overrides.hasSetting(astring[0])) continue;
                    VRSettings.ServerOverrides.Setting vrsettings$serveroverrides$setting = dataholder.vrSettings.overrides.getSetting(astring[0]);
                    try {
                        if (astring.length > 1) {
                            String s15;
                            switch (s15 = astring[1]) {
                                case "min": {
                                    vrsettings$serveroverrides$setting.setValueMin(Float.parseFloat(s14));
                                    break;
                                }
                                case "max": {
                                    vrsettings$serveroverrides$setting.setValueMax(Float.parseFloat(s14));
                                }
                            }
                        } else {
                            Object object = vrsettings$serveroverrides$setting.getOriginalValue();
                            if (object instanceof Boolean) {
                                vrsettings$serveroverrides$setting.setValue(s14.equals("true"));
                            } else if (!(object instanceof Integer || object instanceof Byte || object instanceof Short)) {
                                if (!(object instanceof Float) && !(object instanceof Double)) {
                                    vrsettings$serveroverrides$setting.setValue(s14);
                                } else {
                                    vrsettings$serveroverrides$setting.setValue(Float.valueOf(Float.parseFloat(s14)));
                                }
                            } else {
                                vrsettings$serveroverrides$setting.setValue(Integer.parseInt(s14));
                            }
                        }
                        System.out.println("Server setting override: " + s13 + " = " + s14);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case CRAWL: {
                serverAllowsCrawling = true;
                break;
            }
            case NETWORK_VERSION: {
                usedNetworkVersion = buffer.readByte() & 0xFF;
                break;
            }
            case VR_SWITCHING: {
                serverAllowsVrSwitching = buffer.readBoolean();
                if (!VRState.vrInitialized) break;
                if (!serverAllowsVrSwitching) {
                    Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"vivecraft.messages.novrhotswitching"));
                }
                dataholder.vrPlayer.vrSwitchWarning = false;
            }
        }
    }

    static {
        needsReset = true;
    }
}

