/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.widgets;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TextScrollWidget
extends AbstractWidget {
    private int maxLines = 0;
    private int currentLine = 0;
    private int scrollBarSize = 0;
    private int scrollBarOffset = 0;
    private int scrollSteps = 0;
    private boolean scrollDragActive;
    private final int scrollBarWidth = 5;
    private final int padding = 5;
    private final List<FormattedCharSequence> formattedChars;

    public TextScrollWidget(int x, int y, int width, int height, String text) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.formattedChars = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)text), width - 10);
        this.initScroll();
    }

    public TextScrollWidget(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.formattedChars = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)text, width - 10);
        this.initScroll();
    }

    private void initScroll() {
        this.maxLines = (this.f_93619_ - 2 - 5 + 3) / 12;
        this.currentLine = 0;
        this.scrollSteps = this.formattedChars.size() - this.maxLines;
        this.scrollSteps = Math.max(this.scrollSteps, 0);
        this.scrollBarSize = this.scrollSteps == 0 ? this.f_93619_ - 2 : (int)((float)Math.max(this.formattedChars.size(), this.maxLines) / (float)this.scrollSteps * 12.0f);
        this.scrollBarOffset = this.f_93619_ - this.scrollBarSize - 2;
    }

    public void m_87963_(GuiGraphics guiGraphics, int x, int y, float f) {
        float scrollbarStart;
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -6250336);
        guiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93619_ - 1, -16777216);
        for (int line = 0; line + this.currentLine < this.formattedChars.size() && line < this.maxLines; ++line) {
            guiGraphics.m_280648_(Minecraft.m_91087_().f_91062_, this.formattedChars.get(line + this.currentLine), this.m_252754_() + 5, this.m_252907_() + 5 + line * 12, 0xFFFFFF);
        }
        float f2 = scrollbarStart = this.scrollSteps == 0 ? 0.0f : (float)this.currentLine / (float)this.scrollSteps * (float)this.scrollBarOffset;
        if (this.m_93696_() || this.f_93622_) {
            guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 5 - 2, (int)((float)(this.m_252907_() + 1) + scrollbarStart), this.m_252754_() + this.f_93618_ - 1, (int)((float)(this.m_252907_() + 1) + scrollbarStart + (float)this.scrollBarSize), -1);
        }
        guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 5 - (this.m_93696_() || this.f_93622_ ? 1 : 2), (int)((float)(this.m_252907_() + (this.m_93696_() || this.f_93622_ ? 2 : 1)) + scrollbarStart), this.m_252754_() + this.f_93618_ - (this.m_93696_() || this.f_93622_ ? 2 : 1), (int)((float)(this.m_252907_() + (this.m_93696_() || this.f_93622_ ? 0 : 1)) + scrollbarStart + (float)this.scrollBarSize), -6250336);
        this.renderMouseover(guiGraphics, x, y);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_5716_(double x, double y) {
        Style style;
        if (x >= (double)(this.m_252754_() + this.f_93618_ - 5) && x <= (double)(this.m_252754_() + this.f_93618_) && y >= (double)this.m_252907_() && y <= (double)(this.m_252907_() + this.f_93619_)) {
            this.scrollDragActive = true;
            if (this.maxLines < this.formattedChars.size()) {
                this.setCurrentLineFromYPos(y);
            }
        } else if (this.m_93680_(x, y) && (style = this.getMouseoverStyle(x, y)) != null && style.m_131182_() != null) {
            Minecraft.m_91087_().f_91080_.m_5561_(style);
        }
    }

    public void m_7691_(double x, double y) {
        this.scrollDragActive = false;
        super.m_7691_(x, y);
    }

    public void m_7212_(double x, double y, double xRel, double yRel) {
        if (this.f_93624_ && this.f_93623_ && this.scrollDragActive) {
            this.setCurrentLineFromYPos(y);
        }
    }

    private void setCurrentLineFromYPos(double y) {
        this.currentLine = y < (double)this.m_252907_() + (double)this.scrollBarSize * 0.5 ? 0 : (y > (double)(this.m_252907_() + this.f_93619_) - (double)this.scrollBarSize * 0.5 ? this.scrollSteps : (int)((y - (double)this.m_252907_() - (double)this.scrollBarSize * 0.5) / (double)(this.f_93619_ - this.scrollBarSize) * (double)this.scrollSteps));
    }

    public boolean m_6050_(double x, double y, double scrollAmountY) {
        if (scrollAmountY < 0.0 && this.currentLine < this.scrollSteps) {
            ++this.currentLine;
        } else if (scrollAmountY > 0.0 && this.currentLine > 0) {
            --this.currentLine;
        } else {
            return false;
        }
        return true;
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if ((key == 265 || key == 264) && this.m_6050_(0.0, 0.0, key == 265 ? 1.0 : -1.0)) {
            return true;
        }
        return super.m_7933_(key, scancode, mods);
    }

    public Style getMouseoverStyle(double x, double y) {
        int lineIndex = this.getLineIndex(x, y);
        if (lineIndex >= 0 && lineIndex < this.formattedChars.size()) {
            FormattedCharSequence line = this.formattedChars.get(lineIndex);
            return Minecraft.m_91087_().f_91062_.m_92865_().m_92338_(line, Mth.m_14107_((double)(x - (double)this.m_252754_())));
        }
        return null;
    }

    private int getLineIndex(double x, double y) {
        if (!this.m_93680_(x, y)) {
            return -1;
        }
        return (int)((y - (double)this.m_252907_() - 2.5) / 12.0);
    }

    public void renderMouseover(GuiGraphics guiGraphics, int x, int y) {
        Style style = this.getMouseoverStyle(x, y);
        if (style != null && style.m_131186_() != null) {
            guiGraphics.m_280304_(Minecraft.m_91087_().f_91062_, style, x, y);
        }
    }
}

