/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.foundation.item.SmartInventory;
import com.tom.createores.Config;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.util.ThreeState;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;

public class VeinRecipe
implements Recipe<SmartInventory> {
    public ResourceLocation id;
    public RecipeType<?> type;
    public RecipeSerializer<?> serializer;
    public int priority;
    public Component veinName;
    public TagKey<Biome> biomeWhitelist;
    public TagKey<Biome> biomeBlacklist;
    public ThreeState finite;
    public float amountMultiplierMin;
    public float amountMultiplierMax;
    public RandomSpreadStructurePlacement placement;
    public ItemStack icon;
    protected boolean isNet;

    public VeinRecipe(ResourceLocation id, RecipeType<?> type, RecipeSerializer<?> serializer) {
        this.id = id;
        this.type = type;
        this.serializer = serializer;
    }

    public boolean matches(SmartInventory pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(SmartInventory p_44001_, RegistryAccess p_267165_) {
        return this.m_8043_(p_267165_);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public Component getName() {
        return this.veinName;
    }

    public String m_6076_() {
        return "ore_vein_type";
    }

    public boolean canGenerate(ServerLevel lvl, Holder<Biome> b) {
        if (this.biomeBlacklist != null && VeinRecipe.isInTag(this.biomeBlacklist, lvl, b)) {
            return false;
        }
        if (this.biomeWhitelist != null) {
            return VeinRecipe.isInTag(this.biomeWhitelist, lvl, b);
        }
        return true;
    }

    private static boolean isInTag(TagKey<Biome> tag, ServerLevel lvl, Holder<Biome> b) {
        return lvl.m_7654_().m_206579_().m_175515_(Registries.f_256952_).m_203431_(tag).map(t -> t.m_203333_(b)).orElse(false);
    }

    public ThreeState isFinite() {
        return this.finite;
    }

    public float getMinAmount() {
        return this.amountMultiplierMin;
    }

    public float getMaxAmount() {
        return this.amountMultiplierMax;
    }

    public boolean isInfiniteClient() {
        return this.isNet ? this.finite == ThreeState.NEVER : (this.finite == ThreeState.DEFAULT ? Config.defaultInfinite : this.finite == ThreeState.NEVER);
    }

    public long getMinAmountClient() {
        return Math.round(this.isNet ? (double)this.amountMultiplierMin : (double)this.amountMultiplierMin * (double)Config.finiteAmountBase);
    }

    public long getMaxAmountClient() {
        return Math.round(this.isNet ? (double)this.amountMultiplierMax : (double)this.amountMultiplierMax * (double)Config.finiteAmountBase);
    }

    public int getNegGenerationPriority() {
        return -this.priority;
    }

    public RandomSpreadStructurePlacement getPlacement() {
        return this.placement;
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends VeinRecipe> {
        public T create(ResourceLocation var1, RecipeType<?> var2, RecipeSerializer<?> var3);
    }

    public static class Serializer<T extends VeinRecipe>
    implements RecipeSerializer<T> {
        private static final ResourceLocation NULL = new ResourceLocation("coe:null");
        private final CreateOreExcavation.RecipeTypeGroup<?> type;
        private final RecipeFactory<T> create;

        public Serializer(CreateOreExcavation.RecipeTypeGroup<?> type, RecipeFactory<T> create) {
            this.type = type;
            this.create = create;
        }

        public T fromJson(ResourceLocation pRecipeId, JsonObject json) {
            ResourceLocation resourcelocation;
            T r = this.create.create(pRecipeId, this.type.getRecipeType(), this);
            ((VeinRecipe)r).veinName = Component.Serializer.m_130701_((String)json.get("name").getAsString());
            ((VeinRecipe)r).priority = GsonHelper.m_13824_((JsonObject)json, (String)"priority", (int)0);
            if (json.has("biomeWhitelist")) {
                resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biomeWhitelist"));
                ((VeinRecipe)r).biomeWhitelist = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourcelocation);
            }
            if (json.has("biomeBlacklist")) {
                resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biomeBlacklist"));
                ((VeinRecipe)r).biomeBlacklist = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)resourcelocation);
            }
            ((VeinRecipe)r).finite = ThreeState.get(json, "Finite");
            ((VeinRecipe)r).amountMultiplierMin = GsonHelper.m_13820_((JsonObject)json, (String)"amountMin", (float)1.0f);
            ((VeinRecipe)r).amountMultiplierMax = GsonHelper.m_13820_((JsonObject)json, (String)"amountMax", (float)2.0f);
            DataResult result = RandomSpreadStructurePlacement.f_204972_.parse((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_13930_((JsonObject)json, (String)"placement"));
            ((VeinRecipe)r).placement = (RandomSpreadStructurePlacement)result.getOrThrow(false, error -> CreateOreExcavation.LOGGER.error(error));
            ((VeinRecipe)r).icon = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"icon"));
            return r;
        }

        public void toJson(T recipe, JsonObject json) {
            json.addProperty("name", Component.Serializer.m_130703_((Component)((VeinRecipe)recipe).veinName));
            json.addProperty("priority", (Number)((VeinRecipe)recipe).priority);
            if (((VeinRecipe)recipe).biomeWhitelist != null) {
                json.addProperty("biomeWhitelist", ((VeinRecipe)recipe).biomeWhitelist.f_203868_().toString());
            }
            if (((VeinRecipe)recipe).biomeBlacklist != null) {
                json.addProperty("biomeBlacklist", ((VeinRecipe)recipe).biomeBlacklist.f_203868_().toString());
            }
            ((VeinRecipe)recipe).finite.toJson(json, "Finite");
            json.addProperty("amountMin", (Number)Float.valueOf(((VeinRecipe)recipe).amountMultiplierMin));
            json.addProperty("amountMax", (Number)Float.valueOf(((VeinRecipe)recipe).amountMultiplierMax));
            DataResult result = RandomSpreadStructurePlacement.f_204972_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((VeinRecipe)recipe).placement);
            json.add("placement", (JsonElement)result.getOrThrow(false, error -> CreateOreExcavation.LOGGER.error(error)));
            json.add("icon", (JsonElement)this.serializeItem(((VeinRecipe)recipe).icon));
        }

        private JsonObject serializeItem(ItemStack stack) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
            return jsonobject;
        }

        public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buffer) {
            T r = this.create.create(pRecipeId, this.type.getRecipeType(), this);
            ((VeinRecipe)r).priority = buffer.m_130242_();
            ((VeinRecipe)r).veinName = buffer.m_130238_();
            ((VeinRecipe)r).biomeWhitelist = Serializer.create(buffer);
            ((VeinRecipe)r).biomeBlacklist = Serializer.create(buffer);
            ((VeinRecipe)r).finite = buffer.readBoolean() ? ThreeState.ALWAYS : ThreeState.NEVER;
            ((VeinRecipe)r).amountMultiplierMin = buffer.readFloat();
            ((VeinRecipe)r).amountMultiplierMax = buffer.readFloat();
            ((VeinRecipe)r).icon = buffer.m_130267_();
            ((VeinRecipe)r).isNet = true;
            return r;
        }

        private static TagKey<Biome> create(FriendlyByteBuf buffer) {
            ResourceLocation rl = buffer.m_130281_();
            if (NULL.equals((Object)rl)) {
                return null;
            }
            return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            buffer.m_130130_(((VeinRecipe)recipe).priority);
            buffer.m_130083_(((VeinRecipe)recipe).veinName);
            Serializer.write(((VeinRecipe)recipe).biomeWhitelist, buffer);
            Serializer.write(((VeinRecipe)recipe).biomeBlacklist, buffer);
            buffer.writeBoolean(((VeinRecipe)recipe).finite == ThreeState.DEFAULT ? !Config.defaultInfinite : ((VeinRecipe)recipe).finite == ThreeState.ALWAYS);
            buffer.writeFloat(((VeinRecipe)recipe).amountMultiplierMin * (float)Config.finiteAmountBase);
            buffer.writeFloat(((VeinRecipe)recipe).amountMultiplierMax * (float)Config.finiteAmountBase);
            buffer.m_130055_(((VeinRecipe)recipe).icon);
        }

        private static void write(TagKey<Biome> tag, FriendlyByteBuf buffer) {
            buffer.m_130085_(tag != null ? tag.f_203868_() : NULL);
        }
    }
}

