/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import org.joml.Matrix4f;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = SophisticatedCore.getRL("textures/gui/gui_controls.png");
    private static final int GUI_CONTROLS_TEXTURE_WIDTH = 256;
    private static final int GUI_CONTROLS_TEXTURE_HEIGHT = 256;
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = SophisticatedCore.getRL("textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = SophisticatedCore.getRL("textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();

    private GuiHelper() {
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotWidth, int slotHeight) {
        int currentY = y;
        for (int remainingSlotHeight = slotHeight; remainingSlotHeight > 0; remainingSlotHeight -= Math.min(slotHeight, 12)) {
            int finalRemainingSlotHeight = remainingSlotHeight;
            int key = GuiHelper.getSlotsBackgroundKey(slotWidth, remainingSlotHeight);
            GuiHelper.blit(guiGraphics, x, currentY, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, finalRemainingSlotHeight * 18))));
            currentY += 216;
        }
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        RenderSystem.enableDepthTest();
        guiGraphics.m_280480_(stack, xPosition, yPosition);
        if (renderOverlay) {
            guiGraphics.m_280302_(minecraft.f_91062_, stack, xPosition, yPosition, countText);
        }
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData) {
        guiGraphics.m_280163_(texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), texData.getWidth(), texData.getHeight(), texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData, int width, int height) {
        int halfWidth = width / 2;
        int secondHalfWidth = width - halfWidth;
        int halfHeight = height / 2;
        int secondHalfHeight = height - halfHeight;
        guiGraphics.m_280163_(texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), halfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.m_280163_(texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset(), (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV(), secondHalfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.m_280163_(texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset() + halfHeight, (float)texData.getU(), (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, halfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.m_280163_(texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset() + halfHeight, (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, secondHalfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void coloredBlit(Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        RenderSystem.setShader(GameRenderer::m_172814_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(matrix, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void renderTooltipBackground(Matrix4f matrix4f, int tooltipWidth, int leftX, int topY, int tooltipHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 4, leftX + tooltipWidth + 3, topY - 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 4, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 4, topY - 3, leftX - 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 3, topY - 3, leftX + tooltipWidth + 4, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3 + 1, leftX - 3 + 1, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 2, topY - 3 + 1, leftX + tooltipWidth + 3, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 2, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void writeTooltipLines(List<? extends FormattedText> textLines, Font font, float leftX, int topY, Matrix4f matrix4f, MultiBufferSource.BufferSource renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            FormattedText line = textLines.get(i);
            if (line != null) {
                font.m_272191_(Language.m_128107_().m_5536_(line), leftX, (float)topY, color, true, matrix4f, (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_252986_(matrix, (float)x2, (float)y1, 400.0f).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, 400.0f).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y2, 400.0f).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, 400.0f).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public static void fill(GuiGraphics guiGraphics, float minX, float minY, float maxX, float maxY, int color) {
        GuiHelper.fill(guiGraphics, RenderType.m_285907_(), minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fill(GuiGraphics guiGraphics, RenderType renderType, float minX, float minY, float maxX, float maxY, float z, int color) {
        float j;
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        if (minX < maxX) {
            j = minX;
            minX = maxX;
            maxX = j;
        }
        if (minY < maxY) {
            j = minY;
            minY = maxY;
            maxY = j;
        }
        VertexConsumer vertexconsumer = guiGraphics.m_280091_().m_6299_(renderType);
        vertexconsumer.m_252986_(matrix4f, minX, minY, z).m_193479_(color).m_5752_();
        vertexconsumer.m_252986_(matrix4f, minX, maxY, z).m_193479_(color).m_5752_();
        vertexconsumer.m_252986_(matrix4f, maxX, maxY, z).m_193479_(color).m_5752_();
        vertexconsumer.m_252986_(matrix4f, maxX, minY, z).m_193479_(color).m_5752_();
        guiGraphics.m_280262_();
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, Component ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new Component[]{Component.m_237115_((String)tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<Component> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(guiGraphics, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(guiGraphics, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static void renderTiledFluidTextureAtlas(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        int spriteHeight = sprite.m_245424_().m_245330_();
        int spriteWidth = sprite.m_245424_().m_246492_();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.m_118393_((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
            float u2 = sprite.m_118367_((double)(256.0f / (float)spriteWidth));
            builder.m_252986_(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).m_85950_(red, green, blue, 1.0f).m_7421_(u1, v2).m_5752_();
            builder.m_252986_(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).m_85950_(red, green, blue, 1.0f).m_7421_(u2, v2).m_5752_();
            builder.m_252986_(matrix, (float)x + 16.0f, (float)startY, 100.0f).m_85950_(red, green, blue, 1.0f).m_7421_(u2, v1).m_5752_();
            builder.m_252986_(matrix, (float)x, (float)startY, 100.0f).m_85950_(red, green, blue, 1.0f).m_7421_(u1, v1).m_5752_();
            startY += renderHeight;
        } while (height > 0);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight) {
        int u = 29;
        int v = 146;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        GuiHelper.renderControlBackground(guiGraphics, x, y, renderWidth, renderHeight, u, v, textureBgWidth, textureBgHeight);
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight, int u, int v, int textureBgWidth, int textureBgHeight) {
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        guiGraphics.m_280163_(GUI_CONTROLS, x, y, (float)u, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.m_280163_(GUI_CONTROLS, x, y + halfHeight, (float)u, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
        guiGraphics.m_280163_(GUI_CONTROLS, x + halfWidth, y, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.m_280163_(GUI_CONTROLS, x + halfWidth, y + halfHeight, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
    }

    public static void tryRenderGuiItem(ItemRenderer itemRenderer, @Nullable LivingEntity livingEntity, ItemStack stack, int x, int y, int rotation) {
        if (!stack.m_41619_()) {
            BakedModel bakedmodel = itemRenderer.m_174264_(stack, null, livingEntity, 0);
            try {
                GuiHelper.renderGuiItem(itemRenderer, stack, x, y, bakedmodel, rotation);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
                crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
                throw new ReportedException(crashreport);
            }
        }
    }

    private static void renderGuiItem(ItemRenderer itemRenderer, ItemStack stack, int x, int y, BakedModel bakedModel, int rotation) {
        boolean flag;
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        posestack.m_85837_(8.0, 8.0, 0.0);
        if (rotation != 0) {
            posestack.m_252781_(Axis.f_252403_.m_252977_((float)rotation));
        }
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, posestack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        RenderSystem.disableDepthTest();
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderTooltip(Screen screen, GuiGraphics guiGraphics, List<Component> components, int x, int y) {
        List<ClientTooltipComponent> list = GuiHelper.gatherTooltipComponents(components, x, screen.f_96543_, screen.f_96544_, screen.f_96547_);
        guiGraphics.m_280497_(screen.f_96547_, list, x, y, DefaultTooltipPositioner.f_262752_);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ForgeHooksClient.getTooltipFont((ItemStack)ItemStack.f_41583_, (Font)fallbackFont);
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(ItemStack.f_41583_, screenWidth, screenHeight, elements, -1);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipX = mouseX + 12;
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).m_92852_(arg_0), component -> 0)).max().orElse(0);
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.m_92923_(text, tooltipTextWidthF).stream().map(ClientTooltipComponent::m_169948_), component -> Stream.of(ClientTooltipComponent.m_169950_((TooltipComponent)component)))).toList();
    }

    public static Optional<Rect2i> getPositiveRectangle(int x, int y, int width, int height) {
        if (x + width <= 0 || y + height <= 0) {
            return Optional.empty();
        }
        int positiveX = Math.max(0, x);
        int positiveY = Math.max(0, y);
        int positiveWidth = width + Math.min(0, x);
        int positiveHeight = height + Math.min(0, y);
        return Optional.of(new Rect2i(positiveX, positiveY, positiveWidth, positiveHeight));
    }
}

