/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ModParticles::registerFactories);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::onPlayerJoinServer);
        eventBus.addListener(StorageSoundHandler::tick);
        eventBus.addListener(StorageSoundHandler::onWorldUnload);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
    }

    private static void onDrawScreen(ScreenEvent.Render.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block9: {
            block8: {
                mc = Minecraft.m_91087_();
                Screen gui = mc.f_91080_;
                if (!(gui instanceof AbstractContainerScreen)) break block8;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.f_91074_ != null) break block9;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.m_6262_();
        ItemStack held = menu.m_142621_();
        if (!held.m_41619_()) {
            Object object;
            Slot under = containerGui.getSlotUnderMouse();
            if (menu instanceof StorageContainerMenuBase) {
                StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)menu;
                object = storageMenu.realInventorySlots;
            } else {
                object = menu.f_38839_;
            }
            NonNullList slots = object;
            for (Slot s : slots) {
                Optional<StashResultAndTooltip> stashResultAndTooltip;
                ItemStack stack = s.m_7993_();
                if (!s.m_8010_((Player)mc.f_91074_) || stack.m_41619_() || (stashResultAndTooltip = ClientEventHandler.getStashResultAndTooltip(stack, held)).isEmpty()) continue;
                if (s == under) {
                    ClientEventHandler.renderSpecialTooltip(event, mc, containerGui, event.getGuiGraphics(), stashResultAndTooltip.get());
                    continue;
                }
                ClientEventHandler.renderStashSign(mc, containerGui, event.getGuiGraphics(), s, stack, stashResultAndTooltip.get().stashResult());
            }
        }
    }

    private static void renderStashSign(Minecraft mc, AbstractContainerScreen<?> containerGui, GuiGraphics guiGraphics, Slot s, ItemStack stack, IStashStorageItem.StashResult stashResult) {
        int color;
        int x = containerGui.getGuiLeft() + s.f_40220_;
        int y = containerGui.getGuiTop() + s.f_40221_;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 300.0f);
        int n = color = stashResult == IStashStorageItem.StashResult.MATCH_AND_SPACE ? ChatFormatting.GREEN.m_126665_() : 0xFFFF00;
        if (stack.m_41720_() instanceof IStashStorageItem) {
            guiGraphics.m_280488_(mc.f_91062_, "+", x + 10, y + 8, color);
        } else {
            guiGraphics.m_280488_(mc.f_91062_, "-", x + 1, y, color);
        }
        poseStack.m_85849_();
    }

    private static void renderSpecialTooltip(ScreenEvent.Render.Post event, Minecraft mc, AbstractContainerScreen<?> containerGui, GuiGraphics guiGraphics, StashResultAndTooltip stashResultAndTooltip) {
        int x = event.getMouseX();
        int y = event.getMouseY();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280677_(containerGui.f_96547_, Collections.singletonList(Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), stashResultAndTooltip.tooltip(), x, y);
        poseStack.m_85849_();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(ItemStack inInventory, ItemStack held) {
        Item item;
        if (inInventory.m_41613_() == 1 && (item = inInventory.m_41720_()) instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResultAndTooltip(inInventory, held, stashStorageItem);
        }
        item = held.m_41720_();
        if (item instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResultAndTooltip(held, inInventory, stashStorageItem);
        }
        return Optional.empty();
    }

    @NotNull
    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(ItemStack potentialStashStorage, ItemStack potentiallyStashable, IStashStorageItem stashStorageItem) {
        IStashStorageItem.StashResult stashResult = stashStorageItem.getItemStashable(potentialStashStorage, potentiallyStashable);
        if (stashResult == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return Optional.of(new StashResultAndTooltip(stashResult, stashStorageItem.getInventoryTooltip(potentialStashStorage)));
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        RecipeHelper.setLevel((Level)Minecraft.m_91087_().f_91073_);
    }

    private record StashResultAndTooltip(IStashStorageItem.StashResult stashResult, Optional<TooltipComponent> tooltip) {
    }
}

