/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.potionstudios.biomeswevegone.client.BWGSounds;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.features.BWGOverworldDefaultFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldTreePlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldVegationPlacedFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGPlacedFeatures;

class BWGOverworldBiomes {
    BWGOverworldBiomes() {
    }

    private static void addDefaultOverworldGeneration(BiomeGenerationSettings.Builder generationSettings) {
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generationSettings);
    }

    private static BiomeGenerationSettings.Builder setupDefaultOverworldGeneration(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        return generationSettings;
    }

    private static BiomeGenerationSettings.Builder setupDefaultOverworldGenerationWithoutLava(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        generationSettings.m_255308_(GenerationStep.Carving.AIR, Carvers.f_126848_);
        generationSettings.m_255308_(GenerationStep.Carving.AIR, Carvers.f_194741_);
        generationSettings.m_255308_(GenerationStep.Carving.AIR, Carvers.f_126849_);
        generationSettings.m_255155_(GenerationStep.Decoration.LAKES, MiscOverworldPlacements.f_195266_);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generationSettings);
        return generationSettings;
    }

    private static void addSpawn(MobSpawnSettings.Builder builder, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        builder.m_48376_(entityType.m_20674_(), new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
    }

    protected static Biome alliumShrubland(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ALLIUM_SHRUBLAND_FLOWERS);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.GIANT_ALLIUMS);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, BWGEntities.ODDION.get(), 5, 2, 10);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome amaranthGrassland(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.AMARANTH_GRASSLAND_FLOWERS);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addJacarandaBushes(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addSparseJacarandaTrees(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome araucariaSavanna(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126680_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126722_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_ARAUCARIA_TREES);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20466_, 1, 3, 4);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(temperature).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10860373).m_48043_(10860373).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome aspenBoreal(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ASPEN_TREES);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ORANGE_DAISY);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.5f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.6f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(11909994).m_48043_(14194987).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome pumpkinValley(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addMeadowShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.LARGE_PUMPKIN);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MEDIUM_PUMPKIN);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.SMALL_PUMPKIN);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.35f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(11513689).m_48043_(12435265).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome baobabSavanna(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126680_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126722_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BAOBAB_TREES);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20457_, 1, 2, 6);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20560_, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20466_, 1, 3, 4);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(temperature).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10860373).m_48043_(10860373).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome basaltBarrera(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.LARGE_BASALT_COLUMN);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.SMALL_BASALT_COLUMN);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BASALT_DELTA);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.85f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.75f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome bayou(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195222_);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BAYOU_TREES);
        BWGOverworldDefaultFeatures.addBWGSwampVegetation(generationSettings);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_217012_, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20489_, 25, 8, 8);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_215730_);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4815438).m_48037_(6717479).m_48045_(7375928).m_48043_(6337104).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome blackForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BLACK_FOREST_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.BLACK_ROSE);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)100, (int)25, (int)100, (boolean)false);
        float temperature = 0.45f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.65f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(5011004).m_48043_(0x228B22).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome canadianShield(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CANADIAN_SHIELD_TREES);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addSparseAspenTreesShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.HYDRANGEAS);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome crimsonTundra(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseRedOrangeSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20481_, 85, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20514_, 1, 1, 2);
        float temperature = 0.75f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.1f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6200521).m_48037_(6200521).m_48045_(13388072).m_48043_(13388072).m_48019_(12638463).m_48040_(0xC1CCCC).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01428f)).m_48023_((Holder)SoundEvents.f_12272_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome sakuraGrove(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_272148_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.WHITE_SAKURA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.YELLOW_SAKURA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.JAPANESE_ORCHID);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.SAKURA_PETALS);
        BWGOverworldDefaultFeatures.addFlowerPatches(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 5, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        float temperature = 0.7f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10999916).m_48043_(10999916).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome cikaWoods(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CIKA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.LARGE_PUMPKIN);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MEDIUM_PUMPKIN);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 0.35f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(13414235).m_48043_(13414235).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome coniferousForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean snowy) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CONIFER_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20479_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, snowy ? EntityType.f_20458_ : EntityType.f_20501_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20524_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20530_, 25, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20558_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 5, 1, 1);
        float temperature = snowy ? -0.5f : 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(5011004).m_48043_(0x228B22).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome cragGardens(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.CRAG_LAKE);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGPlacedFeatures.VINE_PROCESSOR);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGPlacedFeatures.LUSH_BLOCKS_PROCESSOR);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.CRAG_BAMBOO);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CRAG_BUSHES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.CRAG_LAKE_VEGETATION);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.GUIANA_SHIELD_TREES);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195219_);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20508_, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20505_, 2, 1, 1);
        float temperature = 0.95f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48021_(Musics.m_263184_((Holder)((Holder)BWGSounds.MUSIC_BIOME_CRAG_GARDENS.get()))).m_48034_(9230578).m_48037_(2835532).m_48045_(10145074).m_48043_(10145074).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome cypressSwamplands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195222_);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.CYPRESS_TREES);
        BWGOverworldDefaultFeatures.addBWGSwampVegetation(generationSettings);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_217012_, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20489_, 25, 8, 8);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_215730_);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(6337104).m_48043_(6337104).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome lushStacks(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = OverworldBiomes.m_254986_(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.LUSH_ROUNDED_ROCK);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195230_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195218_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195227_);
        BiomeDefaultFeatures.m_176850_((BiomeGenerationSettings.Builder)generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, BWGEntities.MAN_O_WAR.get(), 200, 50, 50);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnSettings, (int)10, (int)4);
        float temperature = 1.0f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4445678).m_48037_(270131).m_48045_(10275901).m_48043_(10275901).m_48037_(2835532).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome daciteRidges(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.DACITE_RIDGE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.HOLLY_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20520_, 12, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(9230578).m_48037_(2835532).m_48045_(5011004).m_48043_(0x228B22).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome daciteShore(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20520_, 12, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(9230578).m_48037_(2835532).m_48045_(5011004).m_48043_(0x228B22).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome atacamaOutback(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ATACAMA_OUTBACK_VEGETATION);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnSettings);
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(2.0f).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6200521).m_48037_(6200521).m_48019_(12815488).m_48040_(12815488).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome windsweptDesert(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.WINDSWEPT_BOULDER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.WINDSWEPT_DESERT_VEGETATION);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnSettings);
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(2.0f).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6200521).m_48037_(6200521).m_48019_(12815488).m_48040_(12815488).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome ebonyWoods(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.EBONY_TREES);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addHorseWeed(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(5406551).m_48043_(6589494).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome enchantedTangle(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198927_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198931_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ENCHANTED_TREES);
        BWGOverworldDefaultFeatures.addFlowerPatches(generationSettings);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.CYAN_ROSE);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20520_, 10, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20510_, 15, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20555_, 12, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20557_, 10, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20505_, 10, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20508_, 40, 1, 2);
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20508_, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20505_, 2, 1, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20507_, 1, 1, 2);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10003745).m_48043_(11898572).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48029_(new AmbientParticleSettings((ParticleOptions)BWGParticles.BOREALIS_GLINT.get(), 0.0015f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome frostedTaiga(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BLUE_SPRUCE_TREES);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addIris(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome temperateGrove(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195449_);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.TEMPERATE_GROVE_TREES);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.BISTORT);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 0.75f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(11190111).m_48043_(11190111).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome jacarandaJungle(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198927_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.JACARANDA_TREES);
        BWGOverworldDefaultFeatures.addJacarandaBushes(generationSettings);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 5, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 0.95f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10145074).m_48043_(14180771).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome whiteMangroveMarshes(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSwampDelta(generationSettings);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.OAK_TREES_SWAMP);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195417_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195455_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195461_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195466_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195412_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195413_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195222_);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.MANGROVE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MANGROVE_SWAMP_WATER_VEGETATION);
        BWGOverworldDefaultFeatures.addCattails(generationSettings);
        BWGOverworldDefaultFeatures.addLeatherFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addMudDisks(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_217012_, 10, 2, 5);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20489_, 25, 8, 8);
        Music music = Musics.m_263184_((Holder)SoundEvents.f_215730_);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(5878398).m_48037_(2047788).m_48045_(5737549).m_48043_(5737549).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome mapleTaiga(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.MAPLE_TAIGA_TREES);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addSparseAspenTreesShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(6586199).m_48043_(14206262).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome coconinoMeadow(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195455_);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195449_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_MEADOW_TREES);
        BWGOverworldDefaultFeatures.addMeadowShrubs(generationSettings);
        BWGOverworldDefaultFeatures.addCloverFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addTulips(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ALPINE_BELLFLOWER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PINK_DAFFODIL);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(6530407).m_48043_(5999709).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome deadSea(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.DRIPSTONE_ROUNDED_ROCK);
        BWGOverworldBiomes.addVegetal(generationSettings, (ResourceKey<PlacedFeature>)AquaticPlacements.f_195219_);
        BiomeDefaultFeatures.m_176863_((BiomeGenerationSettings.Builder)generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)true);
        float temperature = 2.0f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(9230578).m_48037_(2835532).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome mojaveDesert(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addBeachGrass(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.YUCCA_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.MOJAVE_DESERT_VEGETATION);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)109, (int)1, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20458_, 80, 4, 4);
        float temperature = 2.0f;
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(temperature).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome orchard(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ORCHARD_TREES);
        BWGOverworldDefaultFeatures.addCloverFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addCloverPatches(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.LOLLIPOP_FLOWERS);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.YELLOW_DAFFODIL);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.WHITE_ALLIUMS);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10210365).m_48043_(10210365).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome prairie(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.PRAIRIE_SHRUBS);
        BWGOverworldDefaultFeatures.addSparseOakTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PRAIRIE_GRASS);
        BWGOverworldDefaultFeatures.addCaliforniaPoppy(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.2f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10003745).m_48043_(10003745).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome rainbowBeach(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addBeachGrass(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        float temperature = 0.85f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.75f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4566514).m_48037_(267827).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome overgrowthWoodlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.OVERGROWTH_WOODLANDS_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BWG_OAK_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BWG_BIRCH_TREES);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PINK_DAFFODIL);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.HORSEWEED);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48043_(7110705).m_48045_(7110705).m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(9358480).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_175833_, 5.0E-4f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome redRockValley(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addDefaultOverworldGeneration(generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addOrangeTerracottaBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20479_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20458_, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20530_, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20524_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20558_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 5, 1, 1);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.1f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(0xA5A56A).m_48043_(0xA5A56A).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome redwoodThicket(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPRUCE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.REDWOOD_TREES);
        BWGOverworldDefaultFeatures.addLeafPile(generationSettings);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.9f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(8896351).m_48043_(8896351).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome roseFields(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addRoseFieldSpruceTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ROSE_FIELD_FLOWERS);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(8231780).m_48043_(8231780).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome shatteredGlacier(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.WINTER_ROSE);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20481_, 80, 4, 4);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(1.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6200521).m_48037_(6200521).m_48045_(15834405).m_48043_(15834405).m_48019_(12638463).m_48040_(0xC1CCCC).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01428f)).m_48023_((Holder)SoundEvents.f_12272_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome firecrackerChaparral(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseOakTrees(generationSettings);
        BWGOverworldDefaultFeatures.addShrub(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FIRECRACKER_SHRUBS);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20457_, 5, 2, 6);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20560_, 1, 1, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        float temperature = 2.0f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(9874031).m_48043_(7048739).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome sierraBadlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126816_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126704_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126747_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldDefaultFeatures.addOrangeTerracottaBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addFirecrackerBush(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20479_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20458_, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20530_, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20524_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20558_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 5, 1, 1);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.1f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(0xA5A56A).m_48043_(0xA5A56A).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome ruggedBadlands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126755_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addPatchBeachGrassNoise(generationSettings);
        BWGOverworldDefaultFeatures.addPaloVerdeTrees(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.RUGGED_BADLANDS_VEGETATION);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20479_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20458_, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20530_, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20524_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20558_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20518_, 1, 1, 2);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.1f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(0xA5A56A).m_48043_(0xA5A56A).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome ironwoodGour(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126680_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126722_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.IRONWOOD_PLATEAU_PATCH_GRASS_WORLD_SURFACE);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSages(generationSettings);
        BWGOverworldDefaultFeatures.addCaliforniaPoppy(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.IRONWOOD_PLATEAU_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.IRONWOOD_GROUND_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.IRONWOOD_PLATEAU_GLOW_LICHEN);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20479_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20458_, 95, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20530_, 5, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20524_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20558_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 5, 1, 1);
        float temperature = 1.2f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.1f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(0xA5A56A).m_48043_(0xA5A56A).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome erodedBorealis(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOREALIS_ICE_SHARPENED_SPIKE);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.BLUE_SPRUCE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.HOLLY_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addWinterSucculent(generationSettings);
        BWGOverworldDefaultFeatures.addWinterCyclamen(generationSettings);
        BWGOverworldDefaultFeatures.addSnowdrops(generationSettings);
        BWGOverworldDefaultFeatures.addWinterScilla(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_217014_, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 3, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20481_, 85, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20514_, 1, 1, 2);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.3f).m_47603_(new BiomeSpecialEffects.Builder().m_48021_(Musics.m_263184_((Holder)((Holder)BWGSounds.MUSIC_BIOME_ERODED_BOREALIS.get()))).m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48029_(new AmbientParticleSettings((ParticleOptions)BWGParticles.BOREALIS_GLINT.get(), 0.002f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome skyrisVale(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SKYRIS_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.SPARSE_BLUE_SPRUCE_TREES);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.FOXGLOVES);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20479_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20524_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20526_, 100, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20566_, 10, 1, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 5, 1, 1);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(6409356).m_48043_(7135854).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome howlingPeaks(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126718_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.BOULDER);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ORANGE_BIRCH_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.YELLOW_BIRCH_TREES);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addWinterCyclamen(generationSettings);
        BWGOverworldDefaultFeatures.addSnowdrops(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 10, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20481_, 80, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_147035_, 5, 1, 3);
        float temperature = -0.5f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(1.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(6200521).m_48037_(6200521).m_48045_(15834405).m_48043_(15834405).m_48019_(12638463).m_48040_(0xC1CCCC).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01428f)).m_48023_((Holder)SoundEvents.f_12272_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome fragmentJungle(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126818_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198927_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198931_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGPlacedFeatures.STONE_PILLAR);
        BWGOverworldBiomes.addRawGeneration(generationSettings, BWGOverworldVegationPlacedFeatures.PATCH_GRASS_JUNGLE_WORLD_SURFACE);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FRAGMENT_JUNGLE_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.RAINFOREST_TREES);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldDefaultFeatures.addProteaFlowers(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.JUNGLE_FLOWERS_PILLAR);
        BWGOverworldDefaultFeatures.addMossyStoneBoulder(generationSettings);
        BWGOverworldDefaultFeatures.addRockyStoneBoulder(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.DELPHINIUM);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.DELPHINIUM_PILLAR);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20508_, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20555_, 10, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20505_, 2, 1, 1);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10145074).m_48043_(10145074).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome tropicalRainforest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGeneration(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198927_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126722_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_198931_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.RAINFOREST_TREES);
        BWGOverworldDefaultFeatures.addBWGTropicFlowers(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.DELPHINIUM);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20508_, 40, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20505_, 2, 1, 1);
        float temperature = 0.95f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.9f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(10145074).m_48043_(10145074).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome weepingWitchForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addSparseSpruceTrees(generationSettings);
        BWGOverworldDefaultFeatures.addSparseAspenTreesShrubs(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.HAZEL_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnSettings);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 8, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_217014_, 1, 1, 2);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20495_, 6, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20554_, 50, 2, 4);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(12435265).m_48043_(12435265).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome forgottenForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BWGOverworldDefaultFeatures.addHugeMushrooms(generationSettings);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldDefaultFeatures.addOakBushes(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FORGOTTEN_FOREST_TREES);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.FLORUS_TREES);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addRose(generationSettings);
        BWGOverworldDefaultFeatures.addBlueRoseBush(generationSettings);
        BWGOverworldDefaultFeatures.addFairySlipper(generationSettings);
        BWGOverworldDefaultFeatures.addWhitePuffball(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.ANGELICA);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.PINK_DAFFODIL);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.HORSEWEED);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_217014_, 1, 1, 1);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20517_, 4, 2, 3);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20452_, 8, 2, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20554_, 90, 2, 3);
        float temperature = 0.8f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48021_(Musics.m_263184_((Holder)((Holder)BWGSounds.MUSIC_BIOME_FORGOTTEN_FOREST.get()))).m_48034_(4159204).m_48037_(329011).m_48045_(8034667).m_48043_(6530362).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48029_(new AmbientParticleSettings((ParticleOptions)BWGParticles.FIREFLY.get(), 0.0019f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static Biome zelkovaForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder generationSettings = BWGOverworldBiomes.setupDefaultOverworldGenerationWithoutLava(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldTreePlacedFeatures.ZELKOVA_TREES);
        BWGOverworldDefaultFeatures.addBlueBerryBush(generationSettings);
        BWGOverworldDefaultFeatures.addLushBlueBerryBush(generationSettings);
        BWGOverworldBiomes.addVegetal(generationSettings, BWGOverworldVegationPlacedFeatures.KOVAN_FLOWER);
        BWGOverworldDefaultFeatures.addAnemones(generationSettings);
        BWGOverworldDefaultFeatures.addCrocus(generationSettings);
        BWGOverworldDefaultFeatures.addBWGMushrooms(generationSettings);
        MobSpawnSettings.Builder spawnSettings = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnSettings);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnSettings, (int)95, (int)5, (int)100, (boolean)false);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20499_, 5, 4, 4);
        BWGOverworldBiomes.addSpawn(spawnSettings, EntityType.f_20549_, 10, 8, 8);
        float temperature = 0.25f;
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48045_(5416309).m_48043_(5416309).m_48019_(12638463).m_48040_(OverworldBiomes.m_194843_((float)temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    private static void addVegetal(BiomeGenerationSettings.Builder builder, ResourceKey<PlacedFeature> feature) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
    }

    private static void addRawGeneration(BiomeGenerationSettings.Builder builder, ResourceKey<PlacedFeature> feature) {
        builder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, feature);
    }
}

