/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.wood;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.world.entity.boats.BWGBoatEntity;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.item.boat.BWGBoatItem;
import net.potionstudios.biomeswevegone.world.level.block.plants.PottedBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGCraftingTable;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGCeilingHangingSignBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGStandingSignBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGWallHangingSignBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.sign.BWGWallSignBlock;
import org.jetbrains.annotations.Nullable;

public class BWGWoodSet {
    private static final ArrayList<BWGWoodSet> woodSets = new ArrayList();
    private final String name;
    private final WoodType woodType;
    private final Supplier<Block> planks;
    private final Supplier<SlabBlock> slab;
    private final Supplier<StairBlock> stairs;
    private final LogStem logstemEnum;
    private final Supplier<RotatedPillarBlock> logstem;
    private final Supplier<RotatedPillarBlock> strippedLogStem;
    private final TagKey<Block> logBlockTag;
    private final TagKey<Item> logItemTag;
    private final Supplier<RotatedPillarBlock> wood;
    private final Supplier<RotatedPillarBlock> strippedWood;
    private final Supplier<StandingSignBlock> sign;
    private final Supplier<WallSignBlock> wallSign;
    private final Supplier<SignItem> signItem;
    private final Supplier<CeilingHangingSignBlock> hangingSign;
    private final Supplier<WallHangingSignBlock> wallHangingSign;
    private final Supplier<HangingSignItem> hangingSignItem;
    private final Supplier<PressurePlateBlock> pressurePlate;
    private final Supplier<TrapDoorBlock> trapdoor;
    private final Supplier<ButtonBlock> button;
    private final Supplier<FenceGateBlock> fenceGate;
    private final Supplier<FenceBlock> fence;
    private final Supplier<DoorBlock> door;
    private final Supplier<Block> bookshelf;
    private final Supplier<CraftingTableBlock> craftingTable;
    @Nullable
    private PottedBlock sapling = null;
    @Nullable
    private Supplier<LeavesBlock> leaves = null;
    private final Supplier<Item> boatItem;
    private final Supplier<Item> chestBoatItem;
    private BlockFamily family = null;

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, LogStem logstem, @Nullable Supplier<AbstractTreeGrower> saplingGrower, boolean leaves, boolean glowLeaves, @Nullable TagKey<Block> saplingPlantAbleOn) {
        this.woodType = PlatformHandler.PLATFORM_HANDLER.createWoodType(blockSetType.f_271253_(), blockSetType);
        this.name = blockSetType.f_271253_().replace("biomeswevegone:", "");
        this.planks = BWGWood.registerBlockItem(this.name + "_planks", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_()));
        this.slab = BWGWood.registerBlockItem(this.name + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_()));
        this.stairs = BWGWood.registerBlockItem(this.name + "_stairs", () -> new StairBlock(this.planks.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.planks.get()))));
        this.logstemEnum = logstem;
        this.logstem = BWGWood.registerBlockItem(this.name + "_" + logstem.getName(), () -> Blocks.m_284204_((MapColor)mapColor, (MapColor)mapColor));
        this.strippedLogStem = BWGWood.registerBlockItem("stripped_" + this.name + "_" + logstem.getName(), () -> Blocks.m_284204_((MapColor)mapColor, (MapColor)mapColor));
        this.wood = BWGWood.registerBlockItem(this.name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()));
        this.strippedWood = BWGWood.registerBlockItem("stripped_" + this.name + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()));
        this.sign = BWGWood.register(this.name + "_sign", () -> new BWGStandingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.logstem.get().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_278183_(), this.woodType));
        this.wallSign = BWGWood.register(this.name + "_wall_sign", () -> new BWGWallSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.logstem.get().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_60916_((Block)this.sign.get()).m_278183_(), this.woodType));
        this.signItem = BWGItems.register(this.name + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)this.sign.get(), (Block)this.wallSign.get()));
        BWGWood.WOOD_BLOCK_ITEMS.add(this.signItem);
        this.hangingSign = BWGWood.register(this.name + "_hanging_sign", () -> new BWGCeilingHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.logstem.get().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_278183_(), this.woodType));
        this.wallHangingSign = BWGWood.register(this.name + "_wall_hanging_sign", () -> new BWGWallHangingSignBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_60916_((Block)this.hangingSign.get()).m_278183_(), this.woodType));
        this.hangingSignItem = BWGItems.register(this.name + "_hanging_sign", () -> new HangingSignItem((Block)this.hangingSign.get(), (Block)this.wallHangingSign.get(), new Item.Properties().m_41487_(16)));
        BWGWood.WOOD_BLOCK_ITEMS.add(this.hangingSignItem);
        this.pressurePlate = BWGWood.registerBlockItem(this.name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_284310_().m_284180_(this.logstem.get().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(0.5f).m_278183_().m_278166_(PushReaction.DESTROY), this.woodType.f_271340_()));
        this.trapdoor = BWGWood.registerBlockItem(this.name + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_60922_(Blocks::m_50778_).m_278183_(), this.woodType.f_271340_()));
        this.button = BWGWood.registerBlockItem(this.name + "_button", () -> Blocks.m_278156_((BlockSetType)this.woodType.f_271340_(), (FeatureFlag[])new FeatureFlag[0]));
        this.fenceGate = BWGWood.registerBlockItem(this.name + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.planks.get().m_284356_()).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_278183_(), this.woodType));
        this.fence = BWGWood.registerBlockItem(this.name + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.planks.get().m_284356_()).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_278183_().m_60918_(SoundType.f_56736_)));
        this.door = BWGWood.registerBlockItem(this.name + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(this.planks.get().m_284356_()).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_278183_().m_278166_(PushReaction.DESTROY), this.woodType.f_271340_()));
        this.bookshelf = BWGWood.registerBlockItem(this.name + "_bookshelf", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50078_).m_284180_(mapColor)));
        this.craftingTable = BWGWood.registerBlockItem(this.name + "_crafting_table", () -> new BWGCraftingTable(mapColor));
        if (saplingGrower != null) {
            this.sapling = BWGWood.createSapling(this.name, saplingGrower, saplingPlantAbleOn);
        }
        if (leaves) {
            this.leaves = glowLeaves ? BWGWood.registerBlockItem(this.name + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60953_(level -> 8).m_284180_(mapColor))) : BWGWood.registerBlockItem(this.name + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_284180_(mapColor)));
        }
        this.boatItem = BWGWood.registerItem(this.name + "_boat", () -> new BWGBoatItem(false, BWGBoatEntity.Type.byName(this.name), new Item.Properties().m_41487_(1)));
        this.chestBoatItem = BWGWood.registerItem(this.name + "_chest_boat", () -> new BWGBoatItem(true, BWGBoatEntity.Type.byName(this.name), new Item.Properties().m_41487_(1)));
        this.logBlockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)BiomesWeveGone.id(this.name + "_logs"));
        this.logItemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)BiomesWeveGone.id(this.name + "_logs"));
        woodSets.add(this);
    }

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, @Nullable Supplier<AbstractTreeGrower> saplingGrower, boolean leaves) {
        this(blockSetType, mapColor, LogStem.LOG, saplingGrower, leaves, false, (TagKey<Block>)BlockTags.f_144274_);
    }

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, @Nullable Supplier<AbstractTreeGrower> saplingGrower, boolean leaves, TagKey<Block> saplingPlantAbleOn) {
        this(blockSetType, mapColor, LogStem.LOG, saplingGrower, leaves, false, saplingPlantAbleOn);
    }

    protected BWGWoodSet(BlockSetType blockSetType, MapColor mapColor, @Nullable Supplier<AbstractTreeGrower> saplingGrower, boolean leaves, boolean glowLeaves) {
        this(blockSetType, mapColor, LogStem.LOG, saplingGrower, leaves, glowLeaves, (TagKey<Block>)BlockTags.f_144274_);
    }

    protected BWGWoodSet(String name, MapColor mapColor, @Nullable Supplier<AbstractTreeGrower> saplingGrower) {
        this(BlockSetType.m_272115_((BlockSetType)new BlockSetType(name)), mapColor, saplingGrower, true);
    }

    protected BWGWoodSet(String name, MapColor mapColor, @Nullable Supplier<AbstractTreeGrower> saplingGrower, TagKey<Block> saplingPlantAbleOn) {
        this(BlockSetType.m_272115_((BlockSetType)new BlockSetType(name)), mapColor, saplingGrower, true, saplingPlantAbleOn);
    }

    protected BWGWoodSet(String name, MapColor mapColor, @Nullable Supplier<AbstractTreeGrower> saplingGrower, boolean glowLeaves) {
        this(BlockSetType.m_272115_((BlockSetType)new BlockSetType(name)), mapColor, saplingGrower, true, glowLeaves);
    }

    public String name() {
        return this.name;
    }

    public WoodType woodType() {
        return this.woodType;
    }

    public Block planks() {
        return this.planks.get();
    }

    public SlabBlock slab() {
        return this.slab.get();
    }

    public StairBlock stairs() {
        return this.stairs.get();
    }

    public RotatedPillarBlock logstem() {
        return this.logstem.get();
    }

    public RotatedPillarBlock strippedLogStem() {
        return this.strippedLogStem.get();
    }

    public TagKey<Block> logBlockTag() {
        return this.logBlockTag;
    }

    public TagKey<Item> logItemTag() {
        return this.logItemTag;
    }

    public RotatedPillarBlock wood() {
        return this.wood.get();
    }

    public RotatedPillarBlock strippedWood() {
        return this.strippedWood.get();
    }

    public StandingSignBlock sign() {
        return this.sign.get();
    }

    public WallSignBlock wallSign() {
        return this.wallSign.get();
    }

    public SignItem signItem() {
        return this.signItem.get();
    }

    public CeilingHangingSignBlock hangingSign() {
        return this.hangingSign.get();
    }

    public WallHangingSignBlock wallHangingSign() {
        return this.wallHangingSign.get();
    }

    public HangingSignItem hangingSignItem() {
        return this.hangingSignItem.get();
    }

    public PressurePlateBlock pressurePlate() {
        return this.pressurePlate.get();
    }

    public TrapDoorBlock trapdoor() {
        return this.trapdoor.get();
    }

    public ButtonBlock button() {
        return this.button.get();
    }

    public FenceGateBlock fenceGate() {
        return this.fenceGate.get();
    }

    public FenceBlock fence() {
        return this.fence.get();
    }

    public DoorBlock door() {
        return this.door.get();
    }

    public Block bookshelf() {
        return this.bookshelf.get();
    }

    public CraftingTableBlock craftingTable() {
        return this.craftingTable.get();
    }

    @Nullable
    public PottedBlock sapling() {
        if (this.sapling != null) {
            return this.sapling;
        }
        return null;
    }

    @Nullable
    public LeavesBlock leaves() {
        if (this.leaves != null) {
            return this.leaves.get();
        }
        return null;
    }

    public Supplier<Item> boatItem() {
        return this.boatItem;
    }

    public Supplier<Item> chestBoatItem() {
        return this.chestBoatItem;
    }

    public ArrayList<ItemLike> itemList() {
        ArrayList<Block> items = new ArrayList<Block>(List.of(this.planks.get(), (Block)this.slab.get(), (Block)this.stairs.get(), (Block)this.logstem.get(), (Block)this.strippedLogStem.get(), (Block)this.wood.get(), (Block)this.strippedWood.get(), (Block)this.sign.get(), (Block)this.hangingSign.get(), (Block)this.pressurePlate.get(), (Block)this.trapdoor.get(), (Block)this.button.get(), (Block)this.fenceGate.get(), (Block)this.fence.get(), (Block)this.door.get(), this.bookshelf.get(), (Block)this.craftingTable.get()));
        if (this.leaves != null) {
            items.add((Block)((ItemLike)this.leaves.get()));
        }
        return items;
    }

    public void makeFamily() {
        this.family = BlockFamilies.m_175935_((Block)this.planks.get()).m_175963_((Block)this.button.get()).m_175982_((Block)this.fence.get()).m_175984_((Block)this.fenceGate.get()).m_175990_((Block)this.pressurePlate.get()).m_175965_((Block)this.sign.get(), (Block)this.wallSign.get()).m_175986_((Block)this.slab.get()).m_175988_((Block)this.stairs.get()).m_175980_((Block)this.door.get()).m_175994_((Block)this.trapdoor.get()).m_175968_("wooden").m_175973_("has_planks").m_175962_();
    }

    public BlockFamily family() {
        return this.family;
    }

    public static ArrayList<BWGWoodSet> woodsets() {
        return woodSets;
    }

    public LogStem logStemEnum() {
        return this.logstemEnum;
    }

    public static enum LogStem {
        LOG("log"),
        STEM("stem");

        private final String name;

        private LogStem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

