/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.client.BWGSounds;
import net.potionstudios.biomeswevegone.world.entity.BWGEntities;
import net.potionstudios.biomeswevegone.world.item.custom.CampfireExplodingBlockItem;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;

public class BWGItems {
    public static final ArrayList<Supplier<? extends Item>> ITEMS = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> NO_LANG_ITEMS = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> SIMPLE_ITEMS = new ArrayList();
    public static final Supplier<Item> BWG_LOGO = BWGItems.register("bwg_logo", () -> new Item(new Item.Properties()));
    public static final Supplier<SpawnEggItem> MAN_O_WAR_SPAWN_EGG = BWGItems.registerSpawnEgg("man_o_war_spawn_egg", BWGEntities.MAN_O_WAR::get, new Color(210, 166, 246).getRGB(), new Color(199, 165, 104).getRGB());
    public static final Supplier<SpawnEggItem> PUMPKIN_WARDEN_SPAWN_EGG = BWGItems.registerSpawnEgg("pumpkin_warden_spawn_egg", BWGEntities.PUMPKIN_WARDEN::get, new Color(79, 57, 46).getRGB(), new Color(192, 106, 5).getRGB());
    public static final Supplier<SpawnEggItem> ODDION_SPAWN_EGG = BWGItems.registerSpawnEgg("oddion_spawn_egg", BWGEntities.ODDION::get, new Color(199, 165, 104).getRGB(), new Color(210, 166, 246).getRGB());
    public static final Supplier<MobBucketItem> MAN_O_WAR_BUCKET = BWGItems.registerMobBucket("man_o_war_bucket", BWGEntities.MAN_O_WAR::get, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_);
    public static final Supplier<Item> CATTAIL_SPROUT = BWGItems.registerItemNoLang("cattail_sprout", () -> new CampfireExplodingBlockItem(BWGBlocks.CATTAIL_SPROUT, new Item.Properties()));
    public static final Supplier<Item> BAOBAB_FRUIT = BWGItems.registerSimpleItem("baobab_fruit", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.35f).m_38767_())));
    public static final Supplier<Item> YUCCA_FRUIT = BWGItems.registerSimpleItem("yucca_fruit", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.35f).m_38767_())));
    public static final Supplier<Item> COOKED_YUCCA_FRUIT = BWGItems.registerSimpleItem("cooked_yucca_fruit", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.4f).m_38767_())));
    public static final Supplier<Item> GREEN_APPLE = BWGItems.registerSimpleItem("green_apple", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.35f).m_38767_())));
    public static final Supplier<Item> GREEN_APPLE_PIE = BWGItems.registerSimpleItem("green_apple_pie", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38762_(new MobEffectInstance(MobEffects.f_19598_, 200, 0), 1.0f).m_38767_())));
    public static final Supplier<Item> BLUEBERRIES = BWGItems.registerSimpleItem("blueberries", () -> new ItemNameBlockItem((Block)BWGBlocks.BLUEBERRY_BUSH.get(), new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).m_38767_())));
    public static final Supplier<Item> BLUEBERRY_PIE = BWGItems.registerSimpleItem("blueberry_pie", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(6).m_38758_(0.3f).m_38762_(new MobEffectInstance(MobEffects.f_19596_, 200, 0), 1.0f).m_38767_())));
    public static final Supplier<Item> ODDION_BULB = BWGItems.registerSimpleItem("oddion_bulb", () -> new ItemNameBlockItem((Block)BWGBlocks.ODDION_CROP.get(), new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.35f).m_38767_())));
    public static final Supplier<Item> COOKED_ODDION_BULB = BWGItems.registerSimpleItem("cooked_oddion_bulb", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(5).m_38758_(0.5f).m_38767_())));
    public static final Supplier<Item> ALLIUM_ODDION_SOUP = BWGItems.registerSimpleItem("allium_oddion_soup", () -> new BowlFoodItem(new Item.Properties().m_41487_(1).m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(1.0f).m_38767_())));
    public static final Supplier<Item> BLOOMING_ODDION = BWGItems.registerSimpleItem("blooming_oddion", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(1.2f).m_38767_())));
    public static final Supplier<Item> WHITE_PUFFBALL_SPORES = BWGItems.registerSimpleItem("white_puffball_spores", () -> new ItemNameBlockItem(BWGBlocks.WHITE_PUFFBALL.getBlock(), new Item.Properties()));
    public static final Supplier<Item> WHITE_PUFFBALL_CAP = BWGItems.registerSimpleItem("white_puffball_cap", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(0.2f).m_38767_())));
    public static final Supplier<Item> COOKED_WHITE_PUFFBALL_CAP = BWGItems.registerSimpleItem("cooked_white_puffball_cap", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(3).m_38758_(0.6f).m_38767_())));
    public static final Supplier<Item> WHITE_PUFFBALL_STEW = BWGItems.registerSimpleItem("white_puffball_stew", () -> new BowlFoodItem(new Item.Properties().m_41487_(1).m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(1.0f).m_38767_())));
    public static final Supplier<Item> ALOE_VERA_JUICE = BWGItems.registerSimpleItem("aloe_vera_juice", () -> new HoneyBottleItem(new Item.Properties().m_41495_(Items.f_42590_).m_41487_(16).m_41489_(new FoodProperties.Builder().m_38760_(3).m_38758_(1.0f).m_38767_())));
    public static final Supplier<PlaceOnWaterBlockItem> TINY_LILY_PADS = BWGItems.registerItemNoLang("tiny_lily_pads", () -> new PlaceOnWaterBlockItem((Block)BWGBlocks.TINY_LILY_PADS.get(), new Item.Properties()));
    public static final Supplier<PlaceOnWaterBlockItem> FLOWERING_TINY_LILY_PADS = BWGItems.registerItemNoLang("flowering_tiny_lily_pads", () -> new PlaceOnWaterBlockItem((Block)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), new Item.Properties()));
    public static final Supplier<PlaceOnWaterBlockItem> WATER_SILK = BWGItems.registerItemNoLang("water_silk", () -> new PlaceOnWaterBlockItem(BWGBlocks.WATER_SILK.get(), new Item.Properties()));
    public static final Supplier<RecordItem> MUSIC_DISC_PIXIE_CLUB = BWGItems.registerSimpleItemNoLang("music_disc_pixie_club", PlatformHandler.PLATFORM_HANDLER.createRecordItem(4, BWGSounds.MUSIC_DISC_PIXIE_CLUB, 213));

    private static Supplier<SpawnEggItem> registerSpawnEgg(String id, Supplier<EntityType<? extends Mob>> entity, int backgroundColor, int highlightColor) {
        Supplier<SpawnEggItem> supplier = PlatformHandler.PLATFORM_HANDLER.createSpawnEgg(entity, backgroundColor, highlightColor);
        supplier = BWGItems.registerItem(id, supplier);
        SIMPLE_ITEMS.add(supplier);
        return supplier;
    }

    private static Supplier<MobBucketItem> registerMobBucket(String id, Supplier<EntityType<? extends Mob>> entity, Supplier<Fluid> fluid, Supplier<SoundEvent> sound) {
        Supplier<MobBucketItem> supplier = PlatformHandler.PLATFORM_HANDLER.createMobBucket(entity, fluid, sound);
        supplier = BWGItems.registerItem(id, supplier);
        SIMPLE_ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerSimpleItem(String id, Supplier<I> item) {
        Supplier<I> supplier = BWGItems.registerItem(id, item);
        SIMPLE_ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerSimpleItemNoLang(String id, Supplier<I> item) {
        Supplier<I> supplier = BWGItems.register(id, item);
        SIMPLE_ITEMS.add(supplier);
        NO_LANG_ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerItem(String id, Supplier<I> item) {
        Supplier<I> supplier = BWGItems.register(id, item);
        ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> registerItemNoLang(String id, Supplier<I> item) {
        Supplier<I> supplier = BWGItems.register(id, item);
        NO_LANG_ITEMS.add(supplier);
        return supplier;
    }

    public static <I extends Item> Supplier<I> register(String id, Supplier<I> item) {
        return PlatformHandler.PLATFORM_HANDLER.register(BuiltInRegistries.f_257033_, id, item);
    }

    public static void items() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone items");
    }
}

