/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.util;

import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public final class UnsafeBoundingBox {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public UnsafeBoundingBox() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public UnsafeBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public int minX() {
        return this.minX;
    }

    public int minY() {
        return this.minY;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxY() {
        return this.maxY;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public void encapsulate(Vec3i pos) {
        this.minX = Math.min(this.minX, pos.m_123341_());
        this.minY = Math.min(this.minY, pos.m_123342_());
        this.minZ = Math.min(this.minZ, pos.m_123343_());
        this.maxX = Math.max(this.maxX, pos.m_123341_());
        this.maxY = Math.max(this.maxY, pos.m_123342_());
        this.maxZ = Math.max(this.maxZ, pos.m_123343_());
    }

    public boolean valid() {
        return this.minX <= this.maxX || this.minY <= this.maxY || this.minZ <= this.maxZ;
    }

    public BoundingBox toBoundingBox() {
        return new BoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnsafeBoundingBox that = (UnsafeBoundingBox)obj;
        return this.minX == that.minX && this.minY == that.minY && this.minZ == that.minZ && this.maxX == that.maxX && this.maxY == that.maxY && this.maxZ == that.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public String toString() {
        return "UnsafeBoundingBox[minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + "]";
    }
}

