/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge.client;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.potionstudios.biomeswevegone.client.BiomesWeveGoneClient;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.client.particle.particles.FallingLeafParticle;
import net.potionstudios.biomeswevegone.client.particle.particles.FireFlyParticle;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;

@OnlyIn(value=Dist.CLIENT)
public class BiomesWeveGoneClientForge {
    public static void init(IEventBus eventBus) {
        eventBus.addListener(BiomesWeveGoneClientForge::forgeClientSetup);
        eventBus.addListener(event -> BiomesWeveGoneClient.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1)));
        eventBus.addListener(event -> BiomesWeveGoneClient.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1)));
        eventBus.addListener(BiomesWeveGoneClientForge::registerParticles);
        eventBus.addListener(event -> BiomesWeveGoneClient.registerLayerDefinitions((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1)));
        eventBus.addListener(BiomesWeveGoneClientForge::registerColorChangingBlocks);
        eventBus.addListener(BiomesWeveGoneClientForge::registerItemColorHandlers);
    }

    private static void forgeClientSetup(FMLClientSetupEvent event) {
        BiomesWeveGoneClient.onInitialize(Minecraft.m_91087_());
    }

    private static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)BWGParticles.FIREFLY.get(), FireFlyParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.BOREALIS_GLINT.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.WITCH_HAZEL_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.WHITE_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.YELLOW_SAKURA_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.RED_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.SILVER_MAPLE_LEAVES.get(), FallingLeafParticle.Provider::new);
        event.registerSpriteSet((ParticleType)BWGParticles.IRONWOOD_LEAVES.get(), FallingLeafParticle.Provider::new);
    }

    private static void registerColorChangingBlocks(RegisterColorHandlersEvent.Block event) {
        event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)view, (BlockPos)pos) : GrassColor.m_276205_(), new Block[]{(Block)BWGBlocks.FLOWER_PATCH.get(), (Block)BWGBlocks.TINY_LILY_PADS.get(), (Block)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (Block)BWGBlocks.OVERGROWN_DACITE.get(), (Block)BWGBlocks.OVERGROWN_STONE.get(), (Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), (Block)BWGBlocks.WHITE_SAKURA_PETALS.get(), (Block)BWGBlocks.YELLOW_SAKURA_PETALS.get()});
        event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)view, (BlockPos)pos) : FoliageColor.m_46107_((double)0.5, (double)1.0), new Block[]{(Block)BWGBlocks.CLOVER_PATCH.get(), (Block)BWGBlocks.LEAF_PILE.get(), (Block)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (Block)BWGWood.YUCCA_LEAVES.get(), (Block)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (Block)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves()});
        event.register((state, view, pos, tintIndex) -> BiomesWeveGoneClient.getBorealisIceColor(Objects.requireNonNullElse(pos, BlockPos.f_121853_)), new Block[]{(Block)BWGBlocks.BOREALIS_ICE.get(), (Block)BWGBlocks.PACKED_BOREALIS_ICE.get()});
        event.register((state, view, pos, tintIndex) -> view != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)view, (BlockPos)pos) : -1, new Block[]{BWGBlocks.CARVED_BARREL_CACTUS.get()});
    }

    private static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            Block block = ((BlockItem)stack.m_41720_()).m_40614_();
            return event.getBlockColors().m_92577_(block.m_49966_(), null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)BWGBlocks.TINY_LILY_PADS.get(), (ItemLike)BWGBlocks.FLOWERING_TINY_LILY_PADS.get(), (ItemLike)BWGBlocks.CLOVER_PATCH.get(), (ItemLike)BWGBlocks.LEAF_PILE.get(), (ItemLike)BWGBlocks.POISON_IVY.get(), BWGWood.MAHOGANY.leaves(), BWGWood.WILLOW.leaves(), BWGWood.MAPLE.leaves(), (ItemLike)BWGWood.YUCCA_LEAVES.get(), (ItemLike)BWGWood.FLOWERING_YUCCA_LEAVES.get(), (ItemLike)BWGWood.RIPE_YUCCA_LEAVES.get(), BWGWood.CYPRESS.leaves(), (ItemLike)BWGBlocks.LUSH_GRASS_BLOCK.get(), (ItemLike)BWGBlocks.OVERGROWN_DACITE.get(), (ItemLike)BWGBlocks.OVERGROWN_STONE.get()});
    }
}

