/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.rail;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ControllerRailBlock
extends BaseRailBlock
implements IWrenchable {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty BACKWARDS = BooleanProperty.m_61465_((String)"backwards");
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public ControllerRailBlock(BlockBehaviour.Properties properties) {
        super(true, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)BACKWARDS, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false)));
    }

    public static Vec3i getAccelerationVector(BlockState state) {
        Direction pointingTo = ControllerRailBlock.getPointingTowards(state);
        return (ControllerRailBlock.isStateBackwards(state) ? pointingTo.m_122424_() : pointingTo).m_122436_();
    }

    private static Direction getPointingTowards(BlockState state) {
        switch ((RailShape)state.m_61143_(SHAPE)) {
            case ASCENDING_WEST: 
            case EAST_WEST: {
                return Direction.WEST;
            }
            case ASCENDING_EAST: {
                return Direction.EAST;
            }
            case ASCENDING_SOUTH: {
                return Direction.SOUTH;
            }
        }
        return Direction.NORTH;
    }

    protected BlockState m_49367_(Level world, BlockPos pos, BlockState state, boolean p_208489_4_) {
        BlockState updatedState = super.m_49367_(world, pos, state, p_208489_4_);
        if (updatedState.m_61143_(SHAPE) == state.m_61143_(SHAPE)) {
            return updatedState;
        }
        BlockState reversedUpdatedState = updatedState;
        if (ControllerRailBlock.getPointingTowards(state).m_122434_() != ControllerRailBlock.getPointingTowards(updatedState).m_122434_()) {
            for (boolean opposite : Iterate.trueAndFalse) {
                Direction offset = ControllerRailBlock.getPointingTowards(updatedState);
                if (opposite) {
                    offset = offset.m_122424_();
                }
                for (BlockPos adjPos : Iterate.hereBelowAndAbove(pos.m_121945_(offset))) {
                    BlockState adjState = world.m_8055_(adjPos);
                    if (!AllBlocks.CONTROLLER_RAIL.has(adjState) || ControllerRailBlock.getPointingTowards(adjState).m_122434_() != offset.m_122434_() || adjState.m_61143_((Property)BACKWARDS) == reversedUpdatedState.m_61143_((Property)BACKWARDS)) continue;
                    reversedUpdatedState = (BlockState)reversedUpdatedState.m_61122_((Property)BACKWARDS);
                }
            }
        }
        if (reversedUpdatedState != updatedState) {
            world.m_46597_(pos, reversedUpdatedState);
        }
        return reversedUpdatedState;
    }

    private static void decelerateCart(BlockPos pos, AbstractMinecart cart) {
        Vec3 diff = VecHelper.getCenterOf((Vec3i)pos).m_82546_(cart.m_20182_());
        cart.m_20334_(diff.f_82479_ / 16.0, 0.0, diff.f_82481_ / 16.0);
        if (cart instanceof MinecartFurnace) {
            MinecartFurnace fme = (MinecartFurnace)cart;
            fme.f_38546_ = 0.0;
            fme.f_38545_ = 0.0;
        }
    }

    private static boolean isStableWith(BlockState testState, BlockGetter world, BlockPos pos) {
        return ControllerRailBlock.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_()) && (!((RailShape)testState.m_61143_(SHAPE)).m_61745_() || ControllerRailBlock.m_49936_((BlockGetter)world, (BlockPos)pos.m_121945_(ControllerRailBlock.getPointingTowards(testState))));
    }

    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        Direction direction = p_196258_1_.m_8125_();
        BlockState base = super.m_5573_(p_196258_1_);
        return (BlockState)(base == null ? this.m_49966_() : base).m_61124_((Property)BACKWARDS, (Comparable)Boolean.valueOf(direction.m_122421_() == Direction.AxisDirection.POSITIVE));
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{SHAPE, POWER, BACKWARDS, f_152149_});
    }

    public void onMinecartPass(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        Vec3 motion;
        if (world.f_46443_) {
            return;
        }
        Vec3 accelerationVec = Vec3.m_82528_((Vec3i)ControllerRailBlock.getAccelerationVector(state));
        double targetSpeed = cart.getMaxSpeedWithRail() * (double)((Integer)state.m_61143_((Property)POWER)).intValue() / 15.0;
        if (cart instanceof MinecartFurnace) {
            MinecartFurnace fme = (MinecartFurnace)cart;
            fme.f_38545_ = accelerationVec.f_82479_;
            fme.f_38546_ = accelerationVec.f_82481_;
        }
        if (((motion = cart.m_20184_()).m_82526_(accelerationVec) >= 0.0 || motion.m_82556_() < 1.0E-4) && targetSpeed > 0.0) {
            cart.m_20256_(accelerationVec.m_82490_(targetSpeed));
        } else {
            ControllerRailBlock.decelerateCart(pos, cart);
        }
    }

    protected void m_6360_(BlockState state, Level world, BlockPos pos, Block block) {
        int newPower = this.calculatePower(world, pos);
        if ((Integer)state.m_61143_((Property)POWER) != newPower) {
            this.placeAndNotify((BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), pos, world);
        }
    }

    private int calculatePower(Level world, BlockPos pos) {
        BlockPos testPos;
        int i;
        int newPower = world.m_277086_(pos);
        if (newPower != 0) {
            return newPower;
        }
        int forwardDistance = 0;
        int backwardsDistance = 0;
        BlockPos lastForwardRail = pos;
        BlockPos lastBackwardsRail = pos;
        int forwardPower = 0;
        int backwardsPower = 0;
        for (i = 0; i < 15 && (testPos = this.findNextRail(lastForwardRail, (BlockGetter)world, false)) != null; ++i) {
            ++forwardDistance;
            lastForwardRail = testPos;
            forwardPower = world.m_277086_(testPos);
            if (forwardPower != 0) break;
        }
        for (i = 0; i < 15 && (testPos = this.findNextRail(lastBackwardsRail, (BlockGetter)world, true)) != null; ++i) {
            ++backwardsDistance;
            lastBackwardsRail = testPos;
            backwardsPower = world.m_277086_(testPos);
            if (backwardsPower != 0) break;
        }
        if (forwardDistance > 8 && backwardsDistance > 8) {
            return 0;
        }
        if (backwardsPower == 0 && forwardDistance <= 8) {
            return forwardPower;
        }
        if (forwardPower == 0 && backwardsDistance <= 8) {
            return backwardsPower;
        }
        if (backwardsPower != 0 && forwardPower != 0) {
            return Mth.m_14165_((double)((double)(backwardsPower * forwardDistance + forwardPower * backwardsDistance) / (double)(forwardDistance + backwardsDistance)));
        }
        return 0;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        for (Rotation testRotation : new Rotation[]{Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180, Rotation.COUNTERCLOCKWISE_90}) {
            BlockState testState = this.m_6843_(state, testRotation);
            if (!ControllerRailBlock.isStableWith(testState, (BlockGetter)world, pos)) continue;
            this.placeAndNotify(testState, pos, world);
            return InteractionResult.SUCCESS;
        }
        BlockState testState = (BlockState)state.m_61124_((Property)BACKWARDS, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)BACKWARDS) == false));
        if (ControllerRailBlock.isStableWith(testState, (BlockGetter)world, pos)) {
            this.placeAndNotify(testState, pos, world);
        }
        return InteractionResult.SUCCESS;
    }

    private void placeAndNotify(BlockState state, BlockPos pos, Level world) {
        world.m_7731_(pos, state, 3);
        world.m_46672_(pos.m_7495_(), (Block)this);
        if (((RailShape)state.m_61143_(SHAPE)).m_61745_()) {
            world.m_46672_(pos.m_7494_(), (Block)this);
        }
    }

    @Nullable
    private BlockPos findNextRail(BlockPos from, BlockGetter world, boolean reversed) {
        BlockState current = world.m_8055_(from);
        if (!(current.m_60734_() instanceof ControllerRailBlock)) {
            return null;
        }
        Vec3i accelerationVec = ControllerRailBlock.getAccelerationVector(current);
        BlockPos baseTestPos = reversed ? from.m_121996_(accelerationVec) : from.m_121955_(accelerationVec);
        for (BlockPos testPos : Iterate.hereBelowAndAbove(baseTestPos)) {
            BlockState testState;
            if (testPos.m_123342_() > from.m_123342_() && !((RailShape)current.m_61143_(SHAPE)).m_61745_() || !((testState = world.m_8055_(testPos)).m_60734_() instanceof ControllerRailBlock) || !ControllerRailBlock.getAccelerationVector(testState).equals((Object)accelerationVec)) continue;
            return testPos;
        }
        return null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)POWER);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return state;
        }
        RailShape railshape = (RailShape)((BlockState)Blocks.f_50030_.m_49966_().m_61124_(SHAPE, (Comparable)((RailShape)state.m_61143_(SHAPE)))).m_60717_(rotation).m_61143_(SHAPE);
        state = (BlockState)state.m_61124_(SHAPE, (Comparable)railshape);
        if (rotation == Rotation.CLOCKWISE_180 || ControllerRailBlock.getPointingTowards(state).m_122434_() == Direction.Axis.Z == (rotation == Rotation.COUNTERCLOCKWISE_90)) {
            return (BlockState)state.m_61122_((Property)BACKWARDS);
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        RailShape railshape = (RailShape)((BlockState)Blocks.f_50030_.m_49966_().m_61124_(SHAPE, (Comparable)((RailShape)state.m_61143_(SHAPE)))).m_60715_(mirror).m_61143_(SHAPE);
        if (ControllerRailBlock.getPointingTowards(state = (BlockState)state.m_61124_(SHAPE, (Comparable)railshape)).m_122434_() == Direction.Axis.Z == (mirror == Mirror.LEFT_RIGHT)) {
            return (BlockState)state.m_61122_((Property)BACKWARDS);
        }
        return state;
    }

    public static boolean isStateBackwards(BlockState state) {
        return (Boolean)state.m_61143_((Property)BACKWARDS) ^ ControllerRailBlock.isReversedSlope(state);
    }

    public static boolean isReversedSlope(BlockState state) {
        return state.m_61143_(SHAPE) == RailShape.ASCENDING_SOUTH || state.m_61143_(SHAPE) == RailShape.ASCENDING_EAST;
    }
}

