/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.simpleRelays;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CogWheelBlock
extends AbstractSimpleShaftBlock
implements ICogWheel,
EncasableBlock {
    boolean isLarge;

    protected CogWheelBlock(boolean large, BlockBehaviour.Properties properties) {
        super(properties);
        this.isLarge = large;
    }

    public static CogWheelBlock small(BlockBehaviour.Properties properties) {
        return new CogWheelBlock(false, properties);
    }

    public static CogWheelBlock large(BlockBehaviour.Properties properties) {
        return new CogWheelBlock(true, properties);
    }

    @Override
    public boolean isLargeCog() {
        return this.isLarge;
    }

    @Override
    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((Direction.Axis)state.m_61143_((Property)AXIS));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, (Direction.Axis)state.m_61143_((Property)AXIS));
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.triggerShiftingGearsAdvancement(worldIn, pos, state, player);
        }
    }

    protected void triggerShiftingGearsAdvancement(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.f_46443_ || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.m_5484_(d1, offset1).m_5484_(d2, offset2);
                        BlockState blockState = world.m_8055_(connectedPos);
                        if (!(blockState.m_60734_() instanceof CogWheelBlock) || blockState.m_61143_((Property)AXIS) != axis || ICogWheel.isLargeCog(blockState) == this.isLarge) continue;
                        AllAdvancements.COGS.awardTo(player);
                    }
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        InteractionResult result = this.tryEncase(state, world, pos, heldItem, player, hand, ray);
        if (result.m_19077_()) {
            return result;
        }
        return InteractionResult.PASS;
    }

    public static boolean isValidCogwheelPosition(boolean large, LevelReader worldIn, BlockPos pos, Direction.Axis cogAxis) {
        for (Direction facing : Iterate.directions) {
            BlockPos offsetPos;
            BlockState blockState;
            if (facing.m_122434_() == cogAxis || (blockState = worldIn.m_8055_(offsetPos = pos.m_121945_(facing))).m_61138_((Property)AXIS) && facing.m_122434_() == blockState.m_61143_((Property)AXIS) || !ICogWheel.isLargeCog(blockState) && (!large || !ICogWheel.isSmallCog(blockState))) continue;
            return false;
        }
        return true;
    }

    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return context.m_43719_().m_122434_();
        }
        Level world = context.m_43725_();
        BlockState stateBelow = world.m_8055_(context.m_8083_().m_7495_());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLargeCog()) {
            return stateBelow.m_61143_(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        }
        BlockPos placedOnPos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState placedAgainst = world.m_8055_(placedOnPos);
        Block block = placedAgainst.m_60734_();
        if (ICogWheel.isSmallCog(placedAgainst)) {
            return ((IRotate)block).getRotationAxis(placedAgainst);
        }
        Direction.Axis preferredAxis = CogWheelBlock.getPreferredAxis(context);
        return preferredAxis != null ? preferredAxis : context.m_43719_().m_122434_();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean shouldWaterlog = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AXIS, (Comparable)this.getAxisForPlacement(context))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(shouldWaterlog));
    }

    @Override
    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    @Override
    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    @Override
    public boolean isDedicatedCogWheel() {
        return true;
    }
}

