/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.drain;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class ItemDrainRenderer
extends SmartBlockEntityRenderer<ItemDrainBlockEntity> {
    public ItemDrainRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(ItemDrainBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        this.renderFluid(be, partialTicks, ms, buffer, light);
        this.renderItem(be, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(ItemDrainBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean alongX;
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        Vec3 itemPosition = VecHelper.getCenterOf((Vec3i)be.m_58899_());
        Direction insertedFrom = transported.insertedFrom;
        if (!insertedFrom.m_122434_().m_122479_()) {
            return;
        }
        ms.m_85836_();
        ms.m_252880_(0.5f, 0.9375f, 0.5f);
        msr.nudge(0);
        float offset = Mth.m_14179_((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
        float sideOffset = Mth.m_14179_((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
        Vec3 offsetVec = Vec3.m_82528_((Vec3i)insertedFrom.m_122424_().m_122436_()).m_82490_((double)(0.5f - offset));
        ms.m_85837_(offsetVec.f_82479_, offsetVec.f_82480_, offsetVec.f_82481_);
        boolean bl = alongX = insertedFrom.m_122427_().m_122434_() == Direction.Axis.X;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        ms.m_252880_(alongX ? sideOffset : 0.0f, 0.0f, alongX ? 0.0f : sideOffset);
        ItemStack itemStack = transported.stack;
        Random r = new Random(0L);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        int count = Mth.m_14173_((int)itemStack.m_41613_()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright(itemStack);
        BakedModel bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean blockItem = bakedModel.m_7539_();
        if (renderUpright) {
            ms.m_85837_(0.0, 0.09375, 0.0);
        }
        int positive = insertedFrom.m_122421_().m_122540_();
        float verticalAngle = (float)positive * offset * 360.0f;
        if (insertedFrom.m_122434_() != Direction.Axis.X) {
            msr.rotateX((double)verticalAngle);
        }
        if (insertedFrom.m_122434_() != Direction.Axis.Z) {
            msr.rotateZ((double)(-verticalAngle));
        }
        if (renderUpright) {
            Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
            if (renderViewEntity != null) {
                Vec3 positionVec = renderViewEntity.m_20182_();
                Vec3 vectorForOffset = itemPosition.m_82549_(offsetVec);
                Vec3 diff = vectorForOffset.m_82546_(positionVec);
                if (insertedFrom.m_122434_() != Direction.Axis.X) {
                    diff = VecHelper.rotate(diff, verticalAngle, Direction.Axis.X);
                }
                if (insertedFrom.m_122434_() != Direction.Axis.Z) {
                    diff = VecHelper.rotate(diff, -verticalAngle, Direction.Axis.Z);
                }
                float yRot = (float)Mth.m_14136_((double)diff.f_82481_, (double)(-diff.f_82479_));
                ms.m_252781_(Axis.f_252436_.m_252961_((float)((double)yRot - 1.5707963267948966)));
            }
            ms.m_252880_(0.0f, 0.0f, -0.0625f);
        }
        for (int i = 0; i <= count; ++i) {
            ms.m_85836_();
            if (blockItem) {
                ms.m_252880_(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                msr.rotateX(90.0);
            }
            itemRenderer.m_115143_(itemStack, ItemDisplayContext.FIXED, false, ms, buffer, light, overlay, bakedModel);
            ms.m_85849_();
            if (!renderUpright) {
                if (!blockItem) {
                    msr.rotateY(10.0);
                }
                ms.m_85837_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.m_252880_(0.0f, 0.0f, -0.0625f);
        }
        ms.m_85849_();
    }

    protected void renderFluid(ItemDrainBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        ItemStack heldItemStack;
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            float yMin = 0.3125f;
            float min = 0.125f;
            float max = min + 0.75f;
            float yOffset = 0.4375f * level;
            ms.m_85836_();
            ms.m_252880_(0.0f, yOffset, 0.0f);
            FluidRenderer.renderFluidBox(fluidStack, min, yMin - yOffset, min, max, yMin, max, buffer, ms, light, false);
            ms.m_85849_();
        }
        if ((heldItemStack = be.getHeldItemStack()).m_41619_()) {
            return;
        }
        FluidStack fluidStack2 = GenericItemEmptying.emptyItem(be.m_58904_(), heldItemStack, true).getFirst();
        if (fluidStack2.isEmpty()) {
            if (fluidStack.isEmpty()) {
                return;
            }
            fluidStack2 = fluidStack;
        }
        int processingTicks = be.processingTicks;
        float processingPT = (float)be.processingTicks - partialTicks;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = Mth.m_14036_((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = 0.0f;
        if (processingTicks != -1) {
            radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
            AABB bb = new AABB(0.5, 1.0, 0.5, 0.5, 0.25, 0.5).m_82400_((double)(radius / 32.0f));
            FluidRenderer.renderFluidBox(fluidStack2, (float)bb.f_82288_, (float)bb.f_82289_, (float)bb.f_82290_, (float)bb.f_82291_, (float)bb.f_82292_, (float)bb.f_82293_, buffer, ms, light, true);
        }
    }
}

