/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.AbstractCaveGenerationStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class OceanTrenchStructurePiece
extends AbstractCaveGenerationStructurePiece {
    private BlockState water = Fluids.f_76193_.m_76145_().m_76188_();
    private static final Direction[] WALL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public OceanTrenchStructurePiece(BlockPos chunkCorner, BlockPos holeCenter, int bowlHeight, int bowlRadius) {
        super((StructurePieceType)ACStructurePieceRegistry.OCEAN_TRENCH.get(), chunkCorner, holeCenter, bowlHeight, bowlRadius, -64, 100);
    }

    public OceanTrenchStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.OCEAN_TRENCH.get(), tag);
    }

    public OceanTrenchStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        int seaLevel = chunkGen.m_6337_();
        boolean flag = false;
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveCliff = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveBelow = new BlockPos.MutableBlockPos();
        carve.m_122178_(cornerX, cornerY, cornerZ);
        carveCliff.m_122178_(cornerX, cornerY, cornerZ);
        carveBelow.m_122178_(cornerX, cornerY, cornerZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                MutableBoolean doFloor = new MutableBoolean(false);
                int carveX = cornerX + x;
                int carveZ = cornerZ + z;
                int priorHeight = this.getSeafloorHeight(level, carveX, carveZ);
                float seaFloorExtra = (1.0f + ACMath.sampleNoise2D(carveX - 800, carveZ - 212, 20.0f)) * 5.0f;
                int minY = (int)((float)(level.m_141937_() + 2) + seaFloorExtra);
                for (int y = priorHeight + 3; y >= minY; --y) {
                    carve.m_122178_(carveX, Mth.m_14045_((int)y, (int)minY, (int)level.m_151558_()), carveZ);
                    if (carve.m_123342_() > seaLevel - 2 || !this.shouldDig(level, carve, seaLevel, priorHeight)) continue;
                    if (this.isSeaMountBlocking((BlockPos)carve)) {
                        BlockState prior = this.checkedGetBlock(level, (BlockPos)carve);
                        if (prior.m_60713_(Blocks.f_50752_)) continue;
                        this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_152496_.m_49966_());
                        continue;
                    }
                    flag = true;
                    carveBelow.m_122178_(carve.m_123341_(), carve.m_123342_() - 1, carve.m_123343_());
                    this.setWater(level, carve, priorHeight);
                    doFloor.setTrue();
                }
                if (!doFloor.isTrue()) continue;
                this.decorateFloor(level, random, carveBelow, seaLevel);
                for (Direction direction : WALL_DIRECTIONS) {
                    carveCliff.m_122178_(carveX, carveBelow.m_123342_() + 1, carveZ);
                    carveCliff.m_122173_(direction);
                    BlockState state = level.m_8055_(carveCliff.m_175288_(this.holeCenter.m_123342_()));
                    if (this.shouldDig(level, carveCliff, seaLevel, priorHeight) || state.m_204336_(ACTagRegistry.TRENCH_GENERATION_IGNORES) || state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                    BlockPos.MutableBlockPos wallPos = new BlockPos.MutableBlockPos(carveCliff.m_123341_(), level.m_141937_() + 1, carveCliff.m_123343_());
                    boolean seaMountBeneath = false;
                    while (wallPos.m_123342_() < priorHeight - 2) {
                        wallPos.m_122184_(0, 1, 0);
                        if (!seaMountBeneath || !level.m_8055_((BlockPos)wallPos).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                            this.setWallBlock(level, (BlockPos)wallPos, priorHeight);
                        }
                        if (!this.isSeaMountBlocking((BlockPos)wallPos)) continue;
                        seaMountBeneath = true;
                    }
                }
            }
            if (!flag) continue;
            this.replaceBiomes(level, ACBiomeRegistry.ABYSSAL_CHASM, 16);
        }
    }

    private int getSeafloorHeight(WorldGenLevel level, int x, int z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x, z), z);
        int yPrev = mutableBlockPos.m_123342_();
        mutableBlockPos.m_142448_(level.m_5736_() + 5);
        boolean inFrozenOcean = level.m_204166_((BlockPos)mutableBlockPos).m_203656_(ACTagRegistry.TRENCH_IGNORES_STONE_IN);
        mutableBlockPos.m_142448_(yPrev);
        while (this.ignoreHeight(level, inFrozenOcean, this.checkedGetBlock(level, (BlockPos)mutableBlockPos), mutableBlockPos) && mutableBlockPos.m_123342_() >= -64) {
            mutableBlockPos.m_122184_(0, -1, 0);
        }
        return mutableBlockPos.m_123342_();
    }

    private boolean ignoreHeight(WorldGenLevel level, boolean inFrozenOcean, BlockState blockState, BlockPos.MutableBlockPos mutableBlockPos) {
        return blockState.m_60795_() || blockState.m_204336_(ACTagRegistry.TRENCH_GENERATION_IGNORES) || !blockState.m_60819_().m_76178_() || inFrozenOcean && blockState.m_204336_(BlockTags.f_215820_) && mutableBlockPos.m_123342_() > level.m_5736_() - 5;
    }

    private void setWallBlock(WorldGenLevel level, BlockPos carve, int priorHeight) {
        BlockState prior = this.checkedGetBlock(level, carve);
        if (!(prior.m_60713_(Blocks.f_50752_) || prior.m_204336_(ACTagRegistry.TRENCH_GENERATION_IGNORES) || this.isSeaMountBlocking(carve))) {
            int dist = priorHeight - carve.m_123342_();
            int layerOffset = level.m_213780_().m_188503_(2);
            BlockState toSet = prior.m_60713_(Blocks.f_49991_) ? Blocks.f_50450_.m_49966_() : (dist <= 5 + layerOffset ? (carve.m_123342_() < 0 ? Blocks.f_152550_.m_49966_() : Blocks.f_50069_.m_49966_()) : (dist <= 12 + layerOffset ? Blocks.f_152550_.m_49966_() : ((Block)ACBlockRegistry.ABYSSMARINE.get()).m_49966_()));
            level.m_7731_(carve, toSet, 128);
        }
    }

    private double getRadiusSq(BlockPos.MutableBlockPos carve) {
        float simplex1 = ACMath.sampleNoise2D(carve.m_123341_(), carve.m_123343_(), 30.0f);
        float simplex2 = ACMath.sampleNoise2D(carve.m_123341_() + 1000, carve.m_123343_() - 1000, 100.0f);
        float widthSimplexNoise1 = 0.8f + 0.2f * (1.0f + simplex1 + simplex2) * 0.5f;
        return widthSimplexNoise1 * (float)this.radius * (float)this.radius;
    }

    private boolean shouldDig(WorldGenLevel level, BlockPos.MutableBlockPos carve, int seaLevel, int priorHeight) {
        double targetRadius;
        double yDist = this.calcYDist(level, carve, seaLevel, priorHeight);
        double distToCenter = carve.m_203202_((double)this.holeCenter.m_123341_(), (double)(carve.m_123342_() - 1), (double)this.holeCenter.m_123343_());
        double radiusXZ = this.getRadiusSq(carve);
        double cornerAmount = radiusXZ - distToCenter;
        if (cornerAmount > 0.0 && cornerAmount <= 100.0) {
            yDist *= (double)((float)(cornerAmount / 100.0));
        }
        return distToCenter <= (targetRadius = yDist * radiusXZ);
    }

    private boolean isSeaMountBlocking(BlockPos carve) {
        int bottomedY = carve.m_123342_() + 64;
        float heightTarget = 20.0f + ACMath.sampleNoise3D(carve.m_123341_() - 440, 0, carve.m_123343_() + 412, 30.0f) * 10.0f + ACMath.sampleNoise3D(carve.m_123341_() - 110, 0, carve.m_123343_() + 110, 10.0f) * 3.0f;
        float heightScale = (heightTarget - (float)bottomedY) / (heightTarget + 15.0f);
        float sample = ACMath.sampleNoise3D(carve.m_123341_(), 0, carve.m_123343_(), 50.0f) + ACMath.sampleNoise3D(carve.m_123341_() - 440, 0, carve.m_123343_() + 412, 11.0f) * 0.2f + ACMath.sampleNoise3D(carve.m_123341_() - 100, 0, carve.m_123343_() - 400, 100.0f) * 0.3f - 0.1f;
        return sample >= 0.4f * Math.max(0.0f, 1.0f - heightScale);
    }

    private void setWater(WorldGenLevel level, BlockPos.MutableBlockPos center, int priorHeight) {
        this.checkedSetBlock(level, (BlockPos)center, this.water);
    }

    private double calcYDist(WorldGenLevel level, BlockPos.MutableBlockPos carve, int seaLevel, int priorHeight) {
        int j = -64 - carve.m_123342_();
        if (carve.m_123342_() >= seaLevel + 1 || j > 0 || priorHeight >= seaLevel - 3) {
            return 0.0;
        }
        float belowSeaBy = ACMath.smin((float)(seaLevel - priorHeight) / 120.0f, 1.0f, 0.2f);
        float bedrockCloseness = ACMath.smin((float)Math.abs(j) / 50.0f - 0.1f, 1.0f, 0.2f);
        float df1 = ACMath.sampleNoise3D(carve.m_123341_(), 0, carve.m_123343_(), 100.0f) * 0.6f;
        float df2 = ACMath.sampleNoise3D(carve.m_123341_() - 450, 0, carve.m_123343_() + 450, 300.0f) * 0.25f;
        return ACMath.smin(belowSeaBy * (bedrockCloseness - df1) - df2, 0.9f, 0.2f) - df2;
    }

    private void decorateFloor(WorldGenLevel level, RandomSource rand, BlockPos.MutableBlockPos muckAt, int seaLevel) {
        if (!this.isSeaMountBlocking((BlockPos)muckAt) && muckAt.m_123342_() < seaLevel - 32) {
            this.checkedSetBlock(level, (BlockPos)muckAt, ((Block)ACBlockRegistry.MUCK.get()).m_49966_());
            for (int i = 0; i < 1 + rand.m_188503_(2); ++i) {
                muckAt.m_122184_(0, -1, 0);
                BlockState at = this.checkedGetBlock(level, (BlockPos)muckAt);
                if (at.m_204336_(ACTagRegistry.UNMOVEABLE) || at.m_204336_(ACTagRegistry.TRENCH_GENERATION_IGNORES)) break;
                if (!at.m_60819_().m_76178_() && !at.m_60819_().m_205070_(FluidTags.f_13131_)) {
                    this.checkedSetBlock(level, (BlockPos)muckAt, Blocks.f_152550_.m_49966_());
                    continue;
                }
                this.checkedSetBlock(level, (BlockPos)muckAt, ((Block)ACBlockRegistry.MUCK.get()).m_49966_());
            }
        }
    }
}

