/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GobstopperGeodeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Block[] GRADIENT_BLOCKS = new Block[]{(Block)ACBlockRegistry.RED_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get(), (Block)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIME_ROCK_CANDY.get(), (Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (Block)ACBlockRegistry.ORANGE_ROCK_CANDY.get()};

    public GobstopperGeodeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        if (!level.m_8055_(pos).m_60795_()) {
            boolean eatenQuadX = randomSource.m_188499_();
            boolean eatenQuadY = pos.m_123342_() < -10;
            boolean eatenQuadZ = randomSource.m_188499_();
            int width = 7;
            BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
            for (int x = -width; x <= width; ++x) {
                for (int y = -width; y <= width; ++y) {
                    for (int z = -width; z <= width; ++z) {
                        pos1.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                        float sprinkleNoise = Math.abs(ACMath.sampleNoise3D(pos1.m_123341_() + 231, pos1.m_123342_() + 221, pos1.m_123343_() + 3211, 3.0f));
                        int exteriorShellBy = (int)Mth.m_14005_((double)x, (double)Mth.m_14005_((double)y, (double)z));
                        int taxicab = pos1.m_123333_((Vec3i)pos);
                        if ((eatenQuadX ? x > 0 : x < 0) && (eatenQuadY ? y > 0 : y < 0) && (!eatenQuadZ ? z < 0 : z > 0) || level.m_8055_((BlockPos)pos1).m_60713_(Blocks.f_50752_)) continue;
                        if (exteriorShellBy < width) {
                            int gradientBy = (int)((float)exteriorShellBy / (float)width * (float)GRADIENT_BLOCKS.length);
                            BlockState gradientState = GRADIENT_BLOCKS[Mth.m_14045_((int)gradientBy, (int)0, (int)(GRADIENT_BLOCKS.length - 1))].m_49966_();
                            level.m_7731_((BlockPos)pos1, gradientState, 3);
                            continue;
                        }
                        if (!(randomSource.m_188501_() < 0.95f) || !((double)sprinkleNoise < 0.9) || taxicab >= width * 3 - 1 || Math.abs(x) == Math.abs(y) && Math.abs(x) == width || Math.abs(x) == Math.abs(z) && Math.abs(x) == width || Math.abs(y) == Math.abs(z) && Math.abs(y) == width) continue;
                        BlockState exteriorState = ((Block)ACBlockRegistry.WHITE_ROCK_CANDY.get()).m_49966_();
                        if (randomSource.m_188501_() < 0.035f) {
                            float color = randomSource.m_188501_();
                            exteriorState = color < 0.33f ? ((Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get()).m_49966_() : (color < 0.66f ? ((Block)ACBlockRegistry.PINK_ROCK_CANDY.get()).m_49966_() : ((Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get()).m_49966_());
                        }
                        level.m_7731_((BlockPos)pos1, exteriorState, 3);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

