/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MusselBlock;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MarineSnowItem
extends Item {
    private static Map<Block, Block> GROWS_INTERACTIONS;
    private static Map<Block, ItemStack> DUPLICATES_INTERACTIONS;

    public MarineSnowItem() {
        super(new Item.Properties());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        this.initGrowth();
        BlockState clickedState = context.m_43725_().m_8055_(context.m_8083_());
        if (MarineSnowItem.scanForWater(clickedState, (BlockGetter)context.m_43725_(), context.m_8083_())) {
            boolean flag = false;
            if (GROWS_INTERACTIONS.containsKey(clickedState.m_60734_())) {
                flag = true;
                BlockState transform = GROWS_INTERACTIONS.getOrDefault(clickedState.m_60734_(), Blocks.f_50016_).m_49966_();
                for (Property prop : clickedState.m_61147_()) {
                    transform = transform.m_61138_(prop) ? (BlockState)transform.m_61124_(prop, clickedState.m_61143_(prop)) : transform;
                }
                context.m_43725_().m_46597_(context.m_8083_(), transform);
            } else if (DUPLICATES_INTERACTIONS.containsKey(clickedState.m_60734_())) {
                flag = true;
                if (context.m_43725_().m_213780_().m_188503_(2) == 0) {
                    ItemStack spawn = DUPLICATES_INTERACTIONS.getOrDefault(clickedState.m_60734_(), ItemStack.f_41583_);
                    Vec3 spawnItemAt = context.m_43720_();
                    ItemEntity itemEntity = new ItemEntity(context.m_43725_(), spawnItemAt.f_82479_, spawnItemAt.f_82480_, spawnItemAt.f_82481_, spawn);
                    context.m_43725_().m_7967_((Entity)itemEntity);
                }
            } else if (clickedState.m_60713_((Block)ACBlockRegistry.MUSSEL.get()) && (Integer)clickedState.m_61143_((Property)MusselBlock.MUSSELS) < 5) {
                flag = true;
                context.m_43725_().m_46597_(context.m_8083_(), (BlockState)clickedState.m_61124_((Property)MusselBlock.MUSSELS, (Comparable)Integer.valueOf((Integer)clickedState.m_61143_((Property)MusselBlock.MUSSELS) + 1)));
            }
            if (flag) {
                if (!context.m_43725_().f_46443_) {
                    context.m_43725_().m_46796_(1505, context.m_8083_(), 0);
                }
                if (!context.m_43723_().m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean scanForWater(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        if (blockState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!blockGetter.m_6425_(blockPos.m_121945_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    private void initGrowth() {
        if (GROWS_INTERACTIONS != null && DUPLICATES_INTERACTIONS != null) {
            return;
        }
        GROWS_INTERACTIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(Blocks.f_50579_, Blocks.f_50584_);
            map.put(Blocks.f_50580_, Blocks.f_50585_);
            map.put(Blocks.f_50581_, Blocks.f_50586_);
            map.put(Blocks.f_50582_, Blocks.f_50587_);
            map.put(Blocks.f_50583_, Blocks.f_50588_);
            map.put(Blocks.f_50589_, Blocks.f_50594_);
            map.put(Blocks.f_50590_, Blocks.f_50595_);
            map.put(Blocks.f_50591_, Blocks.f_50596_);
            map.put(Blocks.f_50592_, Blocks.f_50597_);
            map.put(Blocks.f_50593_, Blocks.f_50598_);
            map.put(Blocks.f_50547_, Blocks.f_50552_);
            map.put(Blocks.f_50548_, Blocks.f_50553_);
            map.put(Blocks.f_50549_, Blocks.f_50554_);
            map.put(Blocks.f_50550_, Blocks.f_50555_);
            map.put(Blocks.f_50551_, Blocks.f_50556_);
            map.put(Blocks.f_50557_, Blocks.f_50562_);
            map.put(Blocks.f_50558_, Blocks.f_50563_);
            map.put(Blocks.f_50559_, Blocks.f_50564_);
            map.put(Blocks.f_50560_, Blocks.f_50565_);
            map.put(Blocks.f_50561_, Blocks.f_50566_);
        });
        DUPLICATES_INTERACTIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(Blocks.f_50584_, new ItemStack((ItemLike)Blocks.f_50584_));
            map.put(Blocks.f_50585_, new ItemStack((ItemLike)Blocks.f_50585_));
            map.put(Blocks.f_50586_, new ItemStack((ItemLike)Blocks.f_50586_));
            map.put(Blocks.f_50587_, new ItemStack((ItemLike)Blocks.f_50587_));
            map.put(Blocks.f_50588_, new ItemStack((ItemLike)Blocks.f_50588_));
            map.put(Blocks.f_50594_, new ItemStack((ItemLike)Blocks.f_50594_));
            map.put(Blocks.f_50595_, new ItemStack((ItemLike)Blocks.f_50595_));
            map.put(Blocks.f_50596_, new ItemStack((ItemLike)Blocks.f_50596_));
            map.put(Blocks.f_50597_, new ItemStack((ItemLike)Blocks.f_50597_));
            map.put(Blocks.f_50598_, new ItemStack((ItemLike)Blocks.f_50598_));
            map.put(Blocks.f_50552_, new ItemStack((ItemLike)Blocks.f_50552_));
            map.put(Blocks.f_50553_, new ItemStack((ItemLike)Blocks.f_50553_));
            map.put(Blocks.f_50554_, new ItemStack((ItemLike)Blocks.f_50554_));
            map.put(Blocks.f_50555_, new ItemStack((ItemLike)Blocks.f_50555_));
            map.put(Blocks.f_50556_, new ItemStack((ItemLike)Blocks.f_50556_));
            map.put(Blocks.f_50562_, new ItemStack((ItemLike)Blocks.f_50562_));
            map.put(Blocks.f_50563_, new ItemStack((ItemLike)Blocks.f_50563_));
            map.put(Blocks.f_50564_, new ItemStack((ItemLike)Blocks.f_50564_));
            map.put(Blocks.f_50565_, new ItemStack((ItemLike)Blocks.f_50565_));
            map.put(Blocks.f_50566_, new ItemStack((ItemLike)Blocks.f_50566_));
            map.put(Blocks.f_50056_, new ItemStack((ItemLike)Blocks.f_50057_));
            map.put(Blocks.f_50057_, new ItemStack((ItemLike)Blocks.f_50057_));
            map.put((Block)ACBlockRegistry.DUSK_ANEMONE.get(), new ItemStack((ItemLike)ACBlockRegistry.DUSK_ANEMONE.get()));
            map.put((Block)ACBlockRegistry.TWILIGHT_ANEMONE.get(), new ItemStack((ItemLike)ACBlockRegistry.TWILIGHT_ANEMONE.get()));
            map.put((Block)ACBlockRegistry.MIDNIGHT_ANEMONE.get(), new ItemStack((ItemLike)ACBlockRegistry.MIDNIGHT_ANEMONE.get()));
        });
    }
}

